/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.gradle.dsl.common.util;

import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.beans.Transient;
import java.io.Serializable;
import java.lang.invoke.CallSite;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import net.neoforged.gradle.dsl.common.extensions.MinecraftArtifactCache;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.StringGroovyMethods;
import org.codehaus.groovy.runtime.dgmimpl.NumberNumberMinus;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.transform.ImmutableASTTransformation;
import org.codehaus.groovy.vmplugin.v8.IndyInterface;
import org.gradle.api.Project;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Optional;
import org.jetbrains.annotations.Nullable;

public final class CacheableMinecraftVersion
implements Comparable<CacheableMinecraftVersion>,
Serializable,
GroovyObject {
    private final Type type;
    private final String full;
    private final int[] nearest;
    private final int week;
    private final int year;
    private final int pre;
    private final String revision;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ ClassInfo $staticClassInfo$;

    private CacheableMinecraftVersion(Type type, String full, int week, int year, int pre, @Nullable String revision, int ... nearest) {
        String string;
        int n;
        int n2;
        int n3;
        String string2;
        Type type2;
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
        this.type = type2 = type;
        this.full = string2 = full;
        int[] nArray = nearest;
        this.nearest = nArray;
        this.week = n3 = week;
        this.year = n2 = year;
        this.pre = n = pre;
        this.revision = string = revision;
    }

    /*
     * Loose catch block
     */
    public static CacheableMinecraftVersion from(String version, Project project) {
        CallSite cache = IndyInterface.bootstrap("cast", "()", 0, project.getExtensions().getByType(MinecraftArtifactCache.class));
        String resolvedVersion = cache.resolveVersion(version);
        CacheableMinecraftVersion cacheableMinecraftVersion = CacheableMinecraftVersion.get(resolvedVersion);
        try {
            return cacheableMinecraftVersion;
        }
        catch (IllegalArgumentException e) {
            throw (Throwable)e;
        }
        catch (Exception e2) {
            throw (Throwable)new IllegalArgumentException(StringGroovyMethods.plus((String)"Unknown version: ", (CharSequence)version), e2);
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
    }

    private static String fromSnapshot(int year, int week) {
        int value = year * 100 + week;
        if (value >= 1147 && value <= 1201) {
            return "1.1";
        }
        if (value >= 1203 && value <= 1208) {
            return "1.2";
        }
        if (value >= 1215 && value <= 1230) {
            return "1.3";
        }
        if (value >= 1232 && value <= 1242) {
            return "1.4";
        }
        if (value >= 1249 && value <= 1250) {
            return "1.4.6";
        }
        if (value >= 1301 && value <= 1310) {
            return "1.5";
        }
        if (value >= 1311 && value <= 1312) {
            return "1.5.1";
        }
        if (value >= 1316 && value <= 1326) {
            return "1.6";
        }
        if (value >= 1336 && value <= 1343) {
            return "1.7";
        }
        if (value >= 1347 && value <= 1349) {
            return "1.7.4";
        }
        if (value >= 1402 && value <= 1434) {
            return "1.8";
        }
        if (value >= 1531 && value <= 1607) {
            return "1.9";
        }
        if (value >= 1614 && value <= 1615) {
            return "1.9.3";
        }
        if (value >= 1620 && value <= 1621) {
            return "1.10";
        }
        if (value >= 1632 && value <= 1644) {
            return "1.11";
        }
        if (value == 1650) {
            return "1.11.1";
        }
        if (value >= 1706 && value <= 1718) {
            return "1.12";
        }
        if (value == 1731) {
            return "1.12.1";
        }
        if (value >= 1743 && value <= 1822) {
            return "1.13";
        }
        if (value >= 1830 && value <= 1833) {
            return "1.13.1";
        }
        if (value >= 1843 && value <= 1914) {
            return "1.14";
        }
        if (value >= 1934 && value <= 1946) {
            return "1.15";
        }
        if (value >= 2006 && value <= 2022) {
            return "1.16";
        }
        if (value >= 2027 && value <= 2030) {
            return "1.16.2";
        }
        if (value >= 2045 && value <= 2120) {
            return "1.17";
        }
        if (value >= 2137 && value <= 2144) {
            return "1.18";
        }
        if (value >= 2203 && value <= 2207) {
            return "1.18.2";
        }
        if (value >= 2211 && value <= 9999) {
            return "1.19";
        }
        throw (Throwable)new IllegalArgumentException(StringGroovyMethods.plus((CharSequence)"Invalid snapshot date: ", (Object)value));
    }

    private static int[] splitDots(String version) {
        Object[] pts = version.split("\\.");
        int[] values = new int[pts.length];
        int x = 0;
        while (x < pts.length) {
            int n = Integer.parseInt((String)((Object)IndyInterface.bootstrap("cast", "()", 0, BytecodeInterface8.objectArrayGet((Object[])pts, (int)x))));
            IndyInterface.staticArrayAccess("set", (int[])values, (int)x, (int)n);
            int n2 = x;
            int cfr_ignored_0 = n2 + 1;
        }
        return values;
    }

    @Input
    public Type getType() {
        return this.type;
    }

    @Input
    public String getFull() {
        return this.full;
    }

    @Input
    public int[] getNearest() {
        return this.nearest;
    }

    @Input
    public int getWeek() {
        return this.week;
    }

    @Input
    public int getYear() {
        return this.year;
    }

    @Input
    public int getPre() {
        return this.pre;
    }

    @Input
    @Optional
    @Nullable
    public String getRevision() {
        return this.revision;
    }

    private static CacheableMinecraftVersion get(String version) {
        String lower = version.toLowerCase(Locale.ENGLISH);
        char first = version.charAt(0);
        int preIntCodePoint = DefaultGroovyMethods.minus((Character)Character.valueOf(((Character)((Object)IndyInterface.bootstrap("invoke", "asType", 0, "a", Character.class))).charValue()), (Number)1).intValue();
        String preA = Character.toString((char)preIntCodePoint);
        if (ScriptBytecodeAdapter.compareEqual((Object)"15w14a", (Object)lower)) {
            return new CacheableMinecraftVersion(Type.SNAPSHOT, version, 14, 15, 0, "a", CacheableMinecraftVersion.splitDots("1.10"));
        }
        if (ScriptBytecodeAdapter.compareEqual((Object)"1.rv-pre1", (Object)lower)) {
            return new CacheableMinecraftVersion(Type.SNAPSHOT, version, 14, 16, 0, preA, CacheableMinecraftVersion.splitDots("1.9.3"));
        }
        if (ScriptBytecodeAdapter.compareEqual((Object)"3d shareware v1.34", (Object)lower)) {
            return new CacheableMinecraftVersion(Type.SNAPSHOT, version, 14, 19, 0, preA, CacheableMinecraftVersion.splitDots("1.14"));
        }
        if (ScriptBytecodeAdapter.compareEqual((Object)"20w14infinite", (Object)lower)) {
            return new CacheableMinecraftVersion(Type.SNAPSHOT, version, 14, 20, 0, preA, CacheableMinecraftVersion.splitDots("1.16"));
        }
        if (ScriptBytecodeAdapter.compareEqual((Object)"22w13oneblockatatime", (Object)lower)) {
            return new CacheableMinecraftVersion(Type.SNAPSHOT, version, 13, 22, 0, "b", CacheableMinecraftVersion.splitDots("1.19"));
        }
        if (ScriptBytecodeAdapter.compareEqual((Object)"inf-20100618", (Object)lower)) {
            return new CacheableMinecraftVersion(Type.ALPHA, version, 25, 10, 0, "a", CacheableMinecraftVersion.splitDots("1.0.4"));
        }
        if (ScriptBytecodeAdapter.compareEqual((Object)"c0.0.13a_03", (Object)lower)) {
            return new CacheableMinecraftVersion(Type.ALPHA, version, -1, -1, 0, preA, CacheableMinecraftVersion.splitDots("0.0.13"));
        }
        if (lower.startsWith("rd-")) {
            String rev = null;
            String string = lower;
            if (ScriptBytecodeAdapter.isCase((Object)string, (Object)"rd-132211")) {
                rev = "a";
            } else if (ScriptBytecodeAdapter.isCase((Object)string, (Object)"rd-132328")) {
                rev = "b";
            } else if (ScriptBytecodeAdapter.isCase((Object)string, (Object)"rd-20090515")) {
                rev = "c";
            } else if (ScriptBytecodeAdapter.isCase((Object)string, (Object)"rd-160052")) {
                rev = "d";
            } else if (ScriptBytecodeAdapter.isCase((Object)string, (Object)"rd-161348")) {
                rev = "e";
            } else {
                throw (Throwable)new IllegalArgumentException(StringGroovyMethods.plus((String)"Unknown 'rd' version: ", (CharSequence)version));
            }
            return new CacheableMinecraftVersion(Type.ALPHA, version, 20, 9, 0, rev, CacheableMinecraftVersion.splitDots("0.0.1"));
        }
        if (first == ((Character)((Object)IndyInterface.bootstrap("invoke", "asType", 0, "a", Character.class))).charValue() || first == ((Character)((Object)IndyInterface.bootstrap("invoke", "asType", 0, "b", Character.class))).charValue() || first == ((Character)((Object)IndyInterface.bootstrap("invoke", "asType", 0, "c", Character.class))).charValue()) {
            String clean = version.substring(1).replace("_", ".");
            String nearest = clean;
            String rev = null;
            char end = clean.charAt(clean.length() - 1);
            if (end < ((Character)((Object)IndyInterface.bootstrap("invoke", "asType", 0, "0", Character.class))).charValue() || end > ((Character)((Object)IndyInterface.bootstrap("invoke", "asType", 0, "9", Character.class))).charValue()) {
                rev = Character.toString(end);
                nearest = clean.substring(0, clean.length() - 1);
            }
            return new CacheableMinecraftVersion(first == ((Character)((Object)IndyInterface.bootstrap("invoke", "asType", 0, "b", Character.class))).charValue() ? Type.BETA : Type.ALPHA, version, -1, -1, 0, rev, CacheableMinecraftVersion.splitDots(nearest));
        }
        if (version.length() == 6 && version.charAt(2) == ((Character)((Object)IndyInterface.bootstrap("invoke", "asType", 0, "w", Character.class))).charValue()) {
            int year = Integer.parseInt(version.substring(0, 2));
            int week = Integer.parseInt(version.substring(3, 5));
            return new CacheableMinecraftVersion(Type.SNAPSHOT, version, week, year, 0, version.substring(5), CacheableMinecraftVersion.splitDots(CacheableMinecraftVersion.fromSnapshot(year, week)));
        }
        int pre = 0;
        Object nearest = version;
        if (version.contains("-pre")) {
            Object[] pts = version.split("-pre");
            pre = Integer.parseInt((String)((Object)IndyInterface.bootstrap("cast", "()", 0, BytecodeInterface8.objectArrayGet((Object[])pts, (int)1))));
            nearest = IndyInterface.bootstrap("cast", "()", 0, BytecodeInterface8.objectArrayGet((Object[])pts, (int)0));
        } else if (version.contains("_Pre-Release_")) {
            Object[] pts = version.split("_Pre-Release_");
            pre = Integer.parseInt((String)((Object)IndyInterface.bootstrap("cast", "()", 0, BytecodeInterface8.objectArrayGet((Object[])pts, (int)1))));
            nearest = IndyInterface.bootstrap("cast", "()", 0, BytecodeInterface8.objectArrayGet((Object[])pts, (int)0));
        } else if (version.contains(" Pre-Release ")) {
            Object[] pts = version.split(" Pre-Release ");
            pre = Integer.parseInt((String)((Object)IndyInterface.bootstrap("cast", "()", 0, BytecodeInterface8.objectArrayGet((Object[])pts, (int)1))));
            nearest = IndyInterface.bootstrap("cast", "()", 0, BytecodeInterface8.objectArrayGet((Object[])pts, (int)0));
        } else if (version.contains("-rc")) {
            Object[] pts = version.split("-rc");
            pre = -1 * Integer.parseInt((String)((Object)IndyInterface.bootstrap("cast", "()", 0, BytecodeInterface8.objectArrayGet((Object[])pts, (int)1))));
            nearest = IndyInterface.bootstrap("cast", "()", 0, BytecodeInterface8.objectArrayGet((Object[])pts, (int)0));
        }
        return new CacheableMinecraftVersion(Type.RELEASE, version, -1, -1, pre, null, CacheableMinecraftVersion.splitDots((String)nearest));
    }

    public String toString() {
        return this.full;
    }

    public int hashCode() {
        return this.full.hashCode();
    }

    public boolean equals(Object o) {
        if (!(o instanceof CacheableMinecraftVersion)) {
            return false;
        }
        return ScriptBytecodeAdapter.compareEqual((Object)this.full, (Object)((CacheableMinecraftVersion)((Object)IndyInterface.bootstrap("cast", "()", 0, o))).getFull());
    }

    @Override
    public int compareTo(@Nullable CacheableMinecraftVersion o) {
        Type type;
        if (o == null) {
            return 1;
        }
        if (ScriptBytecodeAdapter.compareNotEqual((Object)((Object)this.type), (Object)((Object)o.getType()))) {
            int ret = 0;
            Type type2 = this.type;
            if (ScriptBytecodeAdapter.isCase((Object)((Object)type2), (Object)((Object)Type.ALPHA))) {
                return -1;
            }
            if (ScriptBytecodeAdapter.isCase((Object)((Object)type2), (Object)((Object)Type.BETA))) {
                return ScriptBytecodeAdapter.compareEqual((Object)((Object)o.getType()), (Object)((Object)Type.ALPHA)) ? 1 : -1;
            }
            if (ScriptBytecodeAdapter.isCase((Object)((Object)type2), (Object)((Object)Type.SNAPSHOT))) {
                ret = this.compareFull(o);
                return ret == 0 ? -1 : ret;
            }
            if (ScriptBytecodeAdapter.isCase((Object)((Object)type2), (Object)((Object)Type.RELEASE))) {
                Type type3 = o.getType();
                if (ScriptBytecodeAdapter.isCase((Object)((Object)type3), (Object)((Object)Type.ALPHA)) || ScriptBytecodeAdapter.isCase((Object)((Object)type3), (Object)((Object)Type.BETA))) {
                    return 1;
                }
                if (ScriptBytecodeAdapter.isCase((Object)((Object)type3), (Object)((Object)Type.SNAPSHOT))) {
                    ret = this.compareFull(o);
                    return ret == 0 ? 1 : ret;
                }
            }
        }
        if (ScriptBytecodeAdapter.isCase((Object)((Object)(type = this.type)), (Object)((Object)Type.ALPHA)) || ScriptBytecodeAdapter.isCase((Object)((Object)type), (Object)((Object)Type.BETA))) {
            int ret = this.compareFull(o);
            if (ret != 0) {
                return ret;
            }
            if (this.revision == null && o.getRevision() == null) {
                return 0;
            }
            if (this.revision == null) {
                return 1;
            }
            if (o.getRevision() == null) {
                return -1;
            }
            return this.revision == o.getRevision() ? 0 : (this.revision == null ? -1 : (o.getRevision() == null ? 1 : this.revision.compareTo(o.getRevision())));
        }
        if (ScriptBytecodeAdapter.isCase((Object)((Object)type), (Object)((Object)Type.SNAPSHOT))) {
            if (this.year != o.getYear()) {
                return this.year - o.getYear();
            }
            if (this.week != o.getWeek()) {
                return this.week - o.getWeek();
            }
            if (this.revision == null && o.getRevision() == null) {
                return 0;
            }
            if (this.revision == null) {
                return 1;
            }
            if (o.getRevision() == null) {
                return -1;
            }
            return this.revision == o.getRevision() ? 0 : (this.revision == null ? -1 : (o.getRevision() == null ? 1 : this.revision.compareTo(o.getRevision())));
        }
        if (ScriptBytecodeAdapter.isCase((Object)((Object)type), (Object)((Object)Type.RELEASE))) {
            return this.compareFull(o);
        }
        throw (Throwable)new IllegalArgumentException(StringGroovyMethods.plus((CharSequence)"Invalid type: ", (Object)((Object)this.type)));
    }

    private int compareFull(CacheableMinecraftVersion o) {
        int x = 0;
        while (x < this.nearest.length) {
            if (x >= o.getNearest().length) {
                return 1;
            }
            if (IndyInterface.staticArrayAccess("get", (int[])this.nearest, (int)x) != IndyInterface.staticArrayAccess("get", (int[])o.getNearest(), (int)x)) {
                return (int)(IndyInterface.staticArrayAccess("get", (int[])this.nearest, (int)x) - IndyInterface.staticArrayAccess("get", (int[])o.getNearest(), (int)x));
            }
            int n = x;
            int cfr_ignored_0 = n + 1;
        }
        if (this.nearest.length < o.getNearest().length) {
            return -1;
        }
        if (ScriptBytecodeAdapter.compareEqual((Object)((Object)this.type), (Object)((Object)Type.RELEASE)) && ScriptBytecodeAdapter.compareNotEqual((Object)((Object)o.getType()), (Object)((Object)Type.RELEASE))) {
            return 1;
        }
        if (ScriptBytecodeAdapter.compareNotEqual((Object)((Object)this.type), (Object)((Object)Type.RELEASE)) && ScriptBytecodeAdapter.compareEqual((Object)((Object)o.getType()), (Object)((Object)Type.RELEASE))) {
            return -1;
        }
        if (this.pre == 0 && o.getPre() != 0) {
            return 1;
        }
        if (this.pre != 0 && o.getPre() == 0) {
            return -1;
        }
        if (this.pre < 0 && o.getPre() > 0) {
            return 1;
        }
        if (this.pre > 0 && o.getPre() < 0) {
            return -1;
        }
        return this.pre > 0 ? this.pre - o.getPre() : -this.pre - -o.getPre();
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != CacheableMinecraftVersion.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public /* synthetic */ Object this$dist$invoke$1(String name, Object args) {
        if (!(args instanceof Object[])) {
            return ScriptBytecodeAdapter.invokeMethodOnCurrentN(CacheableMinecraftVersion.class, (GroovyObject)this, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))), (Object[])new Object[]{args});
        }
        if (((CallSite)IndyInterface.bootstrap("cast", "()", 0, args)).length == 1) {
            return ScriptBytecodeAdapter.invokeMethodOnCurrentN(CacheableMinecraftVersion.class, (GroovyObject)this, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))), (Object[])new Object[]{BytecodeInterface8.objectArrayGet((Object[])IndyInterface.bootstrap("cast", "()", 0, args), (int)0)});
        }
        return ScriptBytecodeAdapter.invokeMethodOnCurrentN(CacheableMinecraftVersion.class, (GroovyObject)this, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
    }

    public /* synthetic */ void this$dist$set$1(String name, Object value) {
        Object object = value;
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object, CacheableMinecraftVersion.class, (GroovyObject)this, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))));
    }

    public /* synthetic */ Object this$dist$get$1(String name) {
        return ScriptBytecodeAdapter.getGroovyObjectProperty(CacheableMinecraftVersion.class, (GroovyObject)this, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))));
    }

    @Generated
    @Internal
    @Transient
    public MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    private static final class Type
    extends Enum<Type>
    implements GroovyObject {
        public static final /* enum */ Type RELEASE;
        public static final /* enum */ Type SNAPSHOT;
        public static final /* enum */ Type BETA;
        public static final /* enum */ Type ALPHA;
        public static final Type MIN_VALUE;
        public static final Type MAX_VALUE;
        private static final /* synthetic */ Type[] $VALUES;
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;
        private static /* synthetic */ ClassInfo $staticClassInfo$;

        @Generated
        private Type(LinkedHashMap __namedArgs) {
            MetaClass metaClass;
            this.metaClass = metaClass = this.$getStaticMetaClass();
            if (__namedArgs == null) {
                throw (Throwable)new IllegalArgumentException("One of the enum constants for enum net.neoforged.gradle.dsl.common.util.CacheableMinecraftVersion$Type was initialized with null. Please use a non-null value or define your own constructor.");
            }
            ImmutableASTTransformation.checkPropNames((Object)((Object)this), (Map)__namedArgs);
        }

        @Generated
        private Type() {
            this(new LinkedHashMap());
        }

        @Generated
        public static final Type[] values() {
            return IndyInterface.bootstrap("cast", "()", 0, $VALUES.clone());
        }

        @Generated
        public Type next() {
            Number ordinal = DefaultGroovyMethods.next((Number)this.ordinal());
            if (ScriptBytecodeAdapter.compareGreaterThanEqual((Object)ordinal, (Object)DefaultGroovyMethods.size((Object[])IndyInterface.bootstrap("cast", "()", 0, $VALUES)))) {
                ordinal = 0;
            }
            return IndyInterface.bootstrap("cast", "()", 0, BytecodeInterface8.objectArrayGet((Object[])$VALUES, (int)DefaultTypeTransformation.intUnbox((Object)ordinal)));
        }

        @Generated
        public Type previous() {
            Number ordinal = DefaultGroovyMethods.previous((Number)this.ordinal());
            if (ScriptBytecodeAdapter.compareLessThan((Object)ordinal, (Object)0)) {
                ordinal = NumberNumberMinus.minus((Number)DefaultGroovyMethods.size((Object[])IndyInterface.bootstrap("cast", "()", 0, $VALUES)), (Number)1);
            }
            return IndyInterface.bootstrap("cast", "()", 0, BytecodeInterface8.objectArrayGet((Object[])$VALUES, (int)DefaultTypeTransformation.intUnbox((Object)ordinal)));
        }

        @Generated
        public static Type valueOf(String name) {
            return IndyInterface.bootstrap("cast", "()", 0, Enum.valueOf(Type.class, name));
        }

        @Generated
        public static final /* synthetic */ Type $INIT(Object ... para) {
            Type type;
            Object[] objectArray = ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{para}, (int[])new int[]{0});
            switch (ScriptBytecodeAdapter.selectConstructorAndTransformArguments((Object[])objectArray, (int)-1, Type.class)) {
                case -1348271900: {
                    Type type2;
                    type = type2;
                    Object[] objectArray2 = objectArray;
                    type2 = new Type();
                    break;
                }
                case -242181752: {
                    Type type2;
                    type = type2;
                    Object[] objectArray2 = objectArray;
                    type2 = new Type((LinkedHashMap)((Object)IndyInterface.bootstrap("cast", "()", 0, objectArray[2])));
                    break;
                }
                default: {
                    throw new IllegalArgumentException("This class has been compiled with a super class which is binary incompatible with the current super class found on classpath. You should recompile this class with the new version.");
                }
            }
            return type;
        }

        static {
            Type type;
            Type type2;
            Type type3;
            Type type4;
            Type type5;
            Type type6;
            RELEASE = type6 = Type.$INIT("RELEASE", 0);
            SNAPSHOT = type5 = Type.$INIT("SNAPSHOT", 1);
            BETA = type4 = Type.$INIT("BETA", 2);
            ALPHA = type3 = Type.$INIT("ALPHA", 3);
            MIN_VALUE = type2 = RELEASE;
            MAX_VALUE = type = ALPHA;
            Type[] typeArray = new Type[]{RELEASE, SNAPSHOT, BETA, ALPHA};
            $VALUES = typeArray;
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (((Object)((Object)this)).getClass() != Type.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
            }
            return classInfo.getMetaClass();
        }

        @Generated
        @Internal
        @Transient
        public MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        @Generated
        @Internal
        public void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }
    }
}

