/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.gradle.dsl.common.util;

import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.beans.Transient;
import java.lang.invoke.CallSite;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.neoforged.gradle.dsl.common.runtime.definition.Definition;
import net.neoforged.gradle.dsl.common.runtime.spec.Specification;
import net.neoforged.gradle.dsl.common.runtime.tasks.Runtime;
import net.neoforged.gradle.dsl.common.runtime.tasks.RuntimeArguments;
import net.neoforged.gradle.dsl.common.tasks.WithOutput;
import net.neoforged.gradle.dsl.common.util.ModuleReference;
import net.neoforged.gradle.dsl.common.util.NamingConstants;
import net.neoforged.gradle.util.ModuleDependencyUtils;
import org.apache.commons.lang3.StringUtils;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.GeneratedLambda;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.StringGroovyMethods;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.vmplugin.v8.IndyInterface;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.ResolvedArtifact;
import org.gradle.api.artifacts.ResolvedDependency;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.TaskProvider;

public final class CommonRuntimeUtils
implements GroovyObject {
    private static final Pattern OUTPUT_REPLACE_PATTERN;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ ClassInfo $staticClassInfo$;

    private CommonRuntimeUtils() {
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
        throw (Throwable)new IllegalStateException("Can not instantiate an instance of: McpRuntimeUtils. This is a utility class");
    }

    public static String buildTaskName(TaskProvider<? extends Task> modifiedTask, String defaultName) {
        return String.format("%s%s", defaultName, StringUtils.capitalize((String)modifiedTask.getName()));
    }

    public static String buildTaskName(Specification runtimeSpec, String defaultName) {
        if (runtimeSpec.getVersionedName().isEmpty()) {
            return defaultName;
        }
        return StringGroovyMethods.plus((String)runtimeSpec.getVersionedName(), (CharSequence)StringUtils.capitalize((String)defaultName));
    }

    public static <D extends Definition<? extends Specification>> String buildTaskName(D runtimeSpec, String defaultName) {
        return CommonRuntimeUtils.buildTaskName(runtimeSpec.getSpecification(), defaultName);
    }

    public static String buildTaskName(String name, ResolvedDependency resolvedDependency) {
        String dependencyClassifier = ((ResolvedArtifact)resolvedDependency.getModuleArtifacts().iterator().next()).getClassifier();
        String dependencyName = StringUtils.capitalize((String)StringGroovyMethods.plus((String)resolvedDependency.getName(), (CharSequence)(dependencyClassifier == null ? "" : StringGroovyMethods.plus((String)":", (CharSequence)dependencyClassifier))));
        String validDependencyName = dependencyName.replaceAll("[/\\\\:<>\"?*|]", "_");
        String validName = name.replaceAll("[/\\\\:<>\"?*|]", "_");
        return String.format("%s%s", validName, validDependencyName);
    }

    public static String buildTaskName(String name, String defaultName) {
        String suffix = StringUtils.capitalize((String)name);
        String validSuffix = suffix.replaceAll("[/\\\\:<>\"?*|]", "_");
        String validName = defaultName.replaceAll("[/\\\\:<>\"?*|]", "_");
        return String.format("%s%s", validName, validSuffix);
    }

    public static String buildTaskName(String prefix, ModuleReference reference) {
        String dependencyName = StringUtils.capitalize((String)reference.toString());
        String validDependencyName = dependencyName.replaceAll("[/\\\\:<>\"?*|]", "_");
        String validPrefix = prefix.replaceAll("[/\\\\:<>\"?*|]", "_");
        return String.format("%s%s", validPrefix, validDependencyName);
    }

    public static String buildTaskName(String prefix, Dependency reference) {
        String dependencyId = ModuleDependencyUtils.format((Dependency)reference);
        String dependencyName = StringUtils.capitalize((String)dependencyId);
        String validDependencyName = dependencyName.replaceAll("[/\\\\:<>\"?*|]", "_");
        String validPrefix = prefix.replaceAll("[/\\\\:<>\"?*|]", "_");
        return String.format("%s%s", validPrefix, validDependencyName);
    }

    public static String buildStepName(Specification spec, String name) {
        return StringUtils.uncapitalize((String)name.replace(spec.getVersionedName(), ""));
    }

    public static Optional<TaskProvider<? extends WithOutput>> getInputTaskForTaskFrom(Specification spec, String inputValue, Map<String, TaskProvider<? extends WithOutput>> tasks) {
        Matcher matcher = OUTPUT_REPLACE_PATTERN.matcher(inputValue);
        if (!matcher.find()) {
            return Optional.empty();
        }
        String stepName = matcher.group(1);
        if (stepName != null) {
            String taskName = CommonRuntimeUtils.buildTaskName(spec, stepName);
            String string = stepName;
            if (ScriptBytecodeAdapter.isCase((Object)string, (Object)"downloadManifest")) {
                taskName = String.format("%s%s", NamingConstants.Task.CACHE_LAUNCHER_METADATA, spec.getMinecraftVersion());
            } else if (ScriptBytecodeAdapter.isCase((Object)string, (Object)"downloadJson")) {
                taskName = String.format("%s%s", NamingConstants.Task.CACHE_VERSION_MANIFEST, spec.getMinecraftVersion());
            } else if (ScriptBytecodeAdapter.isCase((Object)string, (Object)"downloadClient")) {
                taskName = String.format("%s%s", NamingConstants.Task.CACHE_VERSION_ARTIFACT_CLIENT, spec.getMinecraftVersion());
            } else if (ScriptBytecodeAdapter.isCase((Object)string, (Object)"downloadServer")) {
                taskName = String.format("%s%s", NamingConstants.Task.CACHE_VERSION_ARTIFACT_SERVER, spec.getMinecraftVersion());
            } else if (ScriptBytecodeAdapter.isCase((Object)string, (Object)"downloadClientMappings")) {
                taskName = String.format("%s%s", NamingConstants.Task.CACHE_VERSION_MAPPINGS_CLIENT, spec.getMinecraftVersion());
            } else if (ScriptBytecodeAdapter.isCase((Object)string, (Object)"downloadServerMappings")) {
                taskName = String.format("%s%s", NamingConstants.Task.CACHE_VERSION_MAPPINGS_SERVER, spec.getMinecraftVersion());
            }
            String finalTaskName = taskName;
            return Optional.ofNullable(tasks.get(finalTaskName));
        }
        return Optional.empty();
    }

    /*
     * WARNING - void declaration
     */
    public static <T extends Definition<? extends Specification>> void buildArguments(RuntimeArguments arguments, T definition, Map<String, String> values, Map<String, TaskProvider<? extends WithOutput>> tasks, Runtime taskForArguments, Optional<TaskProvider<? extends WithOutput>> alternativeInputProvider) {
        void var3_3;
        Reference definition2 = new Reference(definition);
        Reference tasks2 = new Reference((Object)var3_3);
        public final class _buildArguments_lambda1
        extends Closure
        implements GeneratedLambda {
            private /* synthetic */ Reference definition;
            private /* synthetic */ Reference tasks;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _buildArguments_lambda1(Object _outerInstance, Object _thisObject, Reference definition, Reference tasks) {
                super(_outerInstance, _thisObject);
                Reference reference;
                Reference reference2;
                this.definition = reference2 = definition;
                this.tasks = reference = tasks;
            }

            public R doCall(String value) {
                return CommonRuntimeUtils.getInputTaskForTaskFrom(((Definition)this.definition.get()).getSpecification(), value, (Map<String, TaskProvider<? extends WithOutput>>)((Object)IndyInterface.bootstrap("cast", "()", 0, this.tasks.get())));
            }

            @Generated
            public Definition getDefinition() {
                return IndyInterface.bootstrap("cast", "()", 0, this.definition.get());
            }

            @Generated
            public Map getTasks() {
                return IndyInterface.bootstrap("cast", "()", 0, this.tasks.get());
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _buildArguments_lambda1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        public final class _buildArguments_lambda2
        extends Closure
        implements GeneratedLambda {
            private /* synthetic */ Reference definition;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _buildArguments_lambda2(Object _outerInstance, Object _thisObject, Reference definition) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.definition = reference = definition;
            }

            public R doCall(String value) {
                Reference value2 = new Reference((Object)value);
                public final class _lambda4
                extends Closure
                implements GeneratedLambda {
                    private /* synthetic */ Reference value;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;

                    public _lambda4(Object _outerInstance, Object _thisObject, Reference value) {
                        super(_outerInstance, _thisObject);
                        Reference reference;
                        this.value = reference = value;
                    }

                    public V doCall() {
                        return this.value.get();
                    }

                    @Generated
                    public String getValue() {
                        return IndyInterface.bootstrap("cast", "()", 0, this.value.get());
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _lambda4.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }
                }
                return ((Definition)this.definition.get()).getSpecification().getProject().provider(new _lambda4(CommonRuntimeUtils.class, CommonRuntimeUtils.class, value2)::doCall);
            }

            @Generated
            public Definition getDefinition() {
                return IndyInterface.bootstrap("cast", "()", 0, this.definition.get());
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _buildArguments_lambda2.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        CommonRuntimeUtils.buildArguments(arguments, new _buildArguments_lambda1(CommonRuntimeUtils.class, CommonRuntimeUtils.class, definition2, tasks2)::doCall, new _buildArguments_lambda2(CommonRuntimeUtils.class, CommonRuntimeUtils.class, definition2)::doCall, values, taskForArguments, alternativeInputProvider);
    }

    public static void buildArguments(RuntimeArguments arguments, Function<String, Optional<TaskProvider<? extends WithOutput>>> inputBuilder, Function<String, Provider<String>> providerBuilder, Map<String, String> values, Runtime taskForArguments, Optional<TaskProvider<? extends WithOutput>> alternativeInputProvider) {
        Reference arguments2 = new Reference((Object)arguments);
        Reference key = new Reference(null);
        CallSite callSite = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "iterator", 0, IndyInterface.bootstrap("invoke", "keySet", 0, values)));
        if (callSite != null) {
            while (callSite.hasNext()) {
                key.set((Object)IndyInterface.bootstrap("cast", "()", 0, callSite.next()));
                CallSite value = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "get", 0, values, (String)key.get()));
                if (DefaultTypeTransformation.booleanUnbox((Object)IndyInterface.bootstrap("invoke", "startsWith", 0, value, "{")) && DefaultTypeTransformation.booleanUnbox((Object)IndyInterface.bootstrap("invoke", "endsWith", 0, value, "}"))) {
                    Object dependentTask = null;
                    dependentTask = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "equals", 0, Objects.class, (String)key.get(), "input")) == false || IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "isPresent", 0, alternativeInputProvider)) == false ? IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "apply", 0, inputBuilder, value)) : alternativeInputProvider;
                    IndyInterface.bootstrap("invoke", "ifPresent", 0, dependentTask, ScriptBytecodeAdapter.getMethodPointer((Object)taskForArguments, (String)"dependsOn"));
                    public final class _buildArguments_closure3
                    extends Closure
                    implements GeneratedClosure {
                        private /* synthetic */ Reference arguments;
                        private /* synthetic */ Reference key;
                        private static /* synthetic */ ClassInfo $staticClassInfo;
                        public static transient /* synthetic */ boolean __$stMC;

                        public _buildArguments_closure3(Object _outerInstance, Object _thisObject, Reference arguments, Reference key) {
                            super(_outerInstance, _thisObject);
                            Reference reference;
                            Reference reference2;
                            this.arguments = reference2 = arguments;
                            this.key = reference = key;
                        }

                        public Object doCall(Object task) {
                            public final class _closure5
                            extends Closure
                            implements GeneratedClosure {
                                private static /* synthetic */ ClassInfo $staticClassInfo;
                                public static transient /* synthetic */ boolean __$stMC;

                                public _closure5(Object _outerInstance, Object _thisObject) {
                                    super(_outerInstance, _thisObject);
                                }

                                public Object doCall(Object t) {
                                    return IndyInterface.bootstrap("invoke", "getOutput", 0, t);
                                }

                                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                                    if (((Object)((Object)this)).getClass() != _closure5.class) {
                                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                                    }
                                    ClassInfo classInfo = $staticClassInfo;
                                    if (classInfo == null) {
                                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                                    }
                                    return classInfo.getMetaClass();
                                }
                            }
                            return IndyInterface.bootstrap("invoke", "putRegularFile", 0, this.arguments.get(), this.key.get(), IndyInterface.bootstrap("invoke", "flatMap", 0, task, new _closure5((Object)this, this.getThisObject())));
                        }

                        @Generated
                        public RuntimeArguments getArguments() {
                            return IndyInterface.bootstrap("cast", "()", 0, this.arguments.get());
                        }

                        @Generated
                        public String getKey() {
                            return IndyInterface.bootstrap("cast", "()", 0, this.key.get());
                        }

                        protected /* synthetic */ MetaClass $getStaticMetaClass() {
                            if (((Object)((Object)this)).getClass() != _buildArguments_closure3.class) {
                                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                            }
                            ClassInfo classInfo = $staticClassInfo;
                            if (classInfo == null) {
                                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                            }
                            return classInfo.getMetaClass();
                        }
                    }
                    IndyInterface.bootstrap("invoke", "ifPresent", 0, dependentTask, new _buildArguments_closure3(CommonRuntimeUtils.class, CommonRuntimeUtils.class, arguments2, key));
                    continue;
                }
                IndyInterface.bootstrap("invoke", "put", 0, (RuntimeArguments)arguments2.get(), (String)key.get(), IndyInterface.bootstrap("invoke", "apply", 0, providerBuilder, value));
            }
        }
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != CommonRuntimeUtils.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    @Internal
    @Transient
    public MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    static {
        Pattern pattern;
        OUTPUT_REPLACE_PATTERN = pattern = Pattern.compile("^\\{(\\w+)Output}$");
    }
}

