/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.gradle.dsl.common.util;

import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.beans.Transient;
import java.io.File;
import java.io.Serializable;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.neoforged.gradle.dsl.common.extensions.dependency.replacement.DependencyReplacement;
import net.neoforged.gradle.dsl.common.extensions.subsystems.Subsystems;
import net.neoforged.gradle.dsl.common.runs.run.Run;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.GeneratedLambda;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.StringGroovyMethods;
import org.codehaus.groovy.vmplugin.v8.IndyInterface;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.file.FileSystemLocation;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetContainer;

public class ConfigurationUtils
implements GroovyObject {
    private static Set<Configuration> UNHANDLED_CONFIGURATIONS;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ ClassInfo $staticClassInfo$;

    private ConfigurationUtils() {
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
        throw (Throwable)new IllegalStateException("Can not instantiate an instance of: ConfigurationUtils. This is a utility class");
    }

    public static Configuration temporaryConfiguration(Project project, String context, Dependency ... dependencies) {
        CallSite configuration = IndyInterface.bootstrap("cast", "()", 0, project.getConfigurations().maybeCreate((String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{StringGroovyMethods.capitalize((CharSequence)context)}, new String[]{"neoGradleInternal", ""})))));
        if (configuration.getDependencies().isEmpty()) {
            DefaultGroovyMethods.addAll((Collection)configuration.getDependencies(), (Object[])IndyInterface.bootstrap("cast", "()", 0, dependencies));
            configuration.setCanBeConsumed(false);
            configuration.setCanBeResolved(true);
            CallSite dependencyReplacement = IndyInterface.bootstrap("cast", "()", 0, project.getExtensions().getByType(DependencyReplacement.class));
            dependencyReplacement.handleConfiguration((Configuration)configuration);
        }
        return configuration;
    }

    public static Configuration temporaryConfiguration(Project project, String context, Action<Configuration> processor) {
        CallSite name = IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{StringGroovyMethods.capitalize((CharSequence)context)}, new String[]{"neoGradleInternal", ""}));
        boolean exists = project.getConfigurations().getNames().contains(name);
        CallSite configuration = IndyInterface.bootstrap("cast", "()", 0, project.getConfigurations().maybeCreate((String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{StringGroovyMethods.capitalize((CharSequence)context)}, new String[]{"neoGradleInternal", ""})))));
        if (!exists) {
            processor.execute((Object)configuration);
            configuration.setCanBeConsumed(false);
            configuration.setCanBeResolved(true);
            CallSite dependencyReplacement = IndyInterface.bootstrap("cast", "()", 0, project.getExtensions().getByType(DependencyReplacement.class));
            dependencyReplacement.handleConfiguration((Configuration)configuration);
        }
        return configuration;
    }

    public static boolean isUnhandledConfiguration(Configuration configuration) {
        return UNHANDLED_CONFIGURATIONS.contains(configuration);
    }

    public static Configuration temporaryUnhandledConfiguration(ConfigurationContainer configurations, String context, Dependency ... dependencies) {
        CallSite configuration = IndyInterface.bootstrap("cast", "()", 0, configurations.maybeCreate((String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{StringGroovyMethods.capitalize((CharSequence)context)}, new String[]{"neoGradleInternalUnhandled", ""})))));
        UNHANDLED_CONFIGURATIONS.add((Configuration)configuration);
        if (configuration.getDependencies().isEmpty()) {
            DefaultGroovyMethods.addAll((Collection)configuration.getDependencies(), (Object[])IndyInterface.bootstrap("cast", "()", 0, dependencies));
            configuration.setCanBeConsumed(false);
            configuration.setCanBeResolved(true);
        }
        return configuration;
    }

    public static Configuration temporaryUnhandledNotTransitiveConfiguration(ConfigurationContainer configurations, String context, Dependency ... dependencies) {
        CallSite configuration = IndyInterface.bootstrap("cast", "()", 0, configurations.maybeCreate((String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{StringGroovyMethods.capitalize((CharSequence)context)}, new String[]{"neoGradleInternalUnhandled", ""})))));
        UNHANDLED_CONFIGURATIONS.add((Configuration)configuration);
        if (configuration.getDependencies().isEmpty()) {
            DefaultGroovyMethods.addAll((Collection)configuration.getDependencies(), (Object[])IndyInterface.bootstrap("cast", "()", 0, dependencies));
            configuration.setCanBeConsumed(false);
            configuration.setCanBeResolved(true);
            configuration.setTransitive(false);
        }
        return configuration;
    }

    /*
     * WARNING - void declaration
     */
    public static Provider<File> getArtifactProvider(Project project, String context, Provider<? extends Object> dependencyNotationProvider) {
        void var1_1;
        Reference project2 = new Reference((Object)project);
        Reference context2 = new Reference((Object)var1_1);
        public final class _getArtifactProvider_lambda1
        extends Closure
        implements GeneratedLambda {
            private /* synthetic */ Reference project;
            private /* synthetic */ Reference context;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _getArtifactProvider_lambda1(Object _outerInstance, Object _thisObject, Reference project, Reference context) {
                super(_outerInstance, _thisObject);
                Reference reference;
                Reference reference2;
                this.project = reference2 = project;
                this.context = reference = context;
            }

            public OUT doCall(Object dependencyNotation) {
                Configuration configuration = ConfigurationUtils.temporaryUnhandledNotTransitiveConfiguration(((Project)this.project.get()).getConfigurations(), (String)((Object)IndyInterface.bootstrap("cast", "()", 0, this.context.get())), ((Project)this.project.get()).getDependencies().create(dependencyNotation));
                public final class _lambda5
                extends Closure
                implements GeneratedLambda {
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;

                    public _lambda5(Object _outerInstance, Object _thisObject) {
                        super(_outerInstance, _thisObject);
                    }

                    public OUT doCall(Set<FileSystemLocation> files) {
                        return files.iterator().next().getAsFile();
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _lambda5.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }
                }
                return configuration.getElements().map(new _lambda5(ConfigurationUtils.class, ConfigurationUtils.class)::doCall);
            }

            @Generated
            public Project getProject() {
                return IndyInterface.bootstrap("cast", "()", 0, this.project.get());
            }

            @Generated
            public String getContext() {
                return IndyInterface.bootstrap("cast", "()", 0, this.context.get());
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _getArtifactProvider_lambda1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        return dependencyNotationProvider.flatMap(new _getArtifactProvider_lambda1(ConfigurationUtils.class, ConfigurationUtils.class, project2, context2)::doCall);
    }

    public static List<Configuration> findReplacementConfigurations(Project project, Configuration configuration) {
        HashSet<Configuration> resultContainer = new HashSet<Configuration>();
        resultContainer.addAll(ConfigurationUtils.findCompileOnlyConfigurationForSourceSetReplacement(project, configuration));
        resultContainer.addAll(ConfigurationUtils.findRuntimeOnlyConfigurationFromSourceSetReplacement(project, configuration));
        if (resultContainer.isEmpty()) {
            resultContainer.add(configuration);
        }
        return DefaultGroovyMethods.toList(resultContainer);
    }

    /*
     * WARNING - void declaration
     */
    public static List<Configuration> findCompileOnlyConfigurationForSourceSetReplacement(Project project, Configuration configuration) {
        void var1_1;
        Reference project2 = new Reference((Object)project);
        Reference configuration2 = new Reference((Object)var1_1);
        CallSite sourceSetContainer = IndyInterface.bootstrap("cast", "()", 0, ((Project)project2.get()).getExtensions().getByType(SourceSetContainer.class));
        Reference targets = new Reference(new ArrayList());
        public final class _findCompileOnlyConfigurationForSourceSetReplacement_closure2
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference project;
            private /* synthetic */ Reference configuration;
            private /* synthetic */ Reference targets;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _findCompileOnlyConfigurationForSourceSetReplacement_closure2(Object _outerInstance, Object _thisObject, Reference project, Reference configuration, Reference targets) {
                super(_outerInstance, _thisObject);
                Reference reference;
                Reference reference2;
                Reference reference3;
                this.project = reference3 = project;
                this.configuration = reference2 = configuration;
                this.targets = reference = targets;
            }

            public Serializable doCall(Object sourceSet) {
                CallSite compileOnly = IndyInterface.bootstrap("cast", "()", 0, ((Project)this.project.get()).getConfigurations().findByName(((SourceSet)sourceSet).getCompileOnlyConfigurationName()));
                CallSite compileClasspath = IndyInterface.bootstrap("cast", "()", 0, ((Project)this.project.get()).getConfigurations().findByName(((SourceSet)sourceSet).getCompileClasspathConfigurationName()));
                if (compileOnly == null) {
                    return IndyInterface.bootstrap("cast", "()", 0, null);
                }
                if (ScriptBytecodeAdapter.compareEqual((Object)this.configuration.get(), (Object)compileOnly)) {
                    ((ArrayList)this.targets.get()).clear();
                    ((ArrayList)this.targets.get()).add(compileOnly);
                    return IndyInterface.bootstrap("cast", "()", 0, this.targets.get());
                }
                Set<Configuration> supers = ConfigurationUtils.getAllSuperConfigurations((Configuration)compileClasspath);
                if (supers.contains(compileOnly) && supers.contains(this.configuration.get())) {
                    return Boolean.valueOf(((ArrayList)this.targets.get()).add(compileOnly));
                }
                return IndyInterface.bootstrap("cast", "()", 0, null);
            }

            @Generated
            public Project getProject() {
                return IndyInterface.bootstrap("cast", "()", 0, this.project.get());
            }

            @Generated
            public Configuration getConfiguration() {
                return IndyInterface.bootstrap("cast", "()", 0, this.configuration.get());
            }

            @Generated
            public List getTargets() {
                return IndyInterface.bootstrap("cast", "()", 0, this.targets.get());
            }

            @Generated
            public Object call(Object args) {
                return this.doCall(args);
            }

            @Generated
            public Object call() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _findCompileOnlyConfigurationForSourceSetReplacement_closure2.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        sourceSetContainer.forEach(IndyInterface.bootstrap("cast", "()", 0, new _findCompileOnlyConfigurationForSourceSetReplacement_closure2(ConfigurationUtils.class, ConfigurationUtils.class, project2, configuration2, targets)));
        return (ArrayList)targets.get();
    }

    /*
     * WARNING - void declaration
     */
    public static List<Configuration> findRuntimeOnlyConfigurationFromSourceSetReplacement(Project project, Configuration configuration) {
        void var1_1;
        Reference project2 = new Reference((Object)project);
        Reference configuration2 = new Reference((Object)var1_1);
        CallSite sourceSetContainer = IndyInterface.bootstrap("cast", "()", 0, ((Project)project2.get()).getExtensions().getByType(SourceSetContainer.class));
        Reference targets = new Reference(new ArrayList());
        public final class _findRuntimeOnlyConfigurationFromSourceSetReplacement_closure3
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference project;
            private /* synthetic */ Reference configuration;
            private /* synthetic */ Reference targets;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _findRuntimeOnlyConfigurationFromSourceSetReplacement_closure3(Object _outerInstance, Object _thisObject, Reference project, Reference configuration, Reference targets) {
                super(_outerInstance, _thisObject);
                Reference reference;
                Reference reference2;
                Reference reference3;
                this.project = reference3 = project;
                this.configuration = reference2 = configuration;
                this.targets = reference = targets;
            }

            public Serializable doCall(Object sourceSet) {
                CallSite runtimeOnly = IndyInterface.bootstrap("cast", "()", 0, ((Project)this.project.get()).getConfigurations().findByName(((SourceSet)sourceSet).getRuntimeOnlyConfigurationName()));
                CallSite runtimeClasspath = IndyInterface.bootstrap("cast", "()", 0, ((Project)this.project.get()).getConfigurations().findByName(((SourceSet)sourceSet).getRuntimeClasspathConfigurationName()));
                if (runtimeOnly == null) {
                    return IndyInterface.bootstrap("cast", "()", 0, null);
                }
                if (ScriptBytecodeAdapter.compareEqual((Object)this.configuration.get(), (Object)runtimeOnly)) {
                    ((ArrayList)this.targets.get()).clear();
                    ((ArrayList)this.targets.get()).add(runtimeOnly);
                    return IndyInterface.bootstrap("cast", "()", 0, this.targets.get());
                }
                Set<Configuration> supers = ConfigurationUtils.getAllSuperConfigurations((Configuration)runtimeClasspath);
                if (supers.contains(runtimeOnly) && supers.contains(this.configuration.get())) {
                    CallSite reallyRuntimeOnly = IndyInterface.bootstrap("cast", "()", 0, ((Project)this.project.get()).getConfigurations().maybeCreate(ConfigurationUtils.getSourceSetName((SourceSet)IndyInterface.bootstrap("cast", "()", 0, sourceSet), (String)((Object)IndyInterface.bootstrap("cast", "()", 0, ((Subsystems)((Project)this.project.get()).getExtensions().getByType(Subsystems.class)).getConventions().getConfigurations().getLocalRuntimeConfigurationPostFix().get())))));
                    runtimeClasspath.extendsFrom(new Configuration[]{reallyRuntimeOnly});
                    return Boolean.valueOf(((ArrayList)this.targets.get()).add(reallyRuntimeOnly));
                }
                return IndyInterface.bootstrap("cast", "()", 0, null);
            }

            @Generated
            public Project getProject() {
                return IndyInterface.bootstrap("cast", "()", 0, this.project.get());
            }

            @Generated
            public Configuration getConfiguration() {
                return IndyInterface.bootstrap("cast", "()", 0, this.configuration.get());
            }

            @Generated
            public List getTargets() {
                return IndyInterface.bootstrap("cast", "()", 0, this.targets.get());
            }

            @Generated
            public Object call(Object args) {
                return this.doCall(args);
            }

            @Generated
            public Object call() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _findRuntimeOnlyConfigurationFromSourceSetReplacement_closure3.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        sourceSetContainer.forEach(IndyInterface.bootstrap("cast", "()", 0, new _findRuntimeOnlyConfigurationFromSourceSetReplacement_closure3(ConfigurationUtils.class, ConfigurationUtils.class, project2, configuration2, targets)));
        return (ArrayList)targets.get();
    }

    public static Set<Configuration> getAllSuperConfigurations(Configuration configuration) {
        HashSet<Configuration> supers = new HashSet<Configuration>();
        ConfigurationUtils.getAllSuperConfigurationsRecursive(configuration, supers);
        return supers;
    }

    private static void getAllSuperConfigurationsRecursive(Configuration configuration, Set<Configuration> supers) {
        Reference supers2 = new Reference(supers);
        public final class _getAllSuperConfigurationsRecursive_closure4
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference supers;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _getAllSuperConfigurationsRecursive_closure4(Object _outerInstance, Object _thisObject, Reference supers) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.supers = reference = supers;
            }

            public Void doCall(Object config) {
                if (((Set)this.supers.get()).add(config)) {
                    ConfigurationUtils.getAllSuperConfigurationsRecursive((Configuration)IndyInterface.bootstrap("cast", "()", 0, config), (Set<Configuration>)((Object)IndyInterface.bootstrap("cast", "()", 0, this.supers.get())));
                    return IndyInterface.bootstrap("cast", "()", 0, null);
                }
                return IndyInterface.bootstrap("cast", "()", 0, null);
            }

            @Generated
            public Set getSupers() {
                return IndyInterface.bootstrap("cast", "()", 0, this.supers.get());
            }

            @Generated
            public Object call(Object args) {
                return this.doCall(args);
            }

            @Generated
            public Object call() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _getAllSuperConfigurationsRecursive_closure4.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        configuration.getExtendsFrom().forEach(IndyInterface.bootstrap("cast", "()", 0, new _getAllSuperConfigurationsRecursive_closure4(ConfigurationUtils.class, ConfigurationUtils.class, supers2)));
    }

    public static String getSourceSetName(SourceSet sourceSet, String postFix) {
        String capitalized = StringGroovyMethods.capitalize((CharSequence)postFix);
        String name = ScriptBytecodeAdapter.compareEqual((Object)sourceSet.getName(), (Object)SourceSet.MAIN_SOURCE_SET_NAME) ? "" : StringGroovyMethods.capitalize((CharSequence)sourceSet.getName());
        return StringGroovyMethods.uncapitalize((CharSequence)StringGroovyMethods.plus((String)name, (CharSequence)capitalized));
    }

    public static String getRunName(Run sourceSet, String postFix) {
        String capitalized = StringGroovyMethods.capitalize((CharSequence)postFix);
        String name = StringGroovyMethods.capitalize((CharSequence)sourceSet.getName());
        return StringGroovyMethods.uncapitalize((CharSequence)StringGroovyMethods.plus((String)name, (CharSequence)capitalized));
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != ConfigurationUtils.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    @Internal
    @Transient
    public MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    static {
        HashSet<Configuration> hashSet = new HashSet<Configuration>();
        UNHANDLED_CONFIGURATIONS = hashSet;
    }
}

