/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.gradle.common.util;

import java.lang.reflect.Field;
import java.util.ArrayList;

public class ReflectionUtils {
    public static void setFinalField(Object target, String fieldName, Object value) throws ReflectiveOperationException {
        Field field = null;
        for (Class<?> clazz = target.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
            try {
                field = clazz.getDeclaredField(fieldName);
                break;
            }
            catch (NoSuchFieldException e) {
                continue;
            }
        }
        if (field == null) {
            throw new NoSuchFieldException("Field '" + fieldName + "' not found in class hierarchy.");
        }
        field.setAccessible(true);
        field.set(target, value);
    }

    public static void setFinalFieldUnchecked(Object target, String fieldName, Object value) {
        try {
            ReflectionUtils.setFinalField(target, fieldName, value);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException("Failed to set final field '" + fieldName + "'", e);
        }
    }

    public static void setFinalFieldUncheckedWithAlternatives(Object target, Object value, String ... fieldNames) {
        ArrayList<ReflectiveOperationException> exceptions = new ArrayList<ReflectiveOperationException>(fieldNames.length);
        for (String fieldName : fieldNames) {
            try {
                ReflectionUtils.setFinalField(target, fieldName, value);
                return;
            }
            catch (ReflectiveOperationException e) {
                exceptions.add(e);
            }
        }
        RuntimeException ex = new RuntimeException("Failed to set final field '" + String.join((CharSequence)", ", fieldNames) + "'");
        for (ReflectiveOperationException exception : exceptions) {
            ex.addSuppressed(exception);
        }
        throw ex;
    }
}

