/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.gradle.common.tasks;

import java.io.FileOutputStream;
import java.io.IOException;
import java.util.zip.ZipOutputStream;
import net.neoforged.gradle.common.runtime.tasks.DefaultRuntime;
import net.neoforged.gradle.common.services.caching.CachedExecutionService;
import net.neoforged.gradle.common.services.caching.jobs.ICacheableJob;
import net.neoforged.gradle.dsl.common.tasks.WithOperations;
import net.neoforged.gradle.dsl.common.tasks.WithOutput;
import net.neoforged.gradle.dsl.common.tasks.WithWorkspace;
import net.neoforged.gradle.dsl.common.tasks.specifications.InputFileSpecification;
import net.neoforged.gradle.util.ClassVisitingFileTreeVisitor;
import org.gradle.api.Task;
import org.gradle.api.file.FileTree;
import org.gradle.api.file.FileVisitor;
import org.gradle.api.provider.Property;
import org.gradle.api.services.ServiceReference;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.TaskAction;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodVisitor;

@CacheableTask
public abstract class StripFinalFromParametersTask
extends DefaultRuntime
implements WithOutput,
InputFileSpecification,
WithOperations,
WithWorkspace {
    @ServiceReference(value="CachedExecutionService")
    public abstract Property<CachedExecutionService> getCacheService();

    @TaskAction
    public void stripFinal() throws IOException {
        ((CachedExecutionService)this.getCacheService().get()).cached((Task)this, ICacheableJob.Default.file(this::doStripFinal, this.getOutput())).execute();
    }

    private void doStripFinal() throws IOException {
        FileTree input = this.getArchiveOperations().zipTree((Object)this.getInput());
        try (FileOutputStream fos = new FileOutputStream(this.ensureFileWorkspaceReady(this.getOutput()));
             ZipOutputStream zos = new ZipOutputStream(fos);){
            ClassVisitingFileTreeVisitor visitor = new ClassVisitingFileTreeVisitor(zos, StripFinalClassVisitor::new);
            input.visit((FileVisitor)visitor);
        }
    }

    private static class StripFinalParameterVisitor
    extends MethodVisitor {
        public StripFinalParameterVisitor(int api, MethodVisitor methodVisitor) {
            super(api, methodVisitor);
        }

        public void visitParameter(String name, int access) {
            int newAccess = access & 0xFFFFFFEF;
            super.visitParameter(name, newAccess);
        }
    }

    private static class StripFinalClassVisitor
    extends ClassVisitor {
        public StripFinalClassVisitor(int api, ClassVisitor classVisitor) {
            super(api, classVisitor);
        }

        public MethodVisitor visitMethod(int access, String name, String descriptor, String signature, String[] exceptions) {
            MethodVisitor mv = super.visitMethod(access, name, descriptor, signature, exceptions);
            return new StripFinalParameterVisitor(this.api, mv);
        }
    }
}

