/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.gradle.common.runtime.tasks;

import java.io.File;
import javax.inject.Inject;
import net.neoforged.gradle.common.runtime.tasks.DefaultRuntime;
import net.neoforged.gradle.common.runtime.tasks.action.DownloadFileAction;
import net.neoforged.gradle.common.runtime.tasks.action.ExtractFileAction;
import net.neoforged.gradle.common.util.VersionJson;
import net.neoforged.gradle.util.TransformerUtils;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileTree;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;
import org.gradle.workers.WorkQueue;
import org.gradle.workers.WorkerExecutor;

@CacheableTask
public abstract class ExtractNatives
extends DefaultRuntime {
    public ExtractNatives() {
        this.getVersionJson().convention(this.getVersionJsonFile().map(TransformerUtils.guard(file -> VersionJson.get(file.getAsFile()))));
        this.getLibrariesDirectory().convention(this.getOutputDirectory().map(dir -> dir.dir("libraries")));
    }

    @TaskAction
    public void extract() {
        this.downloadNatives();
        this.extractNatives();
    }

    private void downloadNatives() {
        VersionJson versionJson = (VersionJson)this.getVersionJson().get();
        WorkQueue executor = this.getWorkerExecutor().noIsolation();
        File librariesDirectory = this.ensureFileWorkspaceReady(((Directory)this.getLibrariesDirectory().get()).getAsFile());
        versionJson.getNatives().forEach(library -> {
            File outputFile = new File(librariesDirectory, library.getPath());
            executor.submit(DownloadFileAction.class, params -> {
                params.getIsOffline().set((Object)this.getProject().getGradle().getStartParameter().isOffline());
                params.getShouldValidateHash().set((Object)true);
                params.getOutputFile().set(outputFile);
                params.getUrl().set((Object)library.getUrl().toString());
                params.getSha1().set((Object)library.getSha1());
            });
        });
        executor.await();
    }

    private void extractNatives() {
        VersionJson versionJson = (VersionJson)this.getVersionJson().get();
        WorkQueue executor = this.getWorkerExecutor().noIsolation();
        File librariesDirectory = ((Directory)this.getLibrariesDirectory().get()).getAsFile();
        versionJson.getNatives().forEach(library -> {
            File outputFile = new File(librariesDirectory, library.getPath());
            executor.submit(ExtractFileAction.class, params -> {
                params.getInputFile().set(outputFile);
                params.getOutputDirectory().set((Provider)this.getOutputDirectory());
                params.getShouldOverride().set((Object)true);
                params.getShouldCleanTarget().set((Object)false);
                params.getFilter().set(patternFilterable -> patternFilterable.exclude(fileTreeElement -> fileTreeElement.getPath().startsWith("META-INF")));
                params.getRenamer().set(path -> {
                    int lastPathSeparatorIndex = path.lastIndexOf(47);
                    return lastPathSeparatorIndex == -1 ? path : path.substring(lastPathSeparatorIndex);
                });
            });
        });
        executor.await();
    }

    @Inject
    protected abstract WorkerExecutor getWorkerExecutor();

    @InputFile
    @Optional
    @PathSensitive(value=PathSensitivity.NONE)
    public abstract RegularFileProperty getVersionJsonFile();

    @Input
    public abstract Property<VersionJson> getVersionJson();

    @OutputDirectory
    public abstract DirectoryProperty getLibrariesDirectory();

    public Provider<FileTree> getOutputAsTree() {
        return this.getOutput().map(it -> this.getObjectFactory().fileTree().from(it));
    }
}

