/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.gradle.common.runs.ide;

import com.google.common.collect.Multimap;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.xml.stream.XMLStreamException;
import net.neoforged.elc.configs.GradleLaunchConfig;
import net.neoforged.elc.configs.JavaApplicationLaunchConfig;
import net.neoforged.elc.configs.LaunchConfig;
import net.neoforged.elc.configs.LaunchGroup;
import net.neoforged.gradle.common.extensions.IdeManagementExtension;
import net.neoforged.gradle.common.runs.ide.extensions.IdeaRunExtensionImpl;
import net.neoforged.gradle.common.runs.ide.idea.JUnitWithBeforeRun;
import net.neoforged.gradle.common.runs.run.RunImpl;
import net.neoforged.gradle.common.util.ProjectUtils;
import net.neoforged.gradle.common.util.SourceSetUtils;
import net.neoforged.gradle.common.util.run.RunsUtil;
import net.neoforged.gradle.dsl.common.extensions.Minecraft;
import net.neoforged.gradle.dsl.common.extensions.subsystems.Subsystems;
import net.neoforged.gradle.dsl.common.extensions.subsystems.conventions.ide.IDEA;
import net.neoforged.gradle.dsl.common.runs.ide.extensions.IdeaRunExtension;
import net.neoforged.gradle.dsl.common.runs.idea.extensions.IdeaRunsExtension;
import net.neoforged.gradle.dsl.common.runs.run.Run;
import net.neoforged.gradle.dsl.common.runs.run.RunManager;
import net.neoforged.gradle.dsl.common.util.CommonRuntimeUtils;
import net.neoforged.gradle.util.FileUtils;
import net.neoforged.vsclc.BatchedLaunchWriter;
import net.neoforged.vsclc.LaunchConfiguration;
import net.neoforged.vsclc.attribute.PathLike;
import net.neoforged.vsclc.attribute.ShortCmdBehaviour;
import net.neoforged.vsclc.writer.WritingMode;
import org.apache.commons.lang3.StringUtils;
import org.gradle.api.Action;
import org.gradle.api.GradleException;
import org.gradle.api.PolymorphicDomainObjectContainer;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.file.Directory;
import org.gradle.api.plugins.ExtensionAware;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Copy;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetContainer;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.language.jvm.tasks.ProcessResources;
import org.gradle.plugins.ide.eclipse.model.EclipseModel;
import org.gradle.plugins.ide.idea.model.IdeaModel;
import org.gradle.plugins.ide.idea.model.IdeaProject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.gradle.ext.Application;
import org.jetbrains.gradle.ext.BeforeRunTask;
import org.jetbrains.gradle.ext.GradleTask;
import org.jetbrains.gradle.ext.Make;
import org.jetbrains.gradle.ext.ProjectSettings;
import org.jetbrains.gradle.ext.RunConfigurationContainer;
import org.jetbrains.gradle.ext.ShortenCommandLine;

public class IdeRunIntegrationManager {
    private static final IdeRunIntegrationManager INSTANCE = new IdeRunIntegrationManager();

    public static IdeRunIntegrationManager getInstance() {
        return INSTANCE;
    }

    private IdeRunIntegrationManager() {
    }

    public void setup(Project project) {
        IdeaRunsExtension global;
        project.getExtensions().configure(RunManager.class, runs -> runs.configureAll(run -> this.setupRun(project, (Run)run)));
        Project rootProject = project.getRootProject();
        IdeaModel ideaModel = (IdeaModel)rootProject.getExtensions().getByType(IdeaModel.class);
        IdeaProject ideaProject = ideaModel.getProject();
        ExtensionAware extensionAware = (ExtensionAware)ideaProject;
        if (extensionAware.getExtensions().findByType(IdeaRunsExtension.class) == null && extensionAware.getExtensions().findByName("runs") == null) {
            global = (IdeaRunsExtension)extensionAware.getExtensions().create("runs", IdeaRunsExtension.class, new Object[]{project});
        } else if (extensionAware.getExtensions().findByType(IdeaRunsExtension.class) != null) {
            global = (IdeaRunsExtension)extensionAware.getExtensions().findByType(IdeaRunsExtension.class);
        } else {
            project.getLogger().warn("Runs extension for idea can not be registered on the Idea project model. Use the one in the minecraft extension.");
            global = null;
        }
        Minecraft minecraft = (Minecraft)project.getExtensions().getByType(Minecraft.class);
        IdeaRunsExtension projectLocal = (IdeaRunsExtension)minecraft.getExtensions().create("idea", IdeaRunsExtension.class, new Object[]{project});
        if (global != null) {
            projectLocal.getUseArgsFile().convention((Provider)global.getUseArgsFile());
            projectLocal.getRunWithIdea().convention((Provider)global.getRunWithIdea());
        }
    }

    public void setupRun(Project project, Run run) {
        run.getExtensions().create(IdeaRunExtension.class, "idea", IdeaRunExtensionImpl.class, new Object[]{project, run});
    }

    public void apply(Project project) {
        IdeManagementExtension ideManager = (IdeManagementExtension)project.getExtensions().getByType(IdeManagementExtension.class);
        project.afterEvaluate(evaluatedProject -> ideManager.apply(new RunsImportAction()));
    }

    public void configureIdeaConventions(Project project, IDEA ideaConventions) {
        Project rootProject = project.getRootProject();
        IdeaModel ideaModel = (IdeaModel)rootProject.getExtensions().getByType(IdeaModel.class);
        IdeaProject ideaProject = ideaModel.getProject();
        ExtensionAware extensionAware = (ExtensionAware)ideaProject;
        IdeaRunsExtension runsExtension = (IdeaRunsExtension)extensionAware.getExtensions().getByType(IdeaRunsExtension.class);
        runsExtension.getRunWithIdea().convention(ideaConventions.getShouldUseCompilerDetection().map(useCompilerDetection -> {
            if (!useCompilerDetection.booleanValue()) {
                return false;
            }
            File DotIdeaDirectory = new File(project.getProjectDir(), ".idea");
            File GradleXml = new File(DotIdeaDirectory, "gradle.xml");
            return FileUtils.contains((File)GradleXml, (String)"<option name=\"delegatedBuild\" value=\"false\" />");
        }));
        runsExtension.getUseArgsFile().convention((Provider)ideaConventions.getShouldUseArgsFile());
    }

    private static final class RunsImportAction
    implements IdeManagementExtension.IdeImportAction {
        private RunsImportAction() {
        }

        private void common(Project project) {
            SourceSetContainer container = (SourceSetContainer)project.getExtensions().getByType(SourceSetContainer.class);
            container.forEach(sourceSet -> {
                Configuration compileClasspath = project.getConfigurations().getByName(sourceSet.getCompileClasspathConfigurationName());
                Configuration runtimeClasspath = project.getConfigurations().getByName(sourceSet.getRuntimeClasspathConfigurationName());
                compileClasspath.resolve();
                runtimeClasspath.resolve();
            });
        }

        @Override
        public void idea(Project project, Project rootProject, IdeaModel idea, ProjectSettings ideaExtension) {
            project.afterEvaluate(evaluatedProject -> {
                this.common(project);
                RunConfigurationContainer ideaRuns = (RunConfigurationContainer)((ExtensionAware)ideaExtension).getExtensions().getByType(RunConfigurationContainer.class);
                RunsImportAction.attemptJUnitWithBeforeRunRegistration(project, ideaRuns);
                project.getExtensions().configure(RunManager.class, runs -> runs.all(run -> this.createIdeaRun(project, (Run)run, ideaRuns, false)));
                if (((Boolean)((Subsystems)project.getExtensions().getByType(Subsystems.class)).getConventions().getIde().getIdea().getShouldReconfigureTemplatesForTests().get()).booleanValue()) {
                    ExtensionAware ideaModelExtensions = (ExtensionAware)idea;
                    Run ideaDefaultUnitTestRun = (Run)ideaModelExtensions.getExtensions().getByType(Run.class);
                    RunManager runManager = (RunManager)project.getExtensions().getByType(RunManager.class);
                    runManager.addInternal(ideaDefaultUnitTestRun);
                    this.createIdeaRun(project, ideaDefaultUnitTestRun, ideaRuns, true);
                }
            });
        }

        private static void attemptJUnitWithBeforeRunRegistration(Project project, RunConfigurationContainer ideaRuns) {
            try {
                ideaRuns.registerFactory(JUnitWithBeforeRun.class, ideaTaskName -> (JUnitWithBeforeRun)((Object)((Object)project.getObjects().newInstance(JUnitWithBeforeRun.class, new Object[]{project, ideaTaskName}))));
            }
            catch (GradleException gradleException) {
                // empty catch block
            }
        }

        private void createIdeaRun(Project project, Run run, RunConfigurationContainer ideaRuns, boolean defaultRun) {
            if (!defaultRun && !((Boolean)run.getShouldExportToIDE().get()).booleanValue()) {
                return;
            }
            Minecraft minecraft = (Minecraft)project.getExtensions().getByType(Minecraft.class);
            IdeaRunsExtension ideaRunsExtension = (IdeaRunsExtension)minecraft.getExtensions().getByType(IdeaRunsExtension.class);
            String ideRunName = run.getIDERunName().isPresent() ? (String)run.getIDERunName().get() : run.getName();
            String runName = StringUtils.capitalize((String)(project.getName() + ": " + StringUtils.capitalize((String)ideRunName)));
            RunImpl runImpl = (RunImpl)run;
            TaskProvider<?> ideBeforeRunTask = this.getOrCreateIdeBeforeRunTask(project, runImpl);
            if (RunsUtil.isRunWithIdea(project)) {
                List<TaskProvider<?>> copyProcessResourcesTasks = this.createIntelliJCopyResourcesTasks(run);
                ideBeforeRunTask.configure(task -> copyProcessResourcesTasks.forEach(xva$0 -> task.dependsOn(new Object[]{xva$0})));
            }
            List<String> jvmArguments = runImpl.realiseJvmArguments();
            List programArguments = (List)runImpl.getArguments().get();
            Map<String, String> productionEnvironment = RunsImportAction.adaptEnvironment(runImpl, multimapProvider -> RunsUtil.buildRunWithIdeaModClasses((Provider<Multimap<String, SourceSet>>)multimapProvider, RunsUtil.IdeaCompileType.Production));
            Map<String, String> testEnvironment = RunsImportAction.adaptEnvironment(runImpl, multimapProvider -> RunsUtil.buildRunWithIdeaModClasses((Provider<Multimap<String, SourceSet>>)multimapProvider, RunsUtil.IdeaCompileType.Production), multimapProvider -> RunsUtil.buildRunWithIdeaModClasses((Provider<Multimap<String, SourceSet>>)multimapProvider, RunsUtil.IdeaCompileType.Test));
            if (!((Boolean)runImpl.getIsJUnit().get()).booleanValue()) {
                ideaRuns.register(runName, Application.class, ideaRun -> {
                    ((Directory)runImpl.getWorkingDirectory().get()).getAsFile().mkdirs();
                    ideaRun.setMainClass((String)runImpl.getMainClass().get());
                    ideaRun.setWorkingDirectory(((Directory)runImpl.getWorkingDirectory().get()).getAsFile().getAbsolutePath());
                    ideaRun.setJvmArgs(RunsUtil.escapeAndJoin(RunsUtil.deduplicateElementsFollowingEachOther(jvmArguments.stream()).collect(Collectors.toList()), new String[0]));
                    ideaRun.setModuleName(RunsUtil.getIntellijModuleName((SourceSet)((IdeaRunExtension)run.getExtensions().getByType(IdeaRunExtension.class)).getPrimarySourceSet().get()));
                    ideaRun.setProgramParameters(RunsUtil.escapeAndJoin(RunsUtil.deduplicateElementsFollowingEachOther(programArguments.stream()).collect(Collectors.toList()), new String[0]));
                    ideaRun.setEnvs(productionEnvironment);
                    if (((Boolean)ideaRunsExtension.getUseArgsFile().get()).booleanValue()) {
                        ideaRun.setShortenCommandLine(ShortenCommandLine.ARGS_FILE);
                    }
                    ideaRun.beforeRun(beforeRuns -> {
                        beforeRuns.create("Build", Make.class);
                        beforeRuns.create("Prepare Run", GradleTask.class, gradleTask -> gradleTask.setTask((Task)ideBeforeRunTask.get()));
                    });
                    ideaRun.setDefaults(defaultRun);
                });
            } else {
                ideaRuns.register(runName, JUnitWithBeforeRun.class, ideaRun -> {
                    RunsUtil.PreparedUnitTestEnvironment preparedUnitTestEnvironment = RunsUtil.prepareUnitTestEnvironment(run, jvmArguments, programArguments);
                    ideaRun.setWorkingDirectory(((Directory)runImpl.getWorkingDirectory().get()).getAsFile().getAbsolutePath());
                    ideaRun.setModuleName(RunsUtil.getIntellijModuleName((SourceSet)((IdeaRunExtension)run.getExtensions().getByType(IdeaRunExtension.class)).getPrimarySourceSet().get()));
                    ideaRun.setPackageName((String)runImpl.getTestScope().getPackageName().getOrNull());
                    ideaRun.setDirectory((String)runImpl.getTestScope().getDirectory().map(dir -> dir.getAsFile().getAbsolutePath()).getOrNull());
                    ideaRun.setPattern((String)runImpl.getTestScope().getPattern().getOrNull());
                    ideaRun.setClassName((String)runImpl.getTestScope().getClassName().getOrNull());
                    ideaRun.setMethod((String)runImpl.getTestScope().getMethod().getOrNull());
                    ideaRun.setCategory((String)runImpl.getTestScope().getCategory().getOrNull());
                    ideaRun.setWorkingDirectory(((Directory)runImpl.getWorkingDirectory().get()).getAsFile().getAbsolutePath());
                    ideaRun.setVmParameters(RunsUtil.escapeAndJoin(jvmArguments, "-Dfml.junit.argsfile=%s".formatted(preparedUnitTestEnvironment.programArgumentsFile().getAbsolutePath()), "@%s".formatted(preparedUnitTestEnvironment.jvmArgumentsFile().getAbsolutePath())));
                    ideaRun.setEnvs(testEnvironment);
                    if (((Boolean)ideaRunsExtension.getUseArgsFile().get()).booleanValue()) {
                        ideaRun.setShortenCommandLine(ShortenCommandLine.ARGS_FILE);
                    }
                    ideaRun.beforeRun((Action<PolymorphicDomainObjectContainer<BeforeRunTask>>)((Action)beforeRuns -> {
                        beforeRuns.create("Build", Make.class);
                        beforeRuns.create("Prepare JUnit Test", GradleTask.class, gradleTask -> gradleTask.setTask((Task)ideBeforeRunTask.get()));
                    }));
                    ideaRun.setDefaults(defaultRun);
                });
            }
        }

        @Override
        public void eclipse(Project project, EclipseModel eclipse) {
            ProjectUtils.afterEvaluate(project, () -> {
                this.common(project);
                project.getExtensions().configure(RunManager.class, runs -> runs.all(run -> {
                    if (!((Boolean)run.getShouldExportToIDE().get()).booleanValue()) {
                        return;
                    }
                    String name = run.getName();
                    String runName = StringUtils.capitalize((String)(project.getName() + " - " + StringUtils.capitalize((String)name.replace(" ", "-"))));
                    RunImpl runImpl = (RunImpl)run;
                    if (((Boolean)runImpl.getIsJUnit().get()).booleanValue()) {
                        return;
                    }
                    TaskProvider<?> ideBeforeRunTask = this.getOrCreateIdeBeforeRunTask(project, runImpl);
                    List<TaskProvider<?>> copyProcessResourcesTasks = this.createEclipseCopyResourcesTasks((Run)run);
                    ideBeforeRunTask.configure(task -> copyProcessResourcesTasks.forEach(xva$0 -> task.dependsOn(new Object[]{xva$0})));
                    try {
                        GradleLaunchConfig idePreRunTask = GradleLaunchConfig.builder((String)eclipse.getProject().getName()).tasks(new String[]{((Task)ideBeforeRunTask.get()).getName()}).build();
                        String gradleName = "Prepare " + runName;
                        RunsImportAction.writeLaunchToFile(project, gradleName, (LaunchConfig)idePreRunTask);
                        JavaApplicationLaunchConfig debugRun = JavaApplicationLaunchConfig.builder((String)eclipse.getProject().getName()).workingDirectory(((Directory)runImpl.getWorkingDirectory().get()).getAsFile().getAbsolutePath()).vmArgs((String[])RunsUtil.deduplicateElementsFollowingEachOther(RunsUtil.escapeStream(runImpl.realiseJvmArguments(), new String[0])).toArray(String[]::new)).args((String[])RunsUtil.deduplicateElementsFollowingEachOther(RunsUtil.escapeStream((List)runImpl.getArguments().get(), new String[0])).toArray(String[]::new)).envVar(RunsImportAction.adaptEnvironment(runImpl, RunsUtil::buildRunWithEclipseModClasses)).useArgumentsFile().build((String)runImpl.getMainClass().get());
                        String debugName = "Run " + runName;
                        RunsImportAction.writeLaunchToFile(project, debugName, (LaunchConfig)debugRun);
                        String launchCombinedName = StringUtils.capitalize((String)(project.getName() + " - " + (run.getIDERunName().isPresent() ? (String)run.getIDERunName().get() : run.getName())));
                        RunsImportAction.writeLaunchToFile(project, launchCombinedName, (LaunchConfig)LaunchGroup.builder().entry(LaunchGroup.entry((String)gradleName).enabled(true).adoptIfRunning(false).mode(LaunchGroup.Mode.RUN).action(LaunchGroup.Action.delay((int)2))).entry(LaunchGroup.entry((String)debugName).enabled(true).adoptIfRunning(false).mode(LaunchGroup.Mode.DEBUG).action(LaunchGroup.Action.none())).build());
                    }
                    catch (IllegalStateException e) {
                        Thread currentThread = Thread.currentThread();
                        project.getLogger().error("Failed to write launch files: {}", (Object)runName, (Object)e);
                        project.getLogger().error("Thread: {} - {}", (Object)currentThread.getName(), (Object)currentThread.getId());
                        throw new GradleException("Failed to write launch files: " + runName + ". Current Thread: " + currentThread.getName(), (Throwable)e);
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Failed to write launch files: " + runName, e);
                    }
                }));
            });
        }

        @Override
        public void vscode(Project project, EclipseModel eclipse) {
            ProjectUtils.afterEvaluate(project, () -> {
                this.common(project);
                BatchedLaunchWriter launchWriter = new BatchedLaunchWriter(WritingMode.MODIFY_CURRENT);
                project.getExtensions().configure(RunManager.class, runs -> runs.all(run -> {
                    if (!((Boolean)run.getShouldExportToIDE().get()).booleanValue()) {
                        return;
                    }
                    String runName = StringUtils.capitalize((String)(project.getName() + " - " + StringUtils.capitalize((String)(run.getIDERunName().isPresent() ? (String)run.getIDERunName().get() : run.getName()))));
                    RunImpl runImpl = (RunImpl)run;
                    TaskProvider<?> ideBeforeRunTask = this.getOrCreateIdeBeforeRunTask(project, runImpl);
                    List<TaskProvider<?>> copyProcessResourcesTasks = this.createEclipseCopyResourcesTasks((Run)run);
                    ideBeforeRunTask.configure(task -> copyProcessResourcesTasks.forEach(xva$0 -> task.dependsOn(new Object[]{xva$0})));
                    LaunchConfiguration cfg = (LaunchConfiguration)((LaunchConfiguration)launchWriter.createGroup("NG - " + project.getName(), WritingMode.REMOVE_EXISTING).createLaunchConfiguration().withAdditionalJvmArgs(RunsUtil.deduplicateElementsFollowingEachOther(runImpl.realiseJvmArguments().stream()).collect(Collectors.toList())).withArguments(RunsUtil.deduplicateElementsFollowingEachOther(((List)runImpl.getArguments().get()).stream()).collect(Collectors.toList())).withCurrentWorkingDirectory(PathLike.ofNio((Path)((Directory)runImpl.getWorkingDirectory().get()).getAsFile().toPath())).withEnvironmentVariables(RunsImportAction.adaptEnvironment(runImpl, RunsUtil::buildRunWithEclipseModClasses)).withShortenCommandLine(ShortCmdBehaviour.ARGUMENT_FILE).withMainClass((String)runImpl.getMainClass().get()).withProjectName(eclipse.getProject().getName())).withName(runName);
                    if (IdeManagementExtension.isVscodePluginImport(project)) {
                        cfg.withPreTaskName("gradle: " + ideBeforeRunTask.getName());
                    } else {
                        eclipse.autoBuildTasks(new Object[]{ideBeforeRunTask});
                    }
                }));
                try {
                    launchWriter.writeToLatestJson(project.getRootDir().toPath());
                }
                catch (IOException e) {
                    throw new RuntimeException("Failed to write launch files", e);
                }
            });
        }

        private TaskProvider<?> getOrCreateIdeBeforeRunTask(Project project, RunImpl run) {
            if (project.getTasks().getNames().contains("ideBeforeRun")) {
                TaskProvider provider = project.getTasks().named("ideBeforeRun");
                provider.configure(task -> {
                    RunsUtil.addRunSourcesDependenciesToTask(task, run, false);
                    task.getDependsOn().add(run.getDependsOn());
                });
                return provider;
            }
            return project.getTasks().register("ideBeforeRun", task -> {
                RunsUtil.addRunSourcesDependenciesToTask(task, run, false);
                task.getDependsOn().add(run.getDependsOn());
            });
        }

        private List<TaskProvider<?>> createIntelliJCopyResourcesTasks(Run run) {
            ArrayList copyProcessResources = new ArrayList();
            for (SourceSet sourceSet : ((Multimap)run.getModSources().all().get()).values()) {
                copyProcessResources.add(RunsImportAction.setupCopyResourcesForIdea(sourceSet, RunsUtil.IdeaCompileType.Production));
            }
            if (((Boolean)run.getIsJUnit().get()).booleanValue()) {
                for (SourceSet sourceSet : ((Multimap)run.getUnitTestSources().all().get()).values()) {
                    copyProcessResources.add(RunsImportAction.setupCopyResourcesForIdea(sourceSet, RunsUtil.IdeaCompileType.Test));
                }
            }
            return copyProcessResources;
        }

        @NotNull
        private static TaskProvider<?> setupCopyResourcesForIdea(SourceSet sourceSet, RunsUtil.IdeaCompileType compileType) {
            Project sourceSetProject = SourceSetUtils.getProject(sourceSet);
            String taskPrefix = CommonRuntimeUtils.buildTaskName((String)"intelliJCopy", (String)compileType.name());
            String taskName = CommonRuntimeUtils.buildTaskName((String)taskPrefix, (String)sourceSet.getProcessResourcesTaskName());
            TaskProvider intelliJResourcesTask = sourceSetProject.getTasks().findByName(taskName) != null ? sourceSetProject.getTasks().named(taskName) : sourceSetProject.getTasks().register(taskName, Copy.class, task -> {
                TaskProvider defaultProcessResources = sourceSetProject.getTasks().named(sourceSet.getProcessResourcesTaskName(), ProcessResources.class);
                task.from(new Object[]{defaultProcessResources.map(Copy::getDestinationDir)});
                task.into(RunsUtil.getRunWithIdeaResourcesDirectory(sourceSet, compileType));
                task.dependsOn(new Object[]{defaultProcessResources});
            });
            return intelliJResourcesTask;
        }

        private List<TaskProvider<?>> createEclipseCopyResourcesTasks(Run run) {
            ArrayList copyProcessResources = new ArrayList();
            for (SourceSet sourceSet : ((Multimap)run.getModSources().all().get()).values()) {
                Project sourceSetProject = SourceSetUtils.getProject(sourceSet);
                String taskName = CommonRuntimeUtils.buildTaskName((String)"eclipseCopy", (String)sourceSet.getProcessResourcesTaskName());
                TaskProvider eclipseResourcesTask = sourceSetProject.getTasks().findByName(taskName) != null ? sourceSetProject.getTasks().named(taskName) : sourceSetProject.getTasks().register(taskName, Copy.class, task -> {
                    TaskProvider defaultProcessResources = sourceSetProject.getTasks().named(sourceSet.getProcessResourcesTaskName(), ProcessResources.class);
                    task.from(new Object[]{defaultProcessResources.map(Copy::getDestinationDir)});
                    Path outputDir = RunsImportAction.getEclipseOutputDirectory(sourceSetProject);
                    if (outputDir.endsWith("default")) {
                        outputDir = outputDir.getParent();
                    }
                    task.into((Object)outputDir.resolve(sourceSet.getName()));
                    task.dependsOn(new Object[]{defaultProcessResources});
                });
                copyProcessResources.add(eclipseResourcesTask);
            }
            return copyProcessResources;
        }

        @NotNull
        private static Path getEclipseOutputDirectory(Project sourceSetProject) {
            if (sourceSetProject.getExtensions().findByType(IdeManagementExtension.class) == null) {
                if (sourceSetProject.getExtensions().findByType(EclipseModel.class) == null) {
                    throw new IllegalStateException("EclipseModel not found in project: " + String.valueOf(sourceSetProject));
                }
                return ((EclipseModel)sourceSetProject.getExtensions().getByType(EclipseModel.class)).getClasspath().getDefaultOutputDir().toPath();
            }
            return ((IdeManagementExtension)sourceSetProject.getExtensions().getByType(IdeManagementExtension.class)).getEclipseModel().getClasspath().getDefaultOutputDir().toPath();
        }

        private static void writeLaunchToFile(Project project, String fileName, LaunchConfig config) {
            File file = project.file((Object)String.format(".eclipse/configurations/%s.launch", fileName));
            file.getParentFile().mkdirs();
            try (FileWriter writer = new FileWriter(file, false);){
                config.write((Writer)writer);
            }
            catch (IOException e) {
                throw new UncheckedIOException("Failed to write launch file: " + fileName, e);
            }
            catch (XMLStreamException e) {
                throw new RuntimeException("Failed to write launch file: " + fileName, e);
            }
        }

        private static Map<String, String> adaptEnvironment(RunImpl run, Function<Provider<Multimap<String, SourceSet>>, Provider<String>> modClassesProvider) {
            HashMap<String, String> environment = new HashMap<String, String>((Map)run.getEnvironmentVariables().get());
            environment.put("MOD_CLASSES", (String)modClassesProvider.apply((Provider<Multimap<String, SourceSet>>)run.getModSources().all()).get());
            return environment;
        }

        private static Map<String, String> adaptEnvironment(RunImpl run, Function<Provider<Multimap<String, SourceSet>>, Provider<String>> modClassesProvider, Function<Provider<Multimap<String, SourceSet>>, Provider<String>> modTestClassesProvider) {
            HashMap<String, String> environment = new HashMap<String, String>((Map)run.getEnvironmentVariables().get());
            Provider joinedModClasses = modClassesProvider.apply((Provider<Multimap<String, SourceSet>>)run.getModSources().all()).zip(modTestClassesProvider.apply((Provider<Multimap<String, SourceSet>>)run.getUnitTestSources().all()), (modClasses, testClasses) -> modClasses + File.pathSeparator + testClasses);
            environment.put("MOD_CLASSES", (String)joinedModClasses.get());
            return environment;
        }
    }
}

