/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.gradle.common.interfaceinjection;

import java.io.File;
import java.util.Comparator;
import java.util.List;
import net.neoforged.gradle.common.util.ProjectUtils;
import net.neoforged.gradle.dsl.common.extensions.InterfaceInjections;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.attributes.Category;
import org.gradle.api.component.AdhocComponentWithVariants;

public class InterfaceInjectionPublishing {
    public static final String INTERFACE_INJECTION_ELEMENTS_CONFIGURATION = "interfaceInjectionElements";
    public static final String INTERFACE_INJECTION_API_CONFIGURATION = "interfaceInjectionApi";
    public static final String INTERFACE_INJECTION_CONFIGURATION = "interfaceInjection";
    public static final String INTERFACE_INJECTION_CATEGORY = "interfaceinjection";

    public static void setup(Project project) {
        InterfaceInjections extension = (InterfaceInjections)project.getExtensions().getByType(InterfaceInjections.class);
        Configuration elementsConfig = (Configuration)project.getConfigurations().maybeCreate(INTERFACE_INJECTION_ELEMENTS_CONFIGURATION);
        Configuration apiConfig = (Configuration)project.getConfigurations().maybeCreate(INTERFACE_INJECTION_API_CONFIGURATION);
        Configuration implementationConfig = (Configuration)project.getConfigurations().maybeCreate(INTERFACE_INJECTION_CONFIGURATION);
        apiConfig.setCanBeConsumed(false);
        apiConfig.setCanBeResolved(false);
        implementationConfig.setCanBeConsumed(false);
        implementationConfig.setCanBeResolved(true);
        elementsConfig.setCanBeConsumed(true);
        elementsConfig.setCanBeResolved(false);
        elementsConfig.setCanBeDeclared(false);
        Action action = attributes -> attributes.attribute(Category.CATEGORY_ATTRIBUTE, (Object)((Category)project.getObjects().named(Category.class, INTERFACE_INJECTION_CATEGORY)));
        elementsConfig.attributes(action);
        implementationConfig.attributes(action);
        implementationConfig.extendsFrom(new Configuration[]{apiConfig});
        elementsConfig.extendsFrom(new Configuration[]{apiConfig});
        AdhocComponentWithVariants java = (AdhocComponentWithVariants)project.getComponents().getByName("java");
        Runnable enable = () -> java.addVariantsFromConfiguration(elementsConfig, variant -> {});
        elementsConfig.getAllDependencies().configureEach(dep -> enable.run());
        elementsConfig.getArtifacts().configureEach(artifact -> enable.run());
        extension.getFiles().from(new Object[]{implementationConfig});
        ProjectUtils.afterEvaluate(project, () -> {
            apiConfig.fromDependencyCollector(extension.getConsumeApi());
            implementationConfig.fromDependencyCollector(extension.getConsume());
            List<File> files = extension.getFiles().getFiles().stream().sorted(Comparator.comparing(File::getName)).toList();
            for (int i = 0; i < files.size(); ++i) {
                File file = files.get(i);
                if (files.size() == 1) {
                    extension.expose((Object)file, artifact -> artifact.setClassifier("interface-injections"));
                    continue;
                }
                int index = i;
                extension.expose((Object)file, artifact -> artifact.setClassifier("interface-injection-%d".formatted(index)));
            }
        });
    }
}

