/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.gradle.common.dependency;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Optional;
import net.neoforged.gradle.common.dependency.AbstractDependencyManagementObject;
import net.neoforged.gradle.dsl.common.dependency.DependencyManagementObject;
import net.neoforged.gradle.dsl.common.dependency.DependencyVersionInformationHandler;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.VersionRange;
import org.gradle.api.specs.Spec;

public abstract class DefaultDependencyVersionInformationHandler
extends AbstractDependencyManagementObject
implements DependencyVersionInformationHandler {
    private final Map<Spec<? super DependencyManagementObject.ArtifactIdentifier>, String> rangedVersions = Maps.newHashMap();
    private final Map<Spec<? super DependencyManagementObject.ArtifactIdentifier>, String> pinnedVersions = Maps.newHashMap();

    public void ranged(Spec<? super DependencyManagementObject.ArtifactIdentifier> spec, String range) {
        this.rangedVersions.put(spec, range);
    }

    public void ranged(Spec<? super DependencyManagementObject.ArtifactIdentifier> spec, VersionRange range) {
        this.ranged(spec, range.toString());
    }

    public void ranged(Spec<? super DependencyManagementObject.ArtifactIdentifier> spec, ArtifactVersion version) {
        this.ranged(spec, String.format("[%s,%s]", version, version));
    }

    public void pin(Spec<? super DependencyManagementObject.ArtifactIdentifier> spec, String version) {
        this.pinnedVersions.put(spec, version);
    }

    public void pin(Spec<? super DependencyManagementObject.ArtifactIdentifier> spec, ArtifactVersion version) {
        this.pin(spec, version.toString());
    }

    public Optional<String> getVersionRange(DependencyManagementObject.ArtifactIdentifier identifier) {
        return this.rangedVersions.entrySet().stream().filter(entry -> ((Spec)entry.getKey()).isSatisfiedBy((Object)identifier)).map(Map.Entry::getValue).findFirst();
    }

    public Optional<String> getVersion(DependencyManagementObject.ArtifactIdentifier identifier) {
        return this.pinnedVersions.entrySet().stream().filter(entry -> ((Spec)entry.getKey()).isSatisfiedBy((Object)identifier)).map(Map.Entry::getValue).findFirst();
    }
}

