/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.gradle.common.services.caching.jobs;

import com.machinezoo.noexception.throwing.ThrowingFunction;
import com.machinezoo.noexception.throwing.ThrowingSupplier;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileSystemLocationProperty;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.Provider;

public interface ICacheableJob<I, O> {
    default public String name() {
        return "default";
    }

    public List<OutputEntry> outputs();

    public O execute(I var1) throws Throwable;

    public record Staged<I, O>(String name, List<OutputEntry> outputs, ThrowingFunction<I, O> job) implements ICacheableJob<I, O>
    {
        public static <U, V> Staged<U, V> file(String name, ThrowingFunction<U, V> execute, RegularFileProperty ... output) {
            return new Staged<U, V>(name, Arrays.stream(output).map(FileSystemLocationProperty::getAsFile).map(Provider::get).map(OutputEntry::file).toList(), execute);
        }

        public static <U, V> Staged<U, V> file(String name, ThrowingSupplier<V> execute, RegularFileProperty ... output) {
            return new Staged(name, Arrays.stream(output).map(FileSystemLocationProperty::getAsFile).map(Provider::get).map(OutputEntry::file).toList(), u -> execute.get());
        }

        public static <U, V> Staged<U, V> file(String name, ThrowingRunnable execute, RegularFileProperty ... output) {
            return new Staged(name, Arrays.stream(output).map(FileSystemLocationProperty::getAsFile).map(Provider::get).map(OutputEntry::file).toList(), u -> {
                execute.run();
                return null;
            });
        }

        @Override
        public O execute(I input) throws Throwable {
            return (O)this.job.apply(input);
        }
    }

    public record Initial<V>(String name, List<OutputEntry> outputs, ThrowingSupplier<V> execute) implements ICacheableJob<Void, V>
    {
        public static <V> Initial<V> file(String name, ThrowingSupplier<V> execute, RegularFileProperty ... output) {
            return new Initial<V>(name, Arrays.stream(output).map(FileSystemLocationProperty::getAsFile).map(Provider::get).map(OutputEntry::file).toList(), execute);
        }

        public static <V> Initial<V> directory(String name, Provider<Directory> output, ThrowingSupplier<V> execute) {
            return new Initial<V>(name, List.of(OutputEntry.createsDirectory(((Directory)output.get()).getAsFile())), execute);
        }

        public static <V> Initial<V> merging(String name, Provider<Directory> output, ThrowingSupplier<V> execute) {
            return new Initial<V>(name, List.of(OutputEntry.mergesDirectory(((Directory)output.get()).getAsFile())), execute);
        }

        @Override
        public V execute(Void input) throws Throwable {
            return (V)this.execute().get();
        }
    }

    public record Default(List<OutputEntry> outputs, ThrowingRunnable execute) implements ICacheableJob<Void, Void>
    {
        public static Default of(ThrowingRunnable execute, OutputEntry ... entries) {
            return new Default(List.of(entries), execute);
        }

        public static Default file(ThrowingRunnable execute, RegularFileProperty ... output) {
            return new Default(Arrays.stream(output).map(FileSystemLocationProperty::getAsFile).map(Provider::get).map(OutputEntry::file).toList(), execute);
        }

        public static Default file(ThrowingRunnable execute, List<RegularFileProperty> output) {
            return new Default(output.stream().map(FileSystemLocationProperty::getAsFile).map(Provider::get).map(OutputEntry::file).toList(), execute);
        }

        public static Default directory(DirectoryProperty output, ThrowingRunnable execute) {
            return new Default(List.of(OutputEntry.createsDirectory(((Directory)output.get()).getAsFile())), execute);
        }

        @Override
        public Void execute(Void input) throws Exception {
            this.execute().run();
            return null;
        }
    }

    public record OutputEntry(File output, boolean isDirectory, boolean createsDirectory, boolean mergesDirectory) {
        public static OutputEntry file(File output) {
            return new OutputEntry(output, false, false, false);
        }

        public static OutputEntry directory(File output) {
            return new OutputEntry(output, true, false, false);
        }

        public static OutputEntry createsDirectory(File output) {
            return new OutputEntry(output, true, true, false);
        }

        public static OutputEntry mergesDirectory(File output) {
            return new OutputEntry(output, true, false, true);
        }
    }

    @FunctionalInterface
    public static interface ThrowingRunnable {
        public void run() throws Exception;
    }
}

