/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.gradle.common.services.caching.cache;

import java.io.File;
import java.io.IOException;
import java.util.List;
import net.neoforged.gradle.common.services.caching.cache.DirectoryCache;
import net.neoforged.gradle.common.services.caching.cache.FileCache;
import net.neoforged.gradle.common.services.caching.cache.ICache;
import net.neoforged.gradle.common.services.caching.jobs.ICacheableJob;
import net.neoforged.gradle.common.services.caching.locking.FileBasedLock;
import net.neoforged.gradle.common.services.caching.locking.LockManager;
import net.neoforged.gradle.common.services.caching.logging.CacheLogger;

public class MultiEntryCache
implements ICache {
    private final File cacheDir;

    public MultiEntryCache(File cacheDir) {
        this.cacheDir = cacheDir;
    }

    @Override
    public void loadFrom(List<ICacheableJob.OutputEntry> file) throws IOException {
        for (ICacheableJob.OutputEntry outputEntry : file) {
            if (outputEntry.isDirectory()) {
                new DirectoryCache(this.cacheDir, outputEntry.mergesDirectory()).loadFrom(outputEntry);
                continue;
            }
            new FileCache(this.cacheDir).loadFrom(outputEntry);
        }
    }

    @Override
    public boolean restoreTo(List<ICacheableJob.OutputEntry> file) throws IOException {
        boolean restored = true;
        for (ICacheableJob.OutputEntry file1 : file) {
            if (this.restoreTo(file1)) continue;
            restored = false;
        }
        return restored;
    }

    public boolean restoreTo(ICacheableJob.OutputEntry outputEntry) throws IOException {
        if (outputEntry.isDirectory()) {
            return new DirectoryCache(this.cacheDir, outputEntry.mergesDirectory()).restoreTo(outputEntry);
        }
        return new FileCache(this.cacheDir).restoreTo(outputEntry);
    }

    @Override
    public FileBasedLock createLock(CacheLogger logger) {
        return LockManager.createLock(this.cacheDir, logger);
    }

    @Override
    public boolean canRestore(List<ICacheableJob.OutputEntry> output) {
        boolean restoreable = true;
        for (ICacheableJob.OutputEntry file : output) {
            if (this.canRestore(file)) continue;
            restoreable = false;
        }
        return restoreable;
    }

    public boolean canRestore(ICacheableJob.OutputEntry outputEntry) {
        if (outputEntry.isDirectory()) {
            return new DirectoryCache(this.cacheDir, outputEntry.mergesDirectory()).canRestore(outputEntry);
        }
        return new FileCache(this.cacheDir).canRestore(outputEntry);
    }
}

