/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.gradle.common.extensions.problems;

import net.neoforged.gradle.common.util.NeoGradleUtils;
import org.gradle.api.logging.Logger;

public final class NeoGradleProblemSpec {
    private String category;
    private String id;
    private String contextualLabel;
    private String solution;
    private String details;
    private String section;
    private String documentationUrl;

    public NeoGradleProblemSpec id(String category, String id) {
        this.category = category;
        this.id = id;
        return this;
    }

    public NeoGradleProblemSpec contextualLabel(String contextualLabel) {
        this.contextualLabel = contextualLabel;
        return this;
    }

    public NeoGradleProblemSpec solution(String solution) {
        this.solution = solution;
        return this;
    }

    public NeoGradleProblemSpec details(String details) {
        this.details = details;
        return this;
    }

    public NeoGradleProblemSpec section(String section) {
        this.section = section;
        return this;
    }

    public NeoGradleProblemSpec documentedAt(String url) {
        this.documentationUrl = url;
        return this;
    }

    String category() {
        return this.category;
    }

    String id() {
        return this.id;
    }

    String contextualLabel() {
        return this.contextualLabel;
    }

    String solution() {
        return this.solution;
    }

    String details() {
        return this.details;
    }

    String getSection() {
        return this.section;
    }

    String documentedAt() {
        if (this.documentationUrl != null) {
            return this.documentationUrl;
        }
        return NeoGradleProblemSpec.readMeUrl(this.section);
    }

    void log(Logger logger) {
        logger.warn("-------------------------------------");
        logger.warn("NeoGradle detected a problem with your project: %s".formatted(this.contextualLabel));
        logger.warn("Details: %s".formatted(this.details));
        logger.warn("Potential Solution: %s".formatted(this.solution));
        logger.warn("More information: %s".formatted(this.documentedAt()));
        logger.warn("-------------------------------------");
    }

    private static String readMeUrl(String section) {
        String neogradleVersion = NeoGradleUtils.getNeogradleVersion();
        String branchMajorVersion = neogradleVersion.split("\\.")[0];
        String branchMinorVersion = neogradleVersion.split("\\.")[1];
        String branch = "NG_%s.%s".formatted(branchMajorVersion, branchMinorVersion);
        return "https://github.com/neoforged/NeoGradle/blob/%s/README.md#%s".formatted(branch, section);
    }
}

