/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.gradle.common.tasks;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipOutputStream;
import net.neoforged.gradle.common.runtime.tasks.DefaultRuntime;
import net.neoforged.gradle.common.services.caching.CachedExecutionService;
import net.neoforged.gradle.common.services.caching.jobs.ICacheableJob;
import net.neoforged.gradle.dsl.common.tasks.WithOperations;
import net.neoforged.gradle.dsl.common.tasks.WithOutput;
import net.neoforged.gradle.dsl.common.tasks.WithWorkspace;
import net.neoforged.gradle.dsl.common.tasks.specifications.InputFileSpecification;
import net.neoforged.gradle.util.ClassVisitingFileTreeVisitor;
import org.gradle.api.Task;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileTree;
import org.gradle.api.file.FileVisitor;
import org.gradle.api.provider.Property;
import org.gradle.api.services.ServiceReference;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;
import org.objectweb.asm.ClassVisitor;

@CacheableTask
public abstract class InjectInterfacesTask
extends DefaultRuntime
implements WithOutput,
InputFileSpecification,
WithOperations,
WithWorkspace {
    @ServiceReference(value="CachedExecutionService")
    public abstract Property<CachedExecutionService> getCacheService();

    @InputFiles
    @PathSensitive(value=PathSensitivity.NONE)
    public abstract ConfigurableFileCollection getInterfaceInjectionFiles();

    @TaskAction
    public void injectInterfaces() throws IOException {
        ((CachedExecutionService)this.getCacheService().get()).cached((Task)this, ICacheableJob.Default.file(this::doInjectInterfaces, this.getOutput())).execute();
    }

    private void doInjectInterfaces() throws IOException {
        Map<String, List<String>> injectionMap = this.parseInjectionFiles();
        FileTree input = this.getArchiveOperations().zipTree((Object)this.getInput());
        try (FileOutputStream fos = new FileOutputStream(this.ensureFileWorkspaceReady(this.getOutput()));
             ZipOutputStream zos = new ZipOutputStream(fos);){
            ClassVisitingFileTreeVisitor visitor = new ClassVisitingFileTreeVisitor(zos, (api, cv) -> new InjectInterfacesClassVisitor(api, cv, injectionMap));
            input.visit((FileVisitor)visitor);
        }
    }

    private Map<String, List<String>> parseInjectionFiles() throws IOException {
        HashMap<String, List<String>> result = new HashMap<String, List<String>>();
        ObjectMapper mapper = new ObjectMapper();
        for (File file : this.getInterfaceInjectionFiles().getFiles()) {
            Map map = (Map)mapper.readValue(file, (TypeReference)new TypeReference<Map<String, Object>>(){});
            for (Map.Entry entry : map.entrySet()) {
                List interfaces;
                if (entry.getValue() instanceof String) {
                    interfaces = List.of((String)entry.getValue());
                } else {
                    Object v = entry.getValue();
                    if (v instanceof List) {
                        List l = (List)v;
                        interfaces = (List)entry.getValue();
                    } else {
                        throw new IllegalArgumentException("Invalid interface injection format in " + String.valueOf(file) + ": " + String.valueOf(entry.getValue()));
                    }
                }
                interfaces = interfaces.stream().map(s -> s.replace(".", "/")).toList();
                result.merge((String)entry.getKey(), interfaces, (a, b) -> {
                    ArrayList l = new ArrayList(a);
                    l.addAll(b);
                    return l;
                });
            }
        }
        return result;
    }

    @VisibleForTesting
    static class InjectInterfacesClassVisitor
    extends ClassVisitor {
        private final Map<String, List<String>> injectionMap;
        private List<String> interfacesToInject;

        public InjectInterfacesClassVisitor(int api, ClassVisitor classVisitor, Map<String, List<String>> injectionMap) {
            super(api, classVisitor);
            this.injectionMap = injectionMap;
        }

        public void visit(int version, int access, String name, @Nullable String signature, String superName, String[] interfaces) {
            this.interfacesToInject = this.injectionMap.getOrDefault(name, Collections.emptyList());
            LinkedHashSet<String> all = new LinkedHashSet<String>();
            Collections.addAll(all, interfaces);
            all.addAll(this.interfacesToInject.stream().map(i -> i.contains("<") ? i.substring(0, i.indexOf(60)) : i).toList());
            String[] newInterfaces = all.toArray(new String[0]);
            if (signature == null && !this.interfacesToInject.isEmpty()) {
                signature = "";
            }
            if (!this.interfacesToInject.isEmpty()) {
                ArrayList<String> interfaceSignatures = new ArrayList<String>();
                for (String iface : this.interfacesToInject) {
                    if (iface.contains("<")) {
                        StringBuilder interfaceSignature = InjectInterfacesClassVisitor.createGenericSignature(iface);
                        interfaceSignatures.add(interfaceSignature.toString());
                        continue;
                    }
                    interfaceSignatures.add("L%s;".formatted(iface));
                }
                StringBuilder sb = new StringBuilder();
                sb.append(signature);
                for (String sig : interfaceSignatures) {
                    sb.append(sig);
                }
                signature = sb.toString();
            }
            super.visit(version, access, name, signature, superName, newInterfaces);
        }

        private static StringBuilder createGenericSignature(String iface) {
            String[] generics;
            StringBuilder interfaceSignature = new StringBuilder();
            interfaceSignature.append("L");
            interfaceSignature.append(iface, 0, iface.indexOf(60));
            interfaceSignature.append("<");
            for (String generic : generics = iface.substring(iface.indexOf(60) + 1, iface.lastIndexOf(62)).split(",")) {
                if (generic.contains("/")) {
                    interfaceSignature.append("L%s;".formatted(generic));
                    continue;
                }
                interfaceSignature.append("T%s;".formatted(generic));
            }
            interfaceSignature.append(">");
            interfaceSignature.append(";");
            return interfaceSignature;
        }
    }
}

