/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.gradle.common.services.caching;

import com.google.common.collect.ImmutableList;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import net.neoforged.gradle.common.services.caching.cache.ICache;
import net.neoforged.gradle.common.services.caching.cache.MultiEntryCache;
import net.neoforged.gradle.common.services.caching.hasher.TaskHasher;
import net.neoforged.gradle.common.services.caching.jobs.ICacheableJob;
import net.neoforged.gradle.common.services.caching.locking.FileBasedLock;
import net.neoforged.gradle.common.services.caching.logging.CacheLogger;
import net.neoforged.gradle.common.util.hash.HashCode;
import net.neoforged.gradle.common.util.hash.Hasher;
import net.neoforged.gradle.common.util.hash.Hashing;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.io.FileUtils;
import org.gradle.api.GradleException;
import org.gradle.api.Task;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CachedExecutionBuilder<T> {
    private final Options options;
    private final Task targetTask;
    private final List<ICacheableJob<?, ?>> stages;
    private final CacheLogger logger;

    public CachedExecutionBuilder(Options options, Task targetTask, ICacheableJob<Void, T> initialJob) {
        this(options, targetTask, Lists.newArrayList((Iterator)ImmutableList.of(initialJob).iterator()));
    }

    private CachedExecutionBuilder(Options options, Task targetTask, List<ICacheableJob<?, ?>> stages) {
        this.options = options;
        this.targetTask = targetTask;
        this.stages = stages;
        this.logger = new CacheLogger(targetTask, options.logging().debug(), options.logging().cacheHits());
    }

    public <Y> CachedExecutionBuilder<Y> withStage(ICacheableJob<T, Y> job) {
        ArrayList newStages = new ArrayList(this.stages);
        newStages.add(job);
        return new CachedExecutionBuilder<T>(this.options, this.targetTask, newStages);
    }

    public void execute() throws IOException {
        if (!this.options.enabled()) {
            this.logger.debug("Caching is disabled, executing all stages.");
            this.executeAll(stage -> CacheStatus.alwaysUnlocked(), (stage, status) -> this.logger.onCacheMiss(stage));
            return;
        }
        TaskHasher hasher = new TaskHasher(this.targetTask, this.logger);
        HashCode taskHash = hasher.create();
        this.logger.debug("Task hash: %s".formatted(taskHash));
        this.executeAll(this.shouldExecuteCachedFor(this.targetTask, taskHash), this.afterExecution());
    }

    private Function<ICacheableJob<?, ?>, CacheStatus> shouldExecuteCachedFor(Task targetTask, HashCode taskHash) {
        return stage -> {
            ICache cache = this.createCache(taskHash, (ICacheableJob<?, ?>)stage);
            FileBasedLock lock = cache.createLock(this.logger);
            try {
                if (lock.hasPreviousFailure() || !cache.canRestore(stage.outputs())) {
                    this.logger.debug("Previous failure detected for stage or restore impossible: %s".formatted(stage));
                    return CacheStatus.runWithLock(lock, cache);
                }
                if (!cache.restoreTo(stage.outputs())) {
                    this.logger.onCacheEquals((ICacheableJob<?, ?>)stage);
                }
                targetTask.setDidWork(false);
                return CacheStatus.cachedWithLock(lock);
            }
            catch (Exception e) {
                throw new GradleException("Failed to restore cache for stage: %s".formatted(stage), (Throwable)e);
            }
        };
    }

    private AfterExecute afterExecution() {
        return (stage, status) -> {
            if (status.shouldExecute()) {
                this.logger.onCacheMiss(stage);
                status.cache().loadFrom(stage.outputs());
            } else {
                this.logger.onCacheHit(stage);
            }
        };
    }

    private ICache createCache(HashCode taskHash, ICacheableJob<?, ?> job) {
        JobHasher jobHasher = new JobHasher(taskHash, job);
        File cacheDir = new File(this.options.cache(), jobHasher.hash().toString());
        return new MultiEntryCache(cacheDir);
    }

    private Object executeStage(ICacheableJob job, Object input) throws Throwable {
        List<ICacheableJob.OutputEntry> intendedOutput = job.outputs();
        this.prepareWorkspace(intendedOutput);
        return job.execute(input);
    }

    private void prepareWorkspace(List<ICacheableJob.OutputEntry> output) throws IOException {
        for (ICacheableJob.OutputEntry file : output) {
            this.prepareWorkspace(file);
        }
    }

    private void prepareWorkspace(ICacheableJob.OutputEntry output) throws IOException {
        if (output.isDirectory()) {
            if (!output.output().exists() && !output.output().mkdirs()) {
                throw new RuntimeException("Failed to create directory: %s".formatted(output.output().getAbsolutePath()));
            }
            if (output.output().exists()) {
                FileUtils.cleanDirectory((File)output.output());
            }
        } else if (output.output().exists() && !output.output().delete()) {
            throw new RuntimeException("Failed to delete file: %s".formatted(output.output().getAbsolutePath()));
        }
    }

    private void executeAll(Function<ICacheableJob<?, ?>, CacheStatus> beforeExecute, AfterExecute afterExecute) {
        Object state = null;
        for (ICacheableJob<?, ?> stage : this.stages) {
            try {
                CacheStatus status = beforeExecute.apply(stage);
                try {
                    if (status.shouldExecute()) {
                        state = this.executeStage(stage, state);
                    }
                    afterExecute.accept(stage, status);
                    status.onSuccess();
                }
                finally {
                    if (status == null) continue;
                    status.close();
                }
            }
            catch (Throwable e) {
                throw new GradleException("Failed to execute stage: %s".formatted(stage), e);
            }
        }
    }

    public record Options(boolean enabled, File cache, LoggingOptions logging) {
    }

    public record LoggingOptions(boolean cacheHits, boolean debug) {
    }

    private static interface AfterExecute {
        public void accept(ICacheableJob<?, ?> var1, CacheStatus var2) throws Exception;
    }

    private record JobHasher(HashCode taskHash, ICacheableJob<?, ?> job, Hasher hasher) {
        public JobHasher(HashCode taskHash, ICacheableJob<?, ?> job) {
            this(taskHash, job, Hashing.sha256().newHasher());
        }

        public HashCode hash() {
            this.hasher.putHash(this.taskHash);
            this.hasher.putString(this.job.name());
            return this.hasher.hash();
        }
    }

    private record CacheStatus(@Nullable FileBasedLock lock, boolean shouldExecute, @Nullable ICache cache) implements AutoCloseable
    {
        @Nullable
        private final ICache cache;

        private static CacheStatus alwaysUnlocked() {
            return new CacheStatus(null, true, null);
        }

        public static CacheStatus runWithLock(FileBasedLock lock, ICache cache) {
            return new CacheStatus(lock, true, cache);
        }

        public static CacheStatus cachedWithLock(FileBasedLock lock) {
            return new CacheStatus(lock, false, null);
        }

        @NotNull
        public ICache cache() {
            if (this.cache == null) {
                throw new IllegalStateException("No cache is available.");
            }
            return this.cache;
        }

        @Override
        public void close() throws Exception {
            if (this.lock != null) {
                this.lock.close();
            }
        }

        public void onSuccess() {
            if (this.lock != null) {
                this.lock.updateAccessTime();
                this.lock.markAsSuccess();
            }
        }
    }
}

