/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.gradle.common.runtime.tasks;

import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import net.neoforged.gradle.dsl.common.runtime.tasks.NamedFile;
import net.neoforged.gradle.dsl.common.runtime.tasks.NamedFileRef;
import net.neoforged.gradle.dsl.common.runtime.tasks.NamedRegularFile;
import net.neoforged.gradle.dsl.common.runtime.tasks.RuntimeArguments;
import org.gradle.api.file.RegularFile;
import org.gradle.api.provider.Provider;
import org.jetbrains.annotations.Nullable;

public abstract class RuntimeArgumentsImpl
implements RuntimeArguments {
    @Nullable
    public Provider<String> get(String key) {
        return this.getFiles().map(files -> files.stream().filter(f -> f.getName().equals(key)).findFirst().orElse(null)).flatMap(NamedFileRef::getFile).map(File::getAbsolutePath).orElse(this.getSimple().getting((Object)key));
    }

    public Provider<String> getOrDefault(String key, Provider<String> defaultProvider) {
        Provider<String> getResult = this.get(key);
        if (getResult == null) {
            return defaultProvider;
        }
        return getResult.orElse(defaultProvider);
    }

    public Provider<Map<String, Provider<String>>> asMap() {
        Provider simpleProvider = this.getSimple().map(Map::keySet).map(keySet -> keySet.stream().collect(Collectors.toMap(key -> key, key -> this.getSimple().getting(key))));
        Provider filesProvider = this.getFiles().map(files -> files.stream().collect(Collectors.toMap(NamedFileRef::getName, namedFiles -> namedFiles.getFile().map(File::getAbsolutePath), (a, b) -> b, HashMap::new)));
        return simpleProvider.zip(filesProvider, (simple, files) -> ImmutableMap.builder().putAll(simple).putAll(files).build());
    }

    public void putFile(String input, Provider<File> fileProvider) {
        this.getFiles().add((Object)new NamedFile(input, fileProvider));
    }

    public void putRegularFile(String input, Provider<RegularFile> fileProvider) {
        this.getFiles().add((Object)new NamedRegularFile(input, fileProvider));
    }

    public void put(String input, Provider<String> stringProvider) {
        this.getSimple().put((Object)input, stringProvider);
    }
}

