/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.gradle.common.extensions.subsystems;

import groovy.transform.Internal;
import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import java.util.Locale;
import javax.inject.Inject;
import net.neoforged.gdi.ConfigurableDSLElement;
import net.neoforged.gradle.common.extensions.base.WithLocalProperties;
import net.neoforged.gradle.common.extensions.base.WithPropertyLookup;
import net.neoforged.gradle.common.extensions.subsystems.ConventionsExtension;
import net.neoforged.gradle.common.extensions.subsystems.IntegrationExtensions;
import net.neoforged.gradle.common.extensions.subsystems.ToolsExtension;
import net.neoforged.gradle.dsl.common.extensions.subsystems.Conventions;
import net.neoforged.gradle.dsl.common.extensions.subsystems.Decompiler;
import net.neoforged.gradle.dsl.common.extensions.subsystems.DecompilerLogLevel;
import net.neoforged.gradle.dsl.common.extensions.subsystems.DevLogin;
import net.neoforged.gradle.dsl.common.extensions.subsystems.Integration;
import net.neoforged.gradle.dsl.common.extensions.subsystems.Parchment;
import net.neoforged.gradle.dsl.common.extensions.subsystems.Recompiler;
import net.neoforged.gradle.dsl.common.extensions.subsystems.RecompilerType;
import net.neoforged.gradle.dsl.common.extensions.subsystems.RenderDoc;
import net.neoforged.gradle.dsl.common.extensions.subsystems.Subsystems;
import net.neoforged.gradle.dsl.common.extensions.subsystems.Tools;
import net.neoforged.gradle.dsl.common.extensions.subsystems.tools.RenderDocTools;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.gradle.api.artifacts.repositories.ArtifactRepository;
import org.gradle.api.artifacts.repositories.MavenArtifactRepository;
import org.gradle.api.file.Directory;
import org.gradle.api.provider.Provider;

public abstract class SubsystemsExtension
extends WithPropertyLookup
implements ConfigurableDSLElement<Subsystems>,
Subsystems {
    private final Conventions conventions;
    private final Parchment parchment;
    private final Tools tools;
    private final Integration integration;

    @Inject
    public SubsystemsExtension(Project project) {
        super(project);
        this.integration = (Integration)project.getObjects().newInstance(IntegrationExtensions.class, new Object[]{project});
        this.conventions = (Conventions)project.getObjects().newInstance(ConventionsExtension.class, new Object[]{project});
        this.parchment = (Parchment)project.getObjects().newInstance(ParchmentExtensions.class, new Object[]{project});
        this.tools = (Tools)project.getObjects().newInstance(ToolsExtension.class, new Object[]{project});
        this.configureDecompilerDefaults();
        this.configureRecompilerDefaults();
        this.configureParchmentDefaults();
        this.configureToolsDefaults();
        this.configureDevLoginDefaults();
        this.configureRenderDocDefaults();
    }

    private void configureRenderDocDefaults() {
        RenderDoc devLogin = this.getRenderDoc();
        devLogin.getConfigurationSuffix().convention(this.getStringProperty("renderDoc.configurationSuffix", "RenderDocLocalOnly"));
    }

    private void configureDevLoginDefaults() {
        DevLogin devLogin = this.getDevLogin();
        devLogin.getMainClass().convention(this.getStringProperty("devLogin.mainClass", "net.covers1624.devlogin.DevLogin"));
        devLogin.getConfigurationSuffix().convention(this.getStringProperty("devLogin.configurationSuffix", "DevLoginLocalOnly"));
    }

    private void configureToolsDefaults() {
        Tools tools = this.getTools();
        tools.getJST().convention(this.getStringProperty("tools.jst", "net.neoforged.jst:jst-cli-bundle:2.0.1"));
        tools.getDevLogin().convention(this.getStringProperty("tools.devLogin", "net.covers1624:DevLogin:0.1.0.4"));
        tools.getBinaryPatcher().convention(this.getStringProperty("tools.binaryPatcher", "net.neoforged.installertools:binarypatcher:2.1.7:fatjar"));
        tools.getAccessTransformer().convention(this.getStringProperty("tools.accessTransformer", "net.neoforged.accesstransformers:at-cli:11.0.2:fatjar"));
        tools.getAutoRenamingTool().convention(this.getStringProperty("tools.autoRenamingTool", "net.neoforged:AutoRenamingTool:2.0.4:all"));
        tools.getInstallerTools().convention(this.getStringProperty("tools.installerTools", "net.neoforged.installertools:installertools:4.0.6:fatjar"));
        tools.getJarSplitter().convention(this.getStringProperty("tools.jarSplitter", "net.neoforged.installertools:jarsplitter:2.1.7"));
        tools.getDecompiler().convention(this.getStringProperty("tools.decompiler", "org.vineflower:vineflower:1.10.1"));
        RenderDocTools renderDocTools = tools.getRenderDoc();
        renderDocTools.getRenderDocPath().convention(this.getDirectoryProperty("tools.renderDoc.path", (Provider<Directory>)this.getProject().getLayout().getBuildDirectory().dir("renderdoc")));
        renderDocTools.getRenderDocVersion().convention(this.getStringProperty("tools.renderDoc.version", "1.33"));
        renderDocTools.getRenderNurse().convention(this.getStringProperty("tools.renderDoc.renderNurse", "net.neoforged:render-nurse:0.0.14"));
    }

    private void configureDecompilerDefaults() {
        Decompiler decompiler = this.getDecompiler();
        decompiler.getMaxMemory().convention(this.getStringProperty("decompiler.maxMemory", "4g"));
        decompiler.getMaxThreads().convention(this.getStringProperty("decompiler.maxThreads", "0").map(Integer::parseUnsignedInt));
        decompiler.getLogLevel().convention(this.getStringProperty("decompiler.logLevel", "ERROR").map(s -> {
            try {
                return DecompilerLogLevel.valueOf((String)s.toUpperCase(Locale.ROOT));
            }
            catch (Exception e) {
                throw new GradleException("Unknown DecompilerLogLevel: " + s + ". Available options: " + Arrays.toString(DecompilerLogLevel.values()));
            }
        }));
        decompiler.getJvmArgs().convention(this.getSpaceSeparatedListProperty("decompiler.jvmArgs", Collections.emptyList()));
        decompiler.getIsDisabled().convention(this.getBooleanProperty("decompiler.enabled").map(prop -> prop == false).orElse(this.project.getProviders().environmentVariable("CI").map(ciMode -> ciMode.toLowerCase(Locale.ROOT).trim().equals("true") || ciMode.toLowerCase(Locale.ROOT).trim().equals("1"))).orElse((Object)false));
    }

    private void configureRecompilerDefaults() {
        Recompiler recompiler = this.getRecompiler();
        recompiler.getArgs().convention(this.getSpaceSeparatedListProperty("recompiler.args", Collections.emptyList()));
        recompiler.getJvmArgs().convention(this.getSpaceSeparatedListProperty("recompiler.jvmArgs", Collections.emptyList()));
        recompiler.getMaxMemory().convention(this.getStringProperty("recompiler.maxMemory", "1g"));
        recompiler.getShouldFork().convention(this.getBooleanProperty("recompiler.shouldFork", true, false));
        recompiler.getType().convention(this.getStringProperty("recompiler.type", RecompilerType.getDefaultCompilerType().name()).map(RecompilerType::valueOf));
    }

    private void configureParchmentDefaults() {
        Parchment parchment = this.getParchment();
        this.project.afterEvaluate(p -> {
            MavenArtifactRepository repo = p.getRepositories().maven(m -> {
                m.setName("Parchment Data");
                m.setUrl(URI.create("https://maven.parchmentmc.org/"));
                m.mavenContent(mavenContent -> mavenContent.includeGroup("org.parchmentmc.data"));
            });
            p.getRepositories().remove((Object)repo);
            p.getRepositories().addFirst((ArtifactRepository)repo);
        });
    }

    public Integration getIntegration() {
        return this.integration;
    }

    public Conventions getConventions() {
        return this.conventions;
    }

    public Parchment getParchment() {
        return this.parchment;
    }

    public Tools getTools() {
        return this.tools;
    }

    public static abstract class ParchmentExtensions
    extends WithLocalProperties
    implements Parchment {
        @Inject
        public ParchmentExtensions(Project project) {
            super(project, "parchment");
            this.getParchmentArtifact().convention(this.getStringLocalProperty("parchmentArtifact", null));
            this.getConflictPrefix().convention((Object)"p_");
            this.getMinecraftVersion().convention(this.getStringLocalProperty("minecraftVersion", null));
            this.getMappingsVersion().convention(this.getStringLocalProperty("mappingsVersion", null));
            this.getAddRepository().convention(this.getBooleanLocalProperty("addRepository", true));
        }

        @Internal
        public Provider<String> getSelectedParchmentArtifact(String artifactMinecraftVersion) {
            return this.getParchmentArtifact().orElse(this.getMinecraftVersion().orElse((Object)artifactMinecraftVersion).zip((Provider)this.getMappingsVersion(), (minecraftVersion, mappingVersion) -> "org.parchmentmc.data:parchment-" + minecraftVersion + ":" + mappingVersion + "@zip"));
        }
    }
}

