/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.gradle.common.runtime.tasks;

import com.google.common.collect.Maps;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import javax.inject.Inject;
import net.neoforged.gradle.common.runtime.tasks.action.DownloadFileAction;
import net.neoforged.gradle.common.services.caching.CachedExecutionService;
import net.neoforged.gradle.common.services.caching.jobs.ICacheableJob;
import net.neoforged.gradle.common.util.FileCacheUtils;
import net.neoforged.gradle.common.util.SerializationUtils;
import net.neoforged.gradle.common.util.VersionJson;
import net.neoforged.gradle.dsl.common.tasks.WithWorkspace;
import net.neoforged.gradle.util.TransformerUtils;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.file.Directory;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.services.ServiceReference;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;
import org.gradle.workers.WorkQueue;
import org.gradle.workers.WorkerExecutor;
import org.jetbrains.annotations.NotNull;

@CacheableTask
public abstract class DownloadAssets
extends DefaultTask
implements WithWorkspace {
    private final Provider<Directory> assetsCache = DownloadAssets.getAssetsDirectory(this.getProject());
    private final Provider<Directory> assetsObjects = this.assetsCache.map(directory -> directory.dir("objects"));

    public DownloadAssets() {
        this.getAssetIndex().convention((Object)"asset-index");
        this.getAssetIndexFileName().convention(this.getAssetIndex().map(index -> index + ".json"));
        this.getAssetIndexTargetFile().convention(this.getRegularFileInAssetsDirectory((Provider<String>)this.getAssetIndexFileName().map(name -> "indexes/" + name)));
        this.getAssetIndexFile().convention((Provider)this.getAssetIndexTargetFile());
        this.getVersionJson().convention(this.getVersionJsonFile().map(TransformerUtils.guard(file -> VersionJson.get(file.getAsFile()))));
        this.getAssetRepository().convention((Object)"https://resources.download.minecraft.net/");
        this.getIsOffline().convention((Object)this.getProject().getGradle().getStartParameter().isOffline());
    }

    @NotNull
    public static Provider<Directory> getAssetsDirectory(Project project) {
        return FileCacheUtils.getAssetsCacheDirectory(project).map(TransformerUtils.ensureExists());
    }

    @Deprecated
    @NotNull
    public static Provider<Directory> getAssetsDirectory(Project project, Provider<VersionJson> versionJsonProvider) {
        return DownloadAssets.getAssetsDirectory(project);
    }

    protected Provider<File> getFileInAssetsDirectory(String fileName) {
        return this.assetsObjects.map(directory -> directory.file(fileName).getAsFile());
    }

    protected Provider<RegularFile> getRegularFileInAssetsDirectory(Provider<String> fileName) {
        return this.assetsCache.flatMap(directory -> fileName.map(arg_0 -> ((Directory)directory).file(arg_0)));
    }

    @ServiceReference(value="CachedExecutionService")
    public abstract Property<CachedExecutionService> getCache();

    @TaskAction
    public void run() throws IOException {
        ((CachedExecutionService)this.getCache().get()).cached((Task)this, ICacheableJob.Initial.file("assetIndex", this::downloadAssetIndex, this.getAssetIndexFile())).withStage(ICacheableJob.Initial.directory("assets", this.assetsObjects, this::downloadAssets)).execute();
    }

    private Void downloadAssetIndex() {
        VersionJson json = (VersionJson)this.getVersionJson().get();
        VersionJson.AssetIndex assetIndexData = json.getAssetIndex();
        WorkQueue executor = this.getWorkerExecutor().noIsolation();
        executor.submit(DownloadFileAction.class, params -> {
            params.getUrl().set((Object)assetIndexData.getUrl().toString());
            params.getShouldValidateHash().set((Object)true);
            params.getSha1().set((Object)assetIndexData.getSha1());
            params.getOutputFile().set((Provider)this.getAssetIndexFile());
            params.getIsOffline().set(this.getIsOffline());
        });
        executor.await();
        return null;
    }

    private Void downloadAssets() {
        AssetIndex assetIndex = SerializationUtils.fromJson((File)this.getAssetIndexFile().getAsFile().get(), AssetIndex.class);
        WorkQueue executor = this.getWorkerExecutor().noIsolation();
        assetIndex.getObjects().values().stream().distinct().forEach(asset -> {
            Provider<File> assetFile = this.getFileInAssetsDirectory(asset.getPath());
            Provider assetUrl = this.getAssetRepository().map(repo -> repo.endsWith("/") ? repo : repo + "/").map(TransformerUtils.guard(repository -> repository + asset.getPath()));
            executor.submit(DownloadFileAction.class, params -> {
                params.getIsOffline().set(this.getIsOffline());
                params.getShouldValidateHash().set((Object)true);
                params.getOutputFile().fileProvider(assetFile);
                params.getUrl().set(assetUrl);
                params.getSha1().set((Object)asset.getHash());
            });
        });
        executor.await();
        return null;
    }

    @Inject
    protected abstract WorkerExecutor getWorkerExecutor();

    @InputFile
    @Optional
    @PathSensitive(value=PathSensitivity.NONE)
    public abstract RegularFileProperty getVersionJsonFile();

    @Input
    public abstract Property<VersionJson> getVersionJson();

    @Input
    public abstract Property<String> getAssetIndex();

    @Input
    public abstract Property<String> getAssetIndexFileName();

    @Input
    public abstract Property<String> getAssetRepository();

    @Internal
    public abstract RegularFileProperty getAssetIndexTargetFile();

    @OutputFile
    public abstract RegularFileProperty getAssetIndexFile();

    @Input
    public abstract Property<Boolean> getIsOffline();

    private static class AssetIndex {
        private Map<String, Asset> objects = Maps.newHashMap();

        private AssetIndex() {
        }

        public Map<String, Asset> getObjects() {
            return this.objects;
        }

        public void setObjects(Map<String, Asset> objects) {
            this.objects = objects;
        }
    }

    private static class Asset {
        private String hash;

        private Asset() {
        }

        public String getHash() {
            return this.hash;
        }

        public void setHash(String hash) {
            this.hash = hash;
        }

        public String getPath() {
            return this.hash.substring(0, 2) + "/" + this.hash;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Asset)) {
                return false;
            }
            Asset asset = (Asset)o;
            return this.getHash().equals(asset.getHash());
        }

        public int hashCode() {
            return this.getHash().hashCode();
        }
    }
}

