/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.gradle.common.runtime.extensions;

import com.google.common.collect.Maps;
import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.neoforged.gradle.common.runtime.definition.CommonRuntimeDefinition;
import net.neoforged.gradle.common.runtime.extensions.RuntimesExtension;
import net.neoforged.gradle.common.runtime.specification.CommonRuntimeSpecification;
import net.neoforged.gradle.common.runtime.tasks.DownloadAssets;
import net.neoforged.gradle.common.runtime.tasks.ExtractNatives;
import net.neoforged.gradle.common.runtime.tasks.InProcessSourceJarRecompiler;
import net.neoforged.gradle.common.runtime.tasks.RecompileSourceJar;
import net.neoforged.gradle.common.util.ConfigurationUtils;
import net.neoforged.gradle.common.util.VersionJson;
import net.neoforged.gradle.dsl.common.extensions.MinecraftArtifactCache;
import net.neoforged.gradle.dsl.common.extensions.repository.Repository;
import net.neoforged.gradle.dsl.common.extensions.subsystems.Recompiler;
import net.neoforged.gradle.dsl.common.extensions.subsystems.Subsystems;
import net.neoforged.gradle.dsl.common.runtime.definition.Definition;
import net.neoforged.gradle.dsl.common.runtime.extensions.CommonRuntimes;
import net.neoforged.gradle.dsl.common.runtime.spec.Specification;
import net.neoforged.gradle.dsl.common.runtime.tasks.Runtime;
import net.neoforged.gradle.dsl.common.runtime.tasks.tree.TaskCustomizer;
import net.neoforged.gradle.dsl.common.tasks.WithOutput;
import net.neoforged.gradle.dsl.common.tasks.specifications.OutputSpecification;
import net.neoforged.gradle.dsl.common.util.CacheableMinecraftVersion;
import net.neoforged.gradle.dsl.common.util.CommonRuntimeUtils;
import net.neoforged.gradle.dsl.common.util.GameArtifact;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.dsl.DependencyHandler;
import org.gradle.api.file.ArchiveOperations;
import org.gradle.api.file.FileCollection;
import org.gradle.api.plugins.JavaPluginExtension;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.api.tasks.compile.ForkOptions;
import org.gradle.process.CommandLineArgumentProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CommonRuntimeExtension<S extends CommonRuntimeSpecification, B extends CommonRuntimeSpecification.Builder<S, B>, D extends CommonRuntimeDefinition<S>>
implements CommonRuntimes<S, B, D> {
    protected final Map<String, D> definitions = Maps.newHashMap();
    protected final Map<String, Dependency> dependencies = Maps.newHashMap();
    private final Project project;

    protected CommonRuntimeExtension(Project project) {
        this.project = project;
        ((RuntimesExtension)this.project.getExtensions().getByType(RuntimesExtension.class)).add(this);
    }

    public static void configureCommonRuntimeTaskParameters(Runtime runtimeTask, Map<String, String> symbolicDataSources, String step, Specification spec, File runtimeDirectory) {
        runtimeTask.getSymbolicDataSources().set(symbolicDataSources);
        runtimeTask.getStepName().set((Object)step);
        runtimeTask.getDistribution().set((Object)spec.getDistribution());
        runtimeTask.getMinecraftVersion().set((Object)CacheableMinecraftVersion.from((String)spec.getMinecraftVersion(), (Project)spec.getProject()).getFull());
        runtimeTask.getRuntimeDirectory().set(runtimeDirectory);
        runtimeTask.getRuntimeName().set((Object)spec.getVersionedName());
        runtimeTask.getJavaVersion().convention((Provider)((JavaPluginExtension)spec.getProject().getExtensions().getByType(JavaPluginExtension.class)).getToolchain().getLanguageVersion());
        for (TaskCustomizer taskCustomizer : spec.getTaskCustomizers().get((Object)step)) {
            taskCustomizer.apply(runtimeTask);
        }
    }

    public static void configureCommonRuntimeTaskParameters(Runtime runtime, CommonRuntimeDefinition<?> runtimeDefinition, File workingDirectory) {
        CommonRuntimeExtension.configureCommonRuntimeTaskParameters(runtime, (CommonRuntimeSpecification)runtimeDefinition.getSpecification(), workingDirectory);
        runtime.getJavaVersion().set(runtimeDefinition.getRequiredJavaVersion());
    }

    public static void configureCommonRuntimeTaskParameters(Runtime runtime, String stepName, CommonRuntimeSpecification specification, File workingDirectory) {
        CommonRuntimeExtension.configureCommonRuntimeTaskParameters(runtime, Collections.emptyMap(), stepName, specification, workingDirectory);
    }

    private static void configureCommonRuntimeTaskParameters(Runtime runtime, CommonRuntimeSpecification specification, File workingDirectory) {
        CommonRuntimeExtension.configureCommonRuntimeTaskParameters(runtime, runtime.getName(), specification, workingDirectory);
    }

    public static Map<GameArtifact, TaskProvider<? extends WithOutput>> buildDefaultArtifactProviderTasks(Specification spec) {
        MinecraftArtifactCache artifactCache = (MinecraftArtifactCache)spec.getProject().getExtensions().getByType(MinecraftArtifactCache.class);
        return artifactCache.cacheGameVersionTasks(spec.getProject(), spec.getMinecraftVersion(), spec.getDistribution());
    }

    public static Configuration extractVersionJsonLibraries(@NotNull Project project, String minecraftVersion, CommonRuntimeDefinition<?> definition) {
        return ConfigurationUtils.temporaryConfiguration(project, "%sDependencies".formatted(minecraftVersion), (Action<Configuration>)((Action)files -> files.getDependencies().addAllLater(definition.getVersionJson().map(VersionJson::getLibraries).map(libraries -> libraries.stream().filter(VersionJson.RuledObject::isAllowed).toList()).map(libraries -> libraries.stream().map(VersionJson.Library::getName).map(arg_0 -> ((DependencyHandler)project.getDependencies()).create(arg_0)).toList()))));
    }

    @NotNull
    protected static TaskProvider<? extends Runtime> createRecompileTask(CommonRuntimeDefinition<?> definition, TaskProvider<? extends WithOutput> recompileInput, FileCollection recompileDependencies, Consumer<TaskProvider<? extends Runtime>> configure) {
        return CommonRuntimeExtension.createGradleRecompileTask(definition, recompileInput, recompileDependencies, configure);
    }

    @NotNull
    private static TaskProvider<InProcessSourceJarRecompiler> createNativeRecompileTask(CommonRuntimeDefinition<?> definition, TaskProvider<? extends WithOutput> recompileInput, FileCollection recompileDependencies, Consumer<TaskProvider<? extends Runtime>> configure) {
        Specification spec = definition.getSpecification();
        TaskProvider compiler = spec.getProject().getTasks().register(CommonRuntimeUtils.buildTaskName((Specification)spec, (String)"recompile"), InProcessSourceJarRecompiler.class, task -> {
            task.getSourceToCompile().set(recompileInput.flatMap(OutputSpecification::getOutput));
            task.getClasspath().from(new Object[]{recompileDependencies});
            task.getAdditionalSources().from(new Object[]{definition.getAdditionalCompileSources()});
            Object[] objectArray = new Object[1];
            objectArray[0] = recompileInput.flatMap(OutputSpecification::getOutput).map(arg_0 -> ((ArchiveOperations)task.getArchiveOperations()).zipTree(arg_0)).map(zipTree -> zipTree.matching(sp -> sp.exclude(new String[]{"**/*.java"})));
            task.getResources().from(objectArray);
        });
        configure.accept((TaskProvider<? extends Runtime>)compiler);
        return compiler;
    }

    @NotNull
    private static TaskProvider<RecompileSourceJar> createGradleRecompileTask(CommonRuntimeDefinition<?> definition, TaskProvider<? extends WithOutput> recompileInput, FileCollection recompileDependencies, Consumer<TaskProvider<? extends Runtime>> configure) {
        Provider recompileSourceFileTree = recompileInput.flatMap(OutputSpecification::getOutputAsTree);
        Specification spec = definition.getSpecification();
        TaskProvider recompileSourceJar = spec.getProject().getTasks().register(CommonRuntimeUtils.buildTaskName((Specification)spec, (String)"recompile"), RecompileSourceJar.class, arg_0 -> CommonRuntimeExtension.lambda$createGradleRecompileTask$8(recompileSourceFileTree, definition, (CommonRuntimeSpecification)spec, recompileInput, recompileDependencies, arg_0));
        configure.accept((TaskProvider<? extends Runtime>)recompileSourceJar);
        return recompileSourceJar;
    }

    public Project getProject() {
        return this.project;
    }

    public final Map<String, D> getDefinitions() {
        return this.definitions;
    }

    @Deprecated
    public final Provider<Map<String, D>> getRuntimes() {
        return this.project.provider(this::getDefinitions);
    }

    @NotNull
    public final D maybeCreate(Action<B> configurator) {
        S spec = this.createSpec(configurator);
        if (this.definitions.containsKey(((CommonRuntimeSpecification)spec).getIdentifier())) {
            return (D)((CommonRuntimeDefinition)this.definitions.get(((CommonRuntimeSpecification)spec).getIdentifier()));
        }
        return (D)this.create((Action)configurator);
    }

    public D maybeCreateFor(Dependency dependency, Action<B> configurator) {
        Definition result = this.maybeCreate((Action)configurator);
        this.dependencies.put(result.getSpecification().getIdentifier(), dependency);
        return (D)result;
    }

    @NotNull
    public final D create(Action<B> configurator) {
        S spec = this.createSpec(configurator);
        if (((RuntimesExtension)this.project.getExtensions().getByType(RuntimesExtension.class)).definitionExists(((CommonRuntimeSpecification)spec).getIdentifier())) {
            throw new IllegalArgumentException(String.format("Runtime with identifier '%s' already exists", ((CommonRuntimeSpecification)spec).getIdentifier()));
        }
        D runtime = this.doCreate(spec);
        this.definitions.put(((CommonRuntimeSpecification)spec).getIdentifier(), runtime);
        this.afterRegistration(runtime);
        return runtime;
    }

    protected void afterRegistration(D runtime) {
    }

    public D create(Dependency dependency, Action<B> configurator) {
        Definition result = this.create((Action)configurator);
        this.dependencies.put(result.getSpecification().getIdentifier(), dependency);
        return (D)result;
    }

    @NotNull
    protected abstract D doCreate(S var1);

    @NotNull
    private S createSpec(Action<B> configurator) {
        B builder = this.createBuilder();
        configurator.execute(builder);
        return ((CommonRuntimeSpecification.Builder)builder).build();
    }

    @NotNull
    public final D getByName(String name) {
        return (D)this.definitions.computeIfAbsent(name, n -> {
            throw new RuntimeException(String.format("Failed to find runtime with name: %s", n));
        });
    }

    @Nullable
    public final D findByNameOrIdentifier(String name) {
        CommonRuntimeDefinition byIdentifier = (CommonRuntimeDefinition)this.definitions.get(name);
        if (byIdentifier != null) {
            return (D)byIdentifier;
        }
        return (D)((CommonRuntimeDefinition)this.definitions.values().stream().filter(r -> r.getSpecification().getVersionedName().equals(name)).findAny().orElse(null));
    }

    protected abstract B createBuilder();

    @NotNull
    public Set<D> findIn(Configuration configuration) {
        Repository repository = (Repository)this.project.getExtensions().getByType(Repository.class);
        Set directDependency = configuration.getAllDependencies().stream().flatMap(dep -> this.getDefinitions().values().stream().filter(runtime -> this.dependencies.containsKey(runtime.getSpecification().getIdentifier())).filter(runtime -> repository.getEntries().stream().anyMatch(entry -> entry.getOriginal().equals(this.dependencies.get(runtime.getSpecification().getIdentifier()))))).collect(Collectors.toSet());
        if (!directDependency.isEmpty()) {
            return directDependency;
        }
        return this.project.getConfigurations().stream().filter(config -> config.getHierarchy().contains(configuration)).flatMap(config -> config.getAllDependencies().stream()).flatMap(dep -> this.getDefinitions().values().stream().filter(runtime -> this.dependencies.containsKey(runtime.getSpecification().getIdentifier())).filter(runtime -> repository.getEntries().stream().anyMatch(entry -> entry.getOriginal().equals(this.dependencies.get(runtime.getSpecification().getIdentifier()))))).collect(Collectors.toSet());
    }

    protected final TaskProvider<DownloadAssets> createDownloadAssetsTasks(CommonRuntimeSpecification specification, Provider<VersionJson> versionJson) {
        return specification.getProject().getTasks().register(CommonRuntimeUtils.buildTaskName((Specification)specification, (String)"downloadAssets"), DownloadAssets.class, task -> task.getVersionJson().set(versionJson));
    }

    protected final TaskProvider<ExtractNatives> createExtractNativesTasks(CommonRuntimeSpecification specification, Map<String, String> symbolicDataSources, File runtimeDirectory, Provider<VersionJson> versionJson) {
        return specification.getProject().getTasks().register(CommonRuntimeUtils.buildTaskName((Specification)specification, (String)"extractNatives"), ExtractNatives.class, task -> {
            task.getVersionJson().set(versionJson);
            CommonRuntimeExtension.configureCommonRuntimeTaskParameters(task, symbolicDataSources, "extractNatives", specification, runtimeDirectory);
            task.getOutputDirectory().set(task.getStepsDirectory().map(dir -> dir.dir("extractNatives")));
        });
    }

    protected final TaskProvider<ExtractNatives> createExtractNativesTasks(CommonRuntimeSpecification specification, File runtimeDirectory, Provider<VersionJson> versionJson) {
        return this.createExtractNativesTasks(specification, Collections.emptyMap(), runtimeDirectory, versionJson);
    }

    private static /* synthetic */ void lambda$createGradleRecompileTask$8(Provider recompileSourceFileTree, CommonRuntimeDefinition definition, CommonRuntimeSpecification spec, TaskProvider recompileInput, FileCollection recompileDependencies, RecompileSourceJar task) {
        task.getCompileFileRoot().from(new Object[]{recompileSourceFileTree});
        task.getAdditionalInputFileRoot().from(new Object[]{definition.getAdditionalCompileSources()});
        task.getAdditionalInputFileRoot().from(new Object[]{spec.getProject().file((Object)recompileInput.flatMap(OutputSpecification::getOutput))});
        task.setClasspath(recompileDependencies);
        task.getStepName().set((Object)"recompile");
        Recompiler settings = ((Subsystems)spec.getProject().getExtensions().getByType(Subsystems.class)).getRecompiler();
        String maxMemory = (String)settings.getMaxMemory().get();
        task.getOptions().setFork(((Boolean)settings.getShouldFork().get()).booleanValue());
        ForkOptions forkOptions = task.getOptions().getForkOptions();
        forkOptions.setMemoryMaximumSize(maxMemory);
        forkOptions.setJvmArgs((List)settings.getJvmArgs().get());
        task.getOptions().getCompilerArgumentProviders().add(new CustomCompilerArgsProvider((Provider<List<String>>)settings.getArgs()));
        task.getResources().from(new Object[]{recompileInput.flatMap(OutputSpecification::getOutputAsTree).map(zipTree -> zipTree.matching(sp -> sp.exclude(new String[]{"**/*.java"})))});
    }

    public record CustomCompilerArgsProvider(Provider<List<String>> args) implements CommandLineArgumentProvider
    {
        public Iterable<String> asArguments() {
            return (Iterable)this.args.get();
        }
    }
}

