/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.gradle.common.services.caching.locking;

import java.io.File;
import net.neoforged.gradle.common.services.caching.locking.HealthFileUsingFileBasedLock;
import net.neoforged.gradle.common.services.caching.locking.PIDBasedFileLock;
import net.neoforged.gradle.common.services.caching.logging.CacheLogger;

public final class IOControlledFileBasedLock
extends HealthFileUsingFileBasedLock {
    public static final String HEALTHY_FILE_NAME = "healthy";
    private final File lockFile;
    private final CacheLogger logger;
    private final PIDBasedFileLock pidBasedFileLock;

    public IOControlledFileBasedLock(File lockFile, CacheLogger logger) {
        super(new File(lockFile.getParentFile(), HEALTHY_FILE_NAME));
        this.lockFile = lockFile;
        this.logger = logger;
        this.pidBasedFileLock = new PIDBasedFileLock(lockFile, logger);
    }

    @Override
    public void updateAccessTime() {
        if (!this.lockFile.setLastModified(System.currentTimeMillis())) {
            throw new RuntimeException("Failed to update access time for lock file: %s".formatted(this.lockFile.getAbsolutePath()));
        }
        this.logger.debug("Updated access time for lock file: %s".formatted(this.lockFile.getAbsolutePath()));
    }

    @Override
    public void close() throws Exception {
        super.close();
        this.pidBasedFileLock.close();
        this.logger.debug("Lock file closed: %s".formatted(this.lockFile.getAbsolutePath()));
    }
}

