/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.gradle.common.runtime.tasks;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import net.neoforged.gradle.common.extensions.problems.IProblemReporter;
import net.neoforged.gradle.common.extensions.problems.NeoGradleProblemSpec;
import net.neoforged.gradle.common.runtime.tasks.DefaultExecute;
import net.neoforged.gradle.dsl.common.tasks.Execute;
import org.gradle.api.Action;
import org.gradle.api.GradleException;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Internal;

@CacheableTask
public abstract class DecompilerExecute
extends DefaultExecute {
    private final OOMDetector detector = new OOMDetector();

    public OutputStream createErrorOutputStream() {
        return new Execute.BifurcatingOutputStream(new OutputStream[]{super.createErrorOutputStream(), new OOMDetectorStream(this.detector)});
    }

    @Internal
    public OOMDetector getDetector() {
        return this.detector;
    }

    public void doExecute() throws Exception {
        try {
            super.doExecute();
        }
        catch (Exception ex) {
            this.detectError(false);
            throw ex;
        }
        this.detectError(true);
    }

    private void detectError(boolean throwError) {
        if (this.getDetector().failed()) {
            ((IProblemReporter)this.getProject().getExtensions().getByType(IProblemReporter.class)).reporting((Action<NeoGradleProblemSpec>)((Action)problem -> problem.contextualLabel("decompiler").id("decompiler", "memory").details("The Decompiler could not successfully decompile Minecraft because it ran out of memory. Modify your runtime configuration and the decompiler subsystems configuration, and try again.").solution("Either increase the memory allowance for the decompiler, or reduce the concurrency on the decompiler to reduce memory consumption.").section("common-decompiler-settings")), this.getLogger());
            if (throwError) {
                throw new GradleException("The decompiler failed to run. It ran out of memory.");
            }
        }
    }

    public static final class OOMDetector {
        private final StringBuilder resultBuilder = new StringBuilder();

        private OOMDetector() {
        }

        private void addLog(String log) {
            this.resultBuilder.append(log);
        }

        public boolean failed() {
            return this.resultBuilder.toString().contains("java.lang.OutOfMemoryError");
        }
    }

    public static final class OOMDetectorStream
    extends OutputStream {
        private final OOMDetector detector;
        private final ByteArrayOutputStream collectionDelegate = new ByteArrayOutputStream();

        public OOMDetectorStream(OOMDetector detector) {
            this.detector = detector;
        }

        @Override
        public void write(int b) throws IOException {
            this.collectionDelegate.write(b);
        }

        @Override
        public void flush() throws IOException {
            super.flush();
            this.collectionDelegate.flush();
        }

        @Override
        public void close() throws IOException {
            super.close();
            this.collectionDelegate.close();
            this.detector.addLog(this.collectionDelegate.toString());
        }
    }
}

