/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.gradle.common.extensions.base;

import java.util.List;
import net.neoforged.gradle.common.extensions.base.WithEnabledProperty;
import net.neoforged.gradle.common.extensions.base.WithPropertyLookup;
import org.gradle.api.Project;
import org.gradle.api.file.Directory;
import org.gradle.api.provider.Provider;

public class WithLocalProperties
extends WithPropertyLookup {
    protected final String prefix;

    public WithLocalProperties(Project project, String prefix) {
        super(project);
        this.prefix = prefix;
    }

    public WithLocalProperties(WithEnabledProperty parent, String prefix) {
        super(parent.project);
        this.prefix = String.format("%s.%s", parent.prefix, prefix);
    }

    protected Provider<String> getStringLocalProperty(String propertyName, String defaultValue) {
        return super.getStringProperty(String.format("%s.%s", this.prefix, propertyName), defaultValue);
    }

    protected Provider<Directory> getDirectoryLocalProperty(String propertyName, Provider<Directory> defaultValue) {
        return super.getDirectoryProperty(String.format("%s.%s", this.prefix, propertyName), defaultValue);
    }

    protected Provider<Boolean> getBooleanLocalProperty(String propertyName, boolean defaultValue) {
        return super.getBooleanProperty(String.format("%s.%s", this.prefix, propertyName), defaultValue, false);
    }

    protected Provider<List<String>> getSpaceSeparatedListLocalProperty(String propertyName, List<String> defaultValue) {
        return super.getSpaceSeparatedListProperty(String.format("%s.%s", this.prefix, propertyName), defaultValue);
    }
}

