/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.gradle.common.services.caching;

import java.io.File;
import java.io.IOException;
import net.neoforged.gradle.common.services.caching.CachedExecutionBuilder;
import net.neoforged.gradle.common.services.caching.jobs.ICacheableJob;
import org.apache.commons.io.FileUtils;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.services.BuildService;
import org.gradle.api.services.BuildServiceParameters;

public abstract class CachedExecutionService
implements BuildService<Parameters> {
    public static final String NAME = "CachedExecutionService";
    public static final String DIRECTORY_NAME = "ng_execute";
    public static final String CACHING_PROPERTY_PREFIX = "net.neoforged.gradle.caching.";
    public static final String CACHE_DIRECTORY_PROPERTY = "net.neoforged.gradle.caching.cacheDirectory";
    public static final String LOG_CACHE_HITS_PROPERTY = "net.neoforged.gradle.caching.logCacheHits";
    public static final String MAX_CACHE_SIZE_PROPERTY = "net.neoforged.gradle.caching.maxCacheSize";
    public static final String DEBUG_CACHE_PROPERTY = "net.neoforged.gradle.caching.debug";
    public static final String IS_ENABLED_PROPERTY = "net.neoforged.gradle.caching.enabled";

    public static void register(Project project) {
        project.getGradle().getSharedServices().registerIfAbsent(NAME, CachedExecutionService.class, spec -> {
            ((Parameters)spec.getParameters()).getCacheDirectory().fileProvider(project.getProviders().gradleProperty(CACHE_DIRECTORY_PROPERTY).map(File::new).orElse((Object)new File(new File(project.getGradle().getGradleUserHomeDir(), "caches"), DIRECTORY_NAME)));
            ((Parameters)spec.getParameters()).getLogCacheHits().set(project.getProviders().gradleProperty(LOG_CACHE_HITS_PROPERTY).map(Boolean::parseBoolean).orElse((Object)false));
            ((Parameters)spec.getParameters()).getMaxCacheSize().set(project.getProviders().gradleProperty(MAX_CACHE_SIZE_PROPERTY).map(Integer::parseInt).orElse((Object)100));
            ((Parameters)spec.getParameters()).getDebugCache().set(project.getProviders().gradleProperty(DEBUG_CACHE_PROPERTY).map(Boolean::parseBoolean).orElse((Object)false));
            ((Parameters)spec.getParameters()).getIsEnabled().set(project.getProviders().gradleProperty(IS_ENABLED_PROPERTY).map(Boolean::parseBoolean).orElse((Object)true));
        });
    }

    public void clean() throws IOException {
        FileUtils.cleanDirectory((File)((Directory)((Parameters)this.getParameters()).getCacheDirectory().get()).getAsFile());
    }

    public <T> CachedExecutionBuilder<T> cached(Task task, ICacheableJob<Void, T> initial) {
        return new CachedExecutionBuilder<T>(new CachedExecutionBuilder.Options((Boolean)((Parameters)this.getParameters()).getIsEnabled().get(), ((Directory)((Parameters)this.getParameters()).getCacheDirectory().get()).getAsFile(), new CachedExecutionBuilder.LoggingOptions((Boolean)((Parameters)this.getParameters()).getLogCacheHits().get(), (Boolean)((Parameters)this.getParameters()).getDebugCache().get())), task, initial);
    }

    public static interface Parameters
    extends BuildServiceParameters {
        public DirectoryProperty getCacheDirectory();

        public Property<Boolean> getLogCacheHits();

        public Property<Integer> getMaxCacheSize();

        public Property<Boolean> getDebugCache();

        public Property<Boolean> getIsEnabled();
    }
}

