/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.gradle.common.runtime.definition;

import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import java.io.File;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Consumer;
import net.neoforged.gradle.common.runs.run.RunImpl;
import net.neoforged.gradle.common.runtime.specification.CommonRuntimeSpecification;
import net.neoforged.gradle.common.runtime.tasks.DownloadAssets;
import net.neoforged.gradle.common.runtime.tasks.ExtractNatives;
import net.neoforged.gradle.common.tasks.ArtifactFromOutput;
import net.neoforged.gradle.common.util.VersionJson;
import net.neoforged.gradle.common.util.run.RunsUtil;
import net.neoforged.gradle.dsl.common.runtime.definition.Definition;
import net.neoforged.gradle.dsl.common.runtime.tasks.Runtime;
import net.neoforged.gradle.dsl.common.tasks.WithOutput;
import net.neoforged.gradle.dsl.common.tasks.specifications.InputFileSpecification;
import net.neoforged.gradle.dsl.common.tasks.specifications.OutputSpecification;
import net.neoforged.gradle.dsl.common.util.CommonRuntimeUtils;
import net.neoforged.gradle.dsl.common.util.GameArtifact;
import net.neoforged.gradle.util.TransformerUtils;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.Directory;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.RegularFile;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.MapProperty;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.jvm.toolchain.JavaLanguageVersion;
import org.jetbrains.annotations.NotNull;

public abstract class CommonRuntimeDefinition<S extends CommonRuntimeSpecification>
implements Definition<S> {
    @NotNull
    private final S specification;
    @NotNull
    private final LinkedHashMap<String, TaskProvider<? extends WithOutput>> taskOutputs;
    @NotNull
    private final TaskProvider<? extends ArtifactFromOutput> sourceJarTask;
    @NotNull
    private final TaskProvider<? extends ArtifactFromOutput> rawJarTask;
    @NotNull
    private final Map<GameArtifact, TaskProvider<? extends WithOutput>> gameArtifactProvidingTasks;
    @NotNull
    private final Configuration minecraftDependenciesConfiguration;
    @NotNull
    private final Map<String, String> mappingVersionData = Maps.newHashMap();
    @NotNull
    private final Consumer<TaskProvider<? extends Runtime>> associatedTaskConsumer;
    @NotNull
    private final ConfigurableFileCollection allDependencies;
    @NotNull
    private final Provider<VersionJson> versionJson;
    @NotNull
    private FileCollection additionalRecompileDependencies;
    @NotNull
    private FileCollection additionalSources;

    protected CommonRuntimeDefinition(@NotNull S specification, @NotNull LinkedHashMap<String, TaskProvider<? extends WithOutput>> taskOutputs, @NotNull TaskProvider<? extends ArtifactFromOutput> sourceJarTask, @NotNull TaskProvider<? extends ArtifactFromOutput> rawJarTask, @NotNull Map<GameArtifact, TaskProvider<? extends WithOutput>> gameArtifactProvidingTasks, @NotNull Configuration minecraftDependenciesConfiguration, @NotNull Consumer<TaskProvider<? extends Runtime>> associatedTaskConsumer, @NotNull Provider<VersionJson> versionJson) {
        this.specification = specification;
        this.taskOutputs = taskOutputs;
        this.sourceJarTask = sourceJarTask;
        this.rawJarTask = rawJarTask;
        this.gameArtifactProvidingTasks = gameArtifactProvidingTasks;
        this.minecraftDependenciesConfiguration = minecraftDependenciesConfiguration;
        this.associatedTaskConsumer = associatedTaskConsumer;
        this.versionJson = versionJson;
        this.additionalRecompileDependencies = ((CommonRuntimeSpecification)specification).getProject().files(new Object[0]);
        this.additionalSources = ((CommonRuntimeSpecification)specification).getProject().files(new Object[0]);
        this.allDependencies = ((CommonRuntimeSpecification)specification).getProject().files(new Object[0]);
        this.allDependencies.from(new Object[]{this.getMinecraftDependenciesConfiguration()});
        this.allDependencies.from(new Object[]{this.additionalRecompileDependencies});
    }

    @NotNull
    public final TaskProvider<? extends WithOutput> getTask(String name) {
        String taskName = CommonRuntimeUtils.buildTaskName((Definition)this, (String)name);
        if (!this.taskOutputs.containsKey(taskName)) {
            throw new IllegalArgumentException("No task with name " + name + " found in runtime " + ((CommonRuntimeSpecification)this.specification).getVersionedName());
        }
        return this.taskOutputs.get(taskName);
    }

    @NotNull
    public <T extends WithOutput & InputFileSpecification> TaskProvider<T> getRawJarTask() {
        return this.rawJarTask;
    }

    @NotNull
    public final S getSpecification() {
        return this.specification;
    }

    @NotNull
    public final LinkedHashMap<String, TaskProvider<? extends WithOutput>> getTasks() {
        return this.taskOutputs;
    }

    @NotNull
    public <T extends WithOutput & InputFileSpecification> TaskProvider<T> getSourceJarTask() {
        return this.sourceJarTask;
    }

    @NotNull
    public final Map<GameArtifact, TaskProvider<? extends WithOutput>> getGameArtifactProvidingTasks() {
        return this.gameArtifactProvidingTasks;
    }

    @NotNull
    public final Configuration getMinecraftDependenciesConfiguration() {
        return this.minecraftDependenciesConfiguration;
    }

    @NotNull
    public Map<String, String> getMappingVersionData() {
        return this.mappingVersionData;
    }

    public final void setMappingVersionData(@NotNull Map<String, String> data) {
        this.mappingVersionData.clear();
        this.mappingVersionData.putAll(data);
    }

    public void configureAssociatedTask(@NotNull TaskProvider<? extends Runtime> runtimeTask) {
        this.associatedTaskConsumer.accept(runtimeTask);
    }

    @NotNull
    public abstract TaskProvider<DownloadAssets> getAssets();

    @NotNull
    public abstract TaskProvider<ExtractNatives> getNatives();

    @NotNull
    public Provider<VersionJson> getVersionJson() {
        return this.versionJson;
    }

    @NotNull
    public Provider<JavaLanguageVersion> getRequiredJavaVersion() {
        return this.getVersionJson().map(VersionJson::getJavaVersion).map(VersionJson.JavaVersion::getMajorVersion).map(JavaLanguageVersion::of);
    }

    @NotNull
    public final ConfigurableFileCollection getAllDependencies() {
        return this.allDependencies;
    }

    @NotNull
    public FileCollection getAdditionalRecompileDependencies() {
        return this.additionalRecompileDependencies;
    }

    public void additionalRecompileDependency(Provider<RegularFile> dependency) {
        ConfigurableFileCollection files = ((CommonRuntimeSpecification)this.specification).getProject().files(new Object[]{dependency});
        this.additionalRecompileDependencies = this.additionalRecompileDependencies.plus((FileCollection)files);
    }

    public void additionalRecompileDependencies(FileCollection dependencies) {
        this.additionalRecompileDependencies = this.additionalRecompileDependencies.plus(dependencies);
    }

    @NotNull
    public FileCollection getAdditionalCompileSources() {
        return this.additionalSources;
    }

    public void additionalCompileSource(Provider<RegularFile> source) {
        ConfigurableFileCollection files = ((CommonRuntimeSpecification)this.specification).getProject().files(new Object[]{source});
        this.additionalSources = this.additionalSources.plus((FileCollection)files);
    }

    public void additionalCompileSources(FileCollection sources) {
        this.additionalSources = this.additionalSources.plus(sources);
    }

    public void additionalCompileSources(Object sources) {
        this.additionalCompileSources((FileCollection)this.getSpecification().getProject().getObjects().fileCollection().from(new Object[]{sources}));
    }

    public void configureRun(RunImpl run) {
        MapProperty runtimeInterpolationData = this.getSpecification().getProject().getObjects().mapProperty(String.class, String.class);
        this.buildRunInterpolationData(run, (MapProperty<String, String>)runtimeInterpolationData);
        runtimeInterpolationData.put((Object)"source_roots", RunsUtil.buildGradleModClasses((Provider<Multimap<String, SourceSet>>)run.getModSources().all()));
        run.getJvmArguments().addAll(TransformerUtils.ifTrue((Provider)run.getIsClient(), (Provider)this.getVersionJson().map(VersionJson::getPlatformJvmArgs)));
        run.overrideJvmArguments(this.interpolate(run.getJvmArguments(), (MapProperty<String, String>)runtimeInterpolationData));
        run.overrideArguments(this.interpolate(run.getArguments(), (MapProperty<String, String>)runtimeInterpolationData));
        run.overrideEnvironmentVariables(this.interpolate(run.getEnvironmentVariables(), (MapProperty<String, String>)runtimeInterpolationData));
        run.overrideSystemProperties(this.interpolate(run.getSystemProperties(), (MapProperty<String, String>)runtimeInterpolationData));
        run.getDependsOn().addAll(TransformerUtils.ifTrue((Provider)run.getIsClient().flatMap(TransformerUtils.or((Provider[])new Provider[]{run.getIsDataGenerator()})), (Provider[])new Provider[]{this.getAssets(), this.getNatives()}));
    }

    protected void buildRunInterpolationData(RunImpl run, @NotNull MapProperty<String, String> interpolationData) {
        interpolationData.put((Object)"runtime_name", (Object)((CommonRuntimeSpecification)this.specification).getVersionedName());
        interpolationData.put((Object)"mc_version", (Object)this.specification.getMinecraftVersion());
        interpolationData.put((Object)"assets_root", DownloadAssets.getAssetsDirectory(((CommonRuntimeSpecification)this.specification).getProject()).map(Directory::getAsFile).map(File::getAbsolutePath));
        interpolationData.put((Object)"asset_index", this.getAssets().flatMap(DownloadAssets::getAssetIndexTargetFile).map(RegularFile::getAsFile).map(File::getName).map(s -> s.substring(0, s.lastIndexOf(46))));
        interpolationData.put((Object)"natives", this.getNatives().flatMap(OutputSpecification::getOutputDirectory).map(Directory::getAsFile).map(File::getAbsolutePath));
    }

    protected ListProperty<String> interpolate(ListProperty<String> input, MapProperty<String, String> values) {
        return this.interpolate(input, values, "");
    }

    protected ListProperty<String> interpolate(ListProperty<String> input, MapProperty<String, String> values, String patternPrefix) {
        ListProperty delegated = this.getSpecification().getProject().getObjects().listProperty(String.class);
        delegated.set(input.flatMap(list -> {
            ListProperty interpolated = this.getSpecification().getProject().getObjects().listProperty(String.class);
            for (String s : list) {
                interpolated.add(CommonRuntimeDefinition.interpolate(s, values, patternPrefix));
            }
            return interpolated;
        }));
        return delegated;
    }

    protected MapProperty<String, String> interpolate(MapProperty<String, String> input, MapProperty<String, String> values) {
        return this.interpolate(input, values, "");
    }

    protected MapProperty<String, String> interpolate(MapProperty<String, String> input, MapProperty<String, String> values, String patternPrefix) {
        MapProperty delegated = this.getSpecification().getProject().getObjects().mapProperty(String.class, String.class);
        delegated.set(input.flatMap(map -> {
            MapProperty interpolated = this.getSpecification().getProject().getObjects().mapProperty(String.class, String.class);
            for (Map.Entry entry : map.entrySet()) {
                interpolated.put((Object)((String)entry.getKey()), CommonRuntimeDefinition.interpolate((String)entry.getValue(), values, patternPrefix));
            }
            return interpolated;
        }));
        return delegated;
    }

    private static Provider<String> interpolate(String input, MapProperty<String, String> values, String patternPrefix) {
        if (input == null) {
            throw new IllegalArgumentException("Input cannot be null");
        }
        return values.map(data -> {
            String result = input;
            for (Map.Entry entry : data.entrySet()) {
                result = result.replace(patternPrefix + "{" + (String)entry.getKey() + "}", (CharSequence)entry.getValue());
            }
            return result;
        });
    }

    public void validateRun(RunImpl run) {
    }
}

