/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.gradle.common.extensions.base;

import java.util.List;
import net.neoforged.gradle.common.extensions.base.WithLocalProperties;
import org.apache.commons.compress.utils.Lists;
import org.gradle.api.Project;
import org.gradle.api.file.Directory;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;

public abstract class WithEnabledProperty
extends WithLocalProperties {
    public WithEnabledProperty(Project project, String prefix) {
        super(project, prefix);
        this.getIsEnabled().set(this.getBooleanLocalProperty("enabled", true));
    }

    public WithEnabledProperty(WithEnabledProperty parent, String prefix) {
        super(parent, prefix);
        this.getIsEnabled().set(parent.getIsEnabled().zip(this.getBooleanLocalProperty("enabled", true), (parentEnabled, enabled) -> parentEnabled != false && enabled != false));
    }

    public abstract Property<Boolean> getIsEnabled();

    @Override
    protected Provider<String> getStringProperty(String propertyName, String defaultValue) {
        return this.getIsEnabled().zip(this.getStringLocalProperty(propertyName, defaultValue), (enabled, value) -> enabled != false ? value : "");
    }

    @Override
    protected Provider<Directory> getDirectoryProperty(String propertyName, Provider<Directory> defaultValue) {
        return this.getIsEnabled().zip(this.getDirectoryLocalProperty(propertyName, defaultValue), (enabled, value) -> enabled != false ? value : null);
    }

    @Override
    protected Provider<Boolean> getBooleanProperty(String propertyName, boolean defaultValue, boolean disabledValue) {
        return this.getIsEnabled().zip(this.getBooleanLocalProperty(propertyName, defaultValue), (enabled, value) -> enabled != false ? value : disabledValue);
    }

    @Override
    protected Provider<List<String>> getSpaceSeparatedListProperty(String propertyName, List<String> defaultValue) {
        return this.getIsEnabled().zip(this.getSpaceSeparatedListLocalProperty(propertyName, defaultValue), (enabled, value) -> enabled != false ? value : Lists.newArrayList());
    }
}

