/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.gradle.common.conventions;

import java.util.ArrayList;
import net.neoforged.gradle.common.extensions.IdeManagementExtension;
import net.neoforged.gradle.common.runs.ide.IdeRunIntegrationManager;
import net.neoforged.gradle.common.tasks.IdePostSyncExecutionTask;
import net.neoforged.gradle.common.util.ConfigurationUtils;
import net.neoforged.gradle.dsl.common.extensions.subsystems.Conventions;
import net.neoforged.gradle.dsl.common.extensions.subsystems.Subsystems;
import net.neoforged.gradle.dsl.common.extensions.subsystems.conventions.Configurations;
import net.neoforged.gradle.dsl.common.extensions.subsystems.conventions.IDE;
import net.neoforged.gradle.dsl.common.extensions.subsystems.conventions.Runs;
import net.neoforged.gradle.dsl.common.extensions.subsystems.conventions.SourceSets;
import net.neoforged.gradle.dsl.common.extensions.subsystems.conventions.ide.IDEA;
import net.neoforged.gradle.dsl.common.runs.run.Run;
import net.neoforged.gradle.dsl.common.runs.run.RunManager;
import org.gradle.StartParameter;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.file.FileCollection;
import org.gradle.api.tasks.SourceSetContainer;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.internal.DefaultTaskExecutionRequest;

public class ConventionConfigurator {
    public static void configureConventions(Project project) {
        Conventions conventions = ((Subsystems)project.getExtensions().getByType(Subsystems.class)).getConventions();
        ConventionConfigurator.configureRunConventions(project, conventions);
        ConventionConfigurator.configureSourceSetConventions(project, conventions);
        ConventionConfigurator.configureIDEConventions(project, conventions);
    }

    private static void configureSourceSetConventions(Project project, Conventions conventions) {
        SourceSets sourceSets = conventions.getSourceSets();
        Configurations configurations = conventions.getConfigurations();
        if (!((Boolean)sourceSets.getIsEnabled().get()).booleanValue()) {
            return;
        }
        if (((Boolean)configurations.getIsEnabled().get()).booleanValue()) {
            ((SourceSetContainer)project.getExtensions().getByType(SourceSetContainer.class)).configureEach(sourceSet -> {
                Configuration sourceSetLocalRuntimeConfiguration = (Configuration)project.getConfigurations().maybeCreate(ConfigurationUtils.getSourceSetName(sourceSet, (String)configurations.getLocalRuntimeConfigurationPostFix().get()));
                project.getConfigurations().maybeCreate(ConfigurationUtils.getSourceSetName(sourceSet, (String)configurations.getRunRuntimeConfigurationPostFix().get()));
                Configuration sourceSetRuntimeClasspath = (Configuration)project.getConfigurations().maybeCreate(sourceSet.getRuntimeClasspathConfigurationName());
                sourceSetRuntimeClasspath.extendsFrom(new Configuration[]{sourceSetLocalRuntimeConfiguration});
            });
        }
    }

    private static void configureRunConventions(Project project, Conventions conventions) {
        Configurations configurations = conventions.getConfigurations();
        Runs runs = conventions.getRuns();
        if (!((Boolean)runs.getIsEnabled().get()).booleanValue()) {
            return;
        }
        if (!((Boolean)configurations.getIsEnabled().get()).booleanValue()) {
            return;
        }
        Configuration runRuntimeConfiguration = (Configuration)project.getConfigurations().maybeCreate((String)configurations.getRunRuntimeConfigurationName().get());
        project.getExtensions().configure(RunManager.class, runContainer -> runContainer.configureAll(run -> run.getDependencies().getRuntime().add((FileCollection)runRuntimeConfiguration)));
        RunManager runManager = (RunManager)project.getExtensions().getByType(RunManager.class);
        project.getConfigurations().addRule("Create run specific runtime configuration", configurationName -> {
            if (!configurationName.endsWith((String)configurations.getPerRunRuntimeConfigurationPostFix().get())) {
                return;
            }
            String runName = configurationName.substring(0, configurationName.length() - ((String)configurations.getPerRunRuntimeConfigurationPostFix().get()).length());
            if (runManager.findByName(runName) == null) {
                return;
            }
            Run run = (Run)runManager.getByName(runName);
            Configuration runSpecificRuntimeConfiguration = (Configuration)project.getConfigurations().maybeCreate(ConfigurationUtils.getRunName(run, (String)configurations.getPerRunRuntimeConfigurationPostFix().get()));
            run.getDependencies().getRuntime().add((FileCollection)runSpecificRuntimeConfiguration);
        });
    }

    private static void configureIDEConventions(Project project, Conventions conventions) {
        IDE ideConventions = conventions.getIde();
        ConventionConfigurator.configureIDEAIDEConventions(project, ideConventions);
    }

    private static void configureIDEAIDEConventions(Project project, IDE ideConventions) {
        IDEA ideaConventions = ideConventions.getIdea();
        IdeManagementExtension ideManagementExtension = (IdeManagementExtension)project.getExtensions().getByType(IdeManagementExtension.class);
        ideManagementExtension.onIdea((innerProject, rootProject, idea, ideaExtension) -> {
            if (((Boolean)ideaConventions.getShouldUsePostSyncTask().get()).booleanValue()) {
                return;
            }
            if (!ideManagementExtension.isIdeaSyncing()) {
                return;
            }
            StartParameter startParameter = innerProject.getGradle().getStartParameter();
            ArrayList<DefaultTaskExecutionRequest> taskRequests = new ArrayList<DefaultTaskExecutionRequest>(startParameter.getTaskRequests());
            TaskProvider<? extends IdePostSyncExecutionTask> ideImportTask = ideManagementExtension.getOrCreateIdeImportTask();
            ArrayList<String> taskPaths = new ArrayList<String>();
            String ideImportTaskName = ideImportTask.getName();
            String projectPath = innerProject.getPath();
            String taskPath = ideImportTaskName.startsWith(":") ? (projectPath.equals(":") ? ideImportTaskName : String.format("%s%s", projectPath, ideImportTaskName)) : (projectPath.equals(":") ? String.format(":%s", ideImportTaskName) : String.format("%s:%s", projectPath, ideImportTaskName));
            taskPaths.add(taskPath);
            taskRequests.add(new DefaultTaskExecutionRequest(taskPaths));
            startParameter.setTaskRequests(taskRequests);
        });
        IdeRunIntegrationManager.getInstance().configureIdeaConventions(project, ideaConventions);
    }
}

