/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.gradle.common.tasks;

import java.util.Arrays;
import java.util.stream.Collectors;
import net.neoforged.gradle.dsl.common.extensions.Mappings;
import net.neoforged.gradle.dsl.common.extensions.Minecraft;
import net.neoforged.gradle.dsl.common.runtime.naming.NamingChannel;
import net.neoforged.gradle.dsl.common.tasks.NeoGradleBase;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.TaskAction;

public abstract class DisplayMappingsLicenseTask
extends NeoGradleBase {
    public DisplayMappingsLicenseTask() {
        this.getProject().getTasks().configureEach(task -> {
            if (task instanceof DisplayMappingsLicenseTask) {
                return;
            }
            try {
                task.dependsOn(new Object[]{this});
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        });
        this.setOnlyIf(task -> {
            Mappings mappingsExtension = (Mappings)this.getProject().getExtensions().getByType(Mappings.class);
            return mappingsExtension.getChannel().isPresent() && (Boolean)((NamingChannel)mappingsExtension.getChannel().get()).getHasAcceptedLicense().getOrElse((Object)false) == false;
        });
    }

    @TaskAction
    public void run() {
        Mappings mappingsExtension = ((Minecraft)this.getProject().getExtensions().getByType(Minecraft.class)).getMappings();
        this.displayWarning((NamingChannel)mappingsExtension.getChannel().get());
    }

    private void displayWarning(NamingChannel channel) {
        if (!this.getLicense().isPresent()) {
            return;
        }
        String license = (String)this.getLicense().get();
        String warning = this.buildWarning();
        this.getLogger().warn(warning);
        this.getLogger().warn(Arrays.stream(license.split("\n")).map(line -> String.format("WARNING: %s", line)).collect(Collectors.joining("\n")));
    }

    private String buildWarning() {
        return "WARNING: This project is configured to use obfuscation mappings with a custom license attached.\nWARNING: These mapping fall under their associated license, you should be fully aware of this license.\nWARNING: For the latest license text, refer below.\nWARNING: You can hide this warning by accepting its license.\nWARNING: See the naming channels documentation for more information on how to do that.";
    }

    @Input
    @Optional
    public abstract Property<String> getLicense();
}

