/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.gradle.common.util;

import java.util.function.Consumer;
import net.neoforged.gradle.common.extensions.subsystems.SubsystemsExtension;
import net.neoforged.gradle.common.runtime.tasks.JavaSourceTransformer;
import net.neoforged.gradle.common.runtime.tasks.ListLibraries;
import net.neoforged.gradle.common.util.ToolUtilities;
import net.neoforged.gradle.dsl.common.extensions.AccessTransformers;
import net.neoforged.gradle.dsl.common.extensions.InterfaceInjections;
import net.neoforged.gradle.dsl.common.extensions.Minecraft;
import net.neoforged.gradle.dsl.common.extensions.subsystems.Subsystems;
import net.neoforged.gradle.dsl.common.runtime.definition.Definition;
import net.neoforged.gradle.dsl.common.runtime.spec.Specification;
import net.neoforged.gradle.dsl.common.runtime.tasks.Runtime;
import net.neoforged.gradle.dsl.common.runtime.tasks.tree.TaskTreeAdapter;
import net.neoforged.gradle.dsl.common.tasks.WithOutput;
import net.neoforged.gradle.dsl.common.tasks.specifications.OutputSpecification;
import net.neoforged.gradle.dsl.common.util.CommonRuntimeUtils;
import org.gradle.api.Project;
import org.gradle.api.file.FileCollection;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.TaskProvider;
import org.jetbrains.annotations.Nullable;

public class JavaSourceTransformAdapterUtils {
    private JavaSourceTransformAdapterUtils() {
        throw new IllegalStateException("Can not instantiate an instance of: McpAccessTransformerUtils. This is a utility class");
    }

    public static TaskTreeAdapter createCustomizationsAdapter(Project project, FileCollection systemAccessTransformers) {
        Minecraft minecraftExtension = (Minecraft)project.getExtensions().getByType(Minecraft.class);
        AccessTransformers accessTransformers = minecraftExtension.getAccessTransformers();
        InterfaceInjections interfaceInjections = minecraftExtension.getInterfaceInjections();
        SubsystemsExtension.ParchmentExtensions parchment = (SubsystemsExtension.ParchmentExtensions)((Subsystems)project.getExtensions().getByType(Subsystems.class)).getParchment();
        return (definition, previousTasksOutput, runtimeWorkspace, gameArtifacts, mappingVersionData, dependentTaskConfigurationHandler) -> {
            FileCollection accessTransformerFiles = systemAccessTransformers.plus((FileCollection)accessTransformers.getFiles());
            TaskProvider<JavaSourceTransformer> transformer = JavaSourceTransformAdapterUtils.createJavaSourceTransformerTask(accessTransformerFiles, (FileCollection)interfaceInjections.getFiles(), definition, (Provider<? extends WithOutput>)previousTasksOutput, dependentTaskConfigurationHandler, parchment);
            if (transformer != null) {
                definition.additionalCompileSources((Object)transformer.flatMap(JavaSourceTransformer::getStubs));
            }
            return transformer;
        };
    }

    public static TaskProvider<ListLibraries> createRecompileLibrariesList(Definition<?> definition) {
        FileCollection recompileDependencies = definition.getAdditionalRecompileDependencies().plus((FileCollection)definition.getSpecification().getProject().files(new Object[]{definition.getMinecraftDependenciesConfiguration()}));
        return definition.getSpecification().getProject().getTasks().register(CommonRuntimeUtils.buildTaskName(definition, (String)"listTransformLibraries"), ListLibraries.class, task -> task.getVersionJsonLibraries().from(new Object[]{recompileDependencies}));
    }

    @Nullable
    public static TaskProvider<JavaSourceTransformer> createJavaSourceTransformerTask(FileCollection accessTransformerFiles, FileCollection interfaceInjectionFiles, Definition<?> definition, Provider<? extends WithOutput> previousTasksOutput, Consumer<TaskProvider<? extends Runtime>> dependentTaskConfigurationHandler, SubsystemsExtension.ParchmentExtensions parchment) {
        Provider<String> parchmentArtifact = parchment.getSelectedParchmentArtifact(definition.getSpecification().getMinecraftVersion());
        if (accessTransformerFiles.isEmpty() && interfaceInjectionFiles.isEmpty() && !parchmentArtifact.isPresent()) {
            return null;
        }
        TaskProvider<ListLibraries> recompileLibraries = JavaSourceTransformAdapterUtils.createRecompileLibrariesList(definition);
        dependentTaskConfigurationHandler.accept(recompileLibraries);
        return definition.getSpecification().getProject().getTasks().register(CommonRuntimeUtils.buildTaskName((Specification)definition.getSpecification(), (String)"transformSource"), JavaSourceTransformer.class, task -> {
            task.getTransformers().from(new Object[]{accessTransformerFiles});
            task.getInterfaceInjections().from(new Object[]{interfaceInjectionFiles});
            if (parchmentArtifact.isPresent()) {
                task.getParchmentMappings().from(new Object[]{ToolUtilities.resolveConfigurationFor(definition.getSpecification().getProject(), (String)parchmentArtifact.get())});
                task.getParchmentConflictPrefix().set((Provider)parchment.getConflictPrefix());
            }
            task.getInputFile().set(previousTasksOutput.flatMap(OutputSpecification::getOutput));
            task.dependsOn(new Object[]{definition.getListLibrariesTaskProvider()});
            task.getLibraries().set(recompileLibraries.flatMap(OutputSpecification::getOutput));
            task.getClasspath().from(new Object[]{definition.getAllDependencies()});
        });
    }
}

