/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.gradle.common.util;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import net.minecraftforge.srgutils.IMappingFile;
import net.minecraftforge.srgutils.IRenamer;
import net.neoforged.gradle.util.IMappingFileUtils;

public class CacheableIMappingFile
implements IMappingFile,
Serializable {
    private IMappingFile delegate;

    public CacheableIMappingFile(IMappingFile delegate) {
        this.delegate = delegate;
    }

    public Collection<? extends IMappingFile.IPackage> getPackages() {
        return this.delegate.getPackages();
    }

    public IMappingFile.IPackage getPackage(String original) {
        return this.delegate.getPackage(original);
    }

    public Collection<? extends IMappingFile.IClass> getClasses() {
        return this.delegate.getClasses();
    }

    public IMappingFile.IClass getClass(String original) {
        return this.delegate.getClass(original);
    }

    public String remapPackage(String pkg) {
        return this.delegate.remapClass(pkg);
    }

    public String remapClass(String desc) {
        return this.delegate.remapClass(desc);
    }

    public String remapDescriptor(String desc) {
        return this.delegate.remapDescriptor(desc);
    }

    public void write(Path path, IMappingFile.Format format, boolean reversed) throws IOException {
        this.delegate.write(path, format, reversed);
    }

    public IMappingFile reverse() {
        return new CacheableIMappingFile(this.delegate.reverse());
    }

    public IMappingFile rename(IRenamer renamer) {
        return new CacheableIMappingFile(this.delegate.rename(renamer));
    }

    public IMappingFile chain(IMappingFile other) {
        return new CacheableIMappingFile(this.delegate.chain(other));
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        List clientLines = IMappingFileUtils.writeMappingFile((IMappingFile)this.delegate, (IMappingFile.Format)IMappingFile.Format.TSRG2, (boolean)false);
        out.writeObject(clientLines);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        List clientLines = (List)in.readObject();
        ByteArrayInputStream clientStream = new ByteArrayInputStream(String.join((CharSequence)"\n", clientLines).getBytes());
        this.delegate = IMappingFile.load((InputStream)clientStream);
    }

    private void readObjectNoData() throws ObjectStreamException {
        throw new UnsupportedOperationException();
    }
}

