/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.gradle.common.runtime.naming.renamer;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.util.List;
import java.util.Objects;
import net.minecraftforge.srgutils.IMappingFile;
import net.neoforged.gradle.common.runtime.naming.renamer.ITypeRenamer;
import net.neoforged.gradle.util.IMappingFileUtils;

public class IMappingFileTypeRenamer
implements ITypeRenamer {
    private IMappingFile clientMappings;
    private IMappingFile serverMappings;

    public static ITypeRenamer from(File clientFile, File serverFile) throws IOException {
        return new IMappingFileTypeRenamer(IMappingFile.load((File)clientFile), IMappingFile.load((File)serverFile));
    }

    public static ITypeRenamer from(IMappingFile clientMappings, IMappingFile serverMappings) {
        Objects.requireNonNull(clientMappings, "clientMappings");
        Objects.requireNonNull(serverMappings, "serverMappings");
        return new IMappingFileTypeRenamer(clientMappings, serverMappings);
    }

    private IMappingFileTypeRenamer(IMappingFile clientMappings, IMappingFile serverMappings) {
        this.clientMappings = clientMappings;
        this.serverMappings = serverMappings;
    }

    @Override
    public String renameType(String type) {
        String clientType = this.clientMappings.remapClass(type.replace('.', '/')).replace('.', '/');
        if (Objects.equals(clientType, type)) {
            return this.serverMappings.remapClass(type.replace('.', '/')).replace('.', '/');
        }
        return clientType;
    }

    @Override
    public String renameField(String owner, String name) {
        String serverName;
        String clientName;
        IMappingFile.IClass clientClass = this.clientMappings.getClass(owner.replace('.', '/'));
        if (clientClass != null && !Objects.equals(clientName = clientClass.remapField(name), name)) {
            return clientName;
        }
        IMappingFile.IClass serverClass = this.serverMappings.getClass(owner.replace('.', '/'));
        if (serverClass != null && !Objects.equals(serverName = serverClass.remapField(name), name)) {
            return serverName;
        }
        return name;
    }

    @Override
    public String renameMethod(String owner, String name, String desc) {
        String serverName;
        String clientName;
        IMappingFile.IClass clientClass = this.clientMappings.getClass(owner.replace('.', '/'));
        if (clientClass != null && !Objects.equals(clientName = clientClass.remapMethod(name, desc), name)) {
            return clientName;
        }
        IMappingFile.IClass serverClass = this.serverMappings.getClass(owner.replace('.', '/'));
        if (serverClass != null && !Objects.equals(serverName = serverClass.remapMethod(name, desc), name)) {
            return serverName;
        }
        return name;
    }

    @Override
    public String renameDescriptor(String desc) {
        String clientDescriptor = this.clientMappings.remapDescriptor(desc);
        if (!Objects.equals(clientDescriptor, desc)) {
            return clientDescriptor;
        }
        String serverDescriptor = this.serverMappings.remapDescriptor(desc);
        if (!Objects.equals(serverDescriptor, desc)) {
            return serverDescriptor;
        }
        return desc;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        List clientLines = IMappingFileUtils.writeMappingFile((IMappingFile)this.clientMappings, (IMappingFile.Format)IMappingFile.Format.TSRG2, (boolean)false);
        List serverLines = IMappingFileUtils.writeMappingFile((IMappingFile)this.serverMappings, (IMappingFile.Format)IMappingFile.Format.TSRG2, (boolean)false);
        out.writeObject(clientLines);
        out.writeObject(serverLines);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        List clientLines = (List)in.readObject();
        List serverLines = (List)in.readObject();
        ByteArrayInputStream clientStream = new ByteArrayInputStream(String.join((CharSequence)"\n", clientLines).getBytes());
        ByteArrayInputStream serverStream = new ByteArrayInputStream(String.join((CharSequence)"\n", serverLines).getBytes());
        this.clientMappings = IMappingFile.load((InputStream)clientStream);
        this.serverMappings = IMappingFile.load((InputStream)serverStream);
    }

    private void readObjectNoData() throws ObjectStreamException {
        throw new UnsupportedOperationException();
    }
}

