/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.gradle.common.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public class ZipFileUpdater {
    public static void addFileToZip(File zipFile, File fileToAdd, String entryName) throws IOException {
        File tempFile = File.createTempFile(zipFile.getName(), null);
        tempFile.delete();
        try (ZipInputStream zis = new ZipInputStream(new FileInputStream(zipFile));
             ZipOutputStream zos = new ZipOutputStream(new FileOutputStream(tempFile));){
            ZipEntry entry;
            while ((entry = zis.getNextEntry()) != null) {
                int len;
                if (entry.getName().equals(entryName)) continue;
                zos.putNextEntry(new ZipEntry(entry.getName()));
                byte[] buffer = new byte[1024];
                while ((len = zis.read(buffer)) > 0) {
                    zos.write(buffer, 0, len);
                }
                zos.closeEntry();
                zis.closeEntry();
            }
            try (FileInputStream fis = new FileInputStream(fileToAdd);){
                int len;
                zos.putNextEntry(new ZipEntry(entryName));
                byte[] buffer = new byte[1024];
                while ((len = ((InputStream)fis).read(buffer)) > 0) {
                    zos.write(buffer, 0, len);
                }
                zos.closeEntry();
            }
        }
        Files.delete(zipFile.toPath());
        Files.move(tempFile.toPath(), zipFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
    }
}

