/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.gradle.common.extensions;

import javax.inject.Inject;
import net.neoforged.gradle.common.extensions.problems.IProblemReporter;
import net.neoforged.gradle.common.extensions.problems.NeoGradleProblemSpec;
import net.neoforged.gradle.dsl.common.extensions.InterfaceInjections;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.artifacts.ConfigurablePublishArtifact;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.dsl.ArtifactHandler;
import org.gradle.api.artifacts.dsl.DependencyHandler;

public abstract class InterfaceInjectionsExtension
implements InterfaceInjections {
    private final transient DependencyHandler projectDependencies;
    private final transient ArtifactHandler projectArtifacts;
    private final Project project;

    @Inject
    public InterfaceInjectionsExtension(Project project) {
        this.project = project;
        this.projectDependencies = project.getDependencies();
        this.projectArtifacts = project.getArtifacts();
    }

    public Project getProject() {
        return this.project;
    }

    public void expose(Object path, Action<ConfigurablePublishArtifact> action) {
        this.getFiles().from(new Object[]{path});
        this.projectArtifacts.add("interfaceInjectionElements", path, action);
    }

    public void expose(Object path) {
        this.expose(path, (Action<ConfigurablePublishArtifact>)((Action)artifacts -> {}));
    }

    public void expose(Dependency dependency) {
        ((IProblemReporter)this.project.getExtensions().getByType(IProblemReporter.class)).reporting((Action<NeoGradleProblemSpec>)((Action)spec -> spec.id("interface-injections", "expose.deprecated").details("Using the expose(Dependency) method is deprecated.").solution("Use the dependency collectors: 'consume' and 'consumeApi' for adding interface injections from your dependencies.").section("userdev-interface-injections-from-dependencies").contextualLabel("Deprecations")), this.project.getLogger());
        this.projectDependencies.add("interfaceInjectionApi", (Object)dependency);
    }
}

