/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.gradle.common.services.caching.locking;

import com.google.common.collect.Lists;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.neoforged.gradle.common.services.caching.locking.OwnerAwareReentrantLock;
import net.neoforged.gradle.common.services.caching.logging.CacheLogger;

public final class PIDBasedFileLock
implements AutoCloseable {
    private static final Map<String, OwnerAwareReentrantLock> FILE_LOCKS = new ConcurrentHashMap<String, OwnerAwareReentrantLock>();
    private final File lockFile;
    private final CacheLogger logger;

    public PIDBasedFileLock(File lockFile, CacheLogger logger) {
        this.lockFile = lockFile;
        this.logger = logger;
        this.lockFile();
    }

    private void lockFile() {
        this.logger.debug("Attempting to acquire lock on file: " + this.lockFile.getAbsolutePath());
        while (!this.attemptFileLock()) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                throw new RuntimeException("Failed to acquire lock on file: " + this.lockFile.getAbsolutePath(), e);
            }
        }
        this.logger.debug("Lock acquired on file: " + this.lockFile.getAbsolutePath());
    }

    private synchronized boolean attemptFileLock() {
        try {
            if (!this.lockFile.exists()) {
                this.lockFile.getParentFile().mkdirs();
                Files.write(this.lockFile.toPath(), String.valueOf(ProcessHandle.current().pid()).getBytes(), StandardOpenOption.CREATE_NEW);
                this.lockFileForCurrentProcess();
                return true;
            }
            Iterator<String> iterator = Files.readAllLines(this.lockFile.toPath()).iterator();
            if (iterator.hasNext()) {
                String s = iterator.next();
                int pid = Integer.parseInt(s);
                if (ProcessHandle.current().pid() == (long)pid) {
                    this.logger.debug("Lock file is owned by current process: " + this.lockFile.getAbsolutePath() + " pid: " + pid);
                    this.lockFileForCurrentProcess();
                    return true;
                }
                if (ProcessHandle.of(pid).isEmpty()) {
                    this.logger.debug("Lock file is owned by a killed process: " + this.lockFile.getAbsolutePath() + " taking over. Old pid: " + pid);
                    Files.write(this.lockFile.toPath(), String.valueOf(ProcessHandle.current().pid()).getBytes(), StandardOpenOption.TRUNCATE_EXISTING);
                    this.lockFileForCurrentProcess();
                    return true;
                }
                this.logger.debug("Lock file is owned by another process: " + this.lockFile.getAbsolutePath() + " pid: " + pid);
                return false;
            }
            this.logger.debug("Lock file is empty: " + this.lockFile.getAbsolutePath());
            Files.write(this.lockFile.toPath(), String.valueOf(ProcessHandle.current().pid()).getBytes(), StandardOpenOption.TRUNCATE_EXISTING);
            this.lockFileForCurrentProcess();
            return true;
        }
        catch (Exception e) {
            this.logger.debug("Failed to acquire lock on file: " + this.lockFile.getAbsolutePath() + " -  Failure message: " + e.getLocalizedMessage(), e);
            return false;
        }
    }

    private void lockFileForCurrentProcess() {
        OwnerAwareReentrantLock lock = FILE_LOCKS.computeIfAbsent(this.lockFile.getAbsolutePath(), s1 -> new OwnerAwareReentrantLock());
        if (lock.getOwner() != null) {
            this.logger.debug("Lock file is held by thread: " + lock.getOwner().getId() + " - " + lock.getOwner().getName() + " current thread: " + Thread.currentThread().getId() + " - " + Thread.currentThread().getName());
        } else {
            this.logger.debug("Lock file is not held by any thread");
        }
        lock.lock();
    }

    @Override
    public void close() throws Exception {
        this.logger.debug("Releasing lock on file: " + this.lockFile.getAbsolutePath());
        Files.write(this.lockFile.toPath(), (Iterable<? extends CharSequence>)Lists.newArrayList(), StandardOpenOption.TRUNCATE_EXISTING);
        if (FILE_LOCKS.containsKey(this.lockFile.getAbsolutePath())) {
            this.logger.debug("Unlocking: " + Thread.currentThread().getId() + " - " + Thread.currentThread().getName());
            OwnerAwareReentrantLock lock = FILE_LOCKS.get(this.lockFile.getAbsolutePath());
            lock.unlock();
        }
    }
}

