/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.gradle.common.util;

import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.function.Function;
import net.neoforged.gradle.common.util.SourceSetUtils;
import net.neoforged.gradle.dsl.common.extensions.dependency.replacement.DependencyReplacement;
import net.neoforged.gradle.dsl.common.runs.run.Run;
import org.apache.commons.lang3.StringUtils;
import org.codehaus.groovy.runtime.StringGroovyMethods;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.file.FileSystemLocation;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetContainer;

public class ConfigurationUtils {
    private static final String NEOGRADLE_RUNTIME_REPLACEMENT = "neoGradleDependencyReplacementTarget";
    private static final Set<Configuration> UNHANDLED_CONFIGURATIONS = new HashSet<Configuration>();

    private ConfigurationUtils() {
        throw new IllegalStateException("Can not instantiate an instance of: ConfigurationUtils. This is a utility class");
    }

    public static void extendsFrom(Project project, Configuration target, Configuration ... configurations) {
        for (Configuration configuration : configurations) {
            target.getDependencies().addAllLater(project.provider(() -> ((Configuration)configuration).getAllDependencies()));
            target.getDependencyConstraints().addAllLater(project.provider(() -> ((Configuration)configuration).getAllDependencyConstraints()));
        }
    }

    public static Configuration temporaryConfiguration(Project project, String context, Dependency ... dependencies) {
        Configuration configuration = project.getConfigurations().detachedConfiguration(dependencies);
        DependencyReplacement dependencyReplacement = (DependencyReplacement)project.getExtensions().getByType(DependencyReplacement.class);
        dependencyReplacement.handleConfiguration(configuration);
        return configuration;
    }

    public static Configuration temporaryConfiguration(Project project, String context, Action<Configuration> processor) {
        Configuration config = project.getConfigurations().detachedConfiguration(new Dependency[0]);
        processor.execute((Object)config);
        DependencyReplacement dependencyReplacement = (DependencyReplacement)project.getExtensions().getByType(DependencyReplacement.class);
        dependencyReplacement.handleConfiguration(config);
        return config;
    }

    public static boolean isUnhandledConfiguration(Configuration configuration) {
        return UNHANDLED_CONFIGURATIONS.contains(configuration);
    }

    public static Configuration temporaryUnhandledConfiguration(ConfigurationContainer configurations, String context, Dependency ... dependencies) {
        Configuration config = configurations.detachedConfiguration(dependencies);
        UNHANDLED_CONFIGURATIONS.add(config);
        return config;
    }

    public static Configuration temporaryUnhandledConfiguration(ConfigurationContainer configurations, String context, Provider<? extends Iterable<Dependency>> dependencies) {
        Configuration config = configurations.detachedConfiguration(new Dependency[0]);
        config.getDependencies().addAllLater(dependencies);
        UNHANDLED_CONFIGURATIONS.add(config);
        return config;
    }

    public static Configuration temporaryUnhandledNotTransitiveConfiguration(ConfigurationContainer configurations, String context, Dependency ... dependencies) {
        Configuration config = configurations.detachedConfiguration(dependencies);
        config.setTransitive(false);
        UNHANDLED_CONFIGURATIONS.add(config);
        return config;
    }

    public static Provider<File> getArtifactProvider(Project project, String context, Provider<?> dependencyNotationProvider) {
        return dependencyNotationProvider.flatMap(dependencyNotation -> {
            Configuration configuration = ConfigurationUtils.temporaryUnhandledNotTransitiveConfiguration(project.getConfigurations(), context, project.getDependencies().create(dependencyNotation));
            return configuration.getElements().map(files -> ((FileSystemLocation)files.iterator().next()).getAsFile());
        });
    }

    public static List<Configuration> findReplacementConfigurations(Project project, Configuration configuration) {
        HashSet<Configuration> resultContainer = new HashSet<Configuration>();
        resultContainer.addAll(ConfigurationUtils.findCompileOnlyConfigurationForSourceSetReplacement(project, configuration));
        resultContainer.addAll(ConfigurationUtils.findRuntimeOnlyConfigurationFromSourceSetReplacement(project, configuration));
        if (resultContainer.isEmpty()) {
            resultContainer.add(configuration);
        }
        return new ArrayList<Configuration>(resultContainer);
    }

    public static List<Configuration> findConfigurationForSourceSetReplacement(Project project, Configuration configuration, Function<SourceSet, Configuration> potentialTargetSelector, boolean requiresSuperTarget) {
        SourceSetContainer sourceSetContainer = (SourceSetContainer)project.getExtensions().getByType(SourceSetContainer.class);
        ArrayList<Configuration> targets = new ArrayList<Configuration>();
        sourceSetContainer.forEach(sourceSet -> {
            Configuration target = (Configuration)potentialTargetSelector.apply((SourceSet)sourceSet);
            Configuration compileClasspath = (Configuration)project.getConfigurations().findByName(sourceSet.getCompileClasspathConfigurationName());
            if (configuration.equals(target)) {
                targets.clear();
                targets.add(target);
                return;
            }
            Set<Configuration> supers = ConfigurationUtils.getAllSuperConfigurations(compileClasspath);
            if ((!requiresSuperTarget || supers.contains(target)) && supers.contains(configuration)) {
                targets.add(target);
            }
        });
        return targets;
    }

    public static List<Configuration> findSdkConfigurationForSourceSetReplacement(Project project, Configuration configuration) {
        return ConfigurationUtils.findConfigurationForSourceSetReplacement(project, configuration, ConfigurationUtils::getSdkConfiguration, false);
    }

    public static List<Configuration> findCompileOnlyConfigurationForSourceSetReplacement(Project project, Configuration configuration) {
        return ConfigurationUtils.findConfigurationForSourceSetReplacement(project, configuration, sourceSet -> (Configuration)project.getConfigurations().findByName(sourceSet.getCompileOnlyConfigurationName()), true);
    }

    public static List<Configuration> findRuntimeOnlyConfigurationFromSourceSetReplacement(Project project, Configuration configuration) {
        SourceSetContainer sourceSetContainer = (SourceSetContainer)project.getExtensions().getByType(SourceSetContainer.class);
        ArrayList<Configuration> targets = new ArrayList<Configuration>();
        sourceSetContainer.forEach(sourceSet -> {
            Configuration runtimeOnly = (Configuration)project.getConfigurations().findByName(sourceSet.getRuntimeOnlyConfigurationName());
            Configuration runtimeClasspath = (Configuration)project.getConfigurations().findByName(sourceSet.getRuntimeClasspathConfigurationName());
            if (runtimeOnly == null) {
                return;
            }
            if (configuration.equals(runtimeOnly)) {
                targets.clear();
                targets.add(runtimeOnly);
                return;
            }
            Set<Configuration> supers = ConfigurationUtils.getAllSuperConfigurations(runtimeClasspath);
            if (supers.contains(runtimeOnly) && supers.contains(configuration)) {
                Configuration detachedRuntimeOnly = project.getConfigurations().detachedConfiguration(new Dependency[0]);
                ConfigurationUtils.extendsFrom(project, runtimeClasspath, detachedRuntimeOnly);
                targets.add(detachedRuntimeOnly);
            }
        });
        return targets;
    }

    public static Set<Configuration> getAllSuperConfigurations(Configuration configuration) {
        HashSet<Configuration> supers = new HashSet<Configuration>();
        ConfigurationUtils.getAllSuperConfigurationsRecursive(configuration, supers);
        return supers;
    }

    private static void getAllSuperConfigurationsRecursive(Configuration configuration, Set<Configuration> supers) {
        configuration.getExtendsFrom().forEach(files -> {
            if (supers.add((Configuration)files)) {
                ConfigurationUtils.getAllSuperConfigurationsRecursive(files, supers);
            }
        });
    }

    public static String getSourceSetName(SourceSet sourceSet, String postFix) {
        String capitalized = StringGroovyMethods.capitalize((CharSequence)postFix);
        String name = sourceSet.getName().equals("main") ? "" : StringGroovyMethods.capitalize((CharSequence)sourceSet.getName());
        return StringGroovyMethods.uncapitalize((CharSequence)(name + capitalized));
    }

    public static String getRunName(Run sourceSet, String postFix) {
        String capitalized = StringGroovyMethods.capitalize((CharSequence)postFix);
        String name = StringGroovyMethods.capitalize((CharSequence)sourceSet.getName());
        return StringGroovyMethods.uncapitalize((CharSequence)(name + capitalized));
    }

    public static String configurationNameOf(SourceSet sourceSet, String baseName) {
        if (SourceSet.isMain((SourceSet)sourceSet)) {
            if (baseName.length() == 1) {
                return baseName.toLowerCase(Locale.ROOT);
            }
            return baseName.substring(0, 1).toLowerCase(Locale.ROOT) + baseName.substring(1);
        }
        String compileOnlyApiName = sourceSet.getCompileOnlyApiConfigurationName();
        return compileOnlyApiName.replace(StringUtils.capitalize((String)"compileOnlyApi"), StringUtils.capitalize((String)baseName));
    }

    public static Configuration getSdkConfiguration(SourceSet sourceSet) {
        Project project = SourceSetUtils.getProject(sourceSet);
        Configuration configuration = (Configuration)project.getConfigurations().findByName(ConfigurationUtils.configurationNameOf(sourceSet, "sdk"));
        if (configuration == null) {
            configuration = (Configuration)project.getConfigurations().create(ConfigurationUtils.configurationNameOf(sourceSet, "sdk"));
        }
        return configuration;
    }

    public static void ensureReplacementConfigurationExists(Project project) {
        ((SourceSetContainer)project.getExtensions().getByType(SourceSetContainer.class)).all(sourceSet -> project.getConfigurations().maybeCreate(ConfigurationUtils.getSourceSetName(sourceSet, "%s%s".formatted(NEOGRADLE_RUNTIME_REPLACEMENT, StringUtils.capitalize((String)sourceSet.getName())))));
    }
}

