/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.gradle.common.runtime.tasks;

import com.google.common.collect.Lists;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipOutputStream;
import net.neoforged.gradle.common.runtime.tasks.DefaultExecute;
import net.neoforged.gradle.common.services.caching.CachedExecutionService;
import net.neoforged.gradle.common.services.caching.jobs.ICacheableJob;
import net.neoforged.gradle.common.util.ToolUtilities;
import net.neoforged.gradle.dsl.common.extensions.subsystems.Subsystems;
import net.neoforged.gradle.util.CopyingFileTreeVisitor;
import net.neoforged.gradle.util.ZipBuildingFileTreeVisitor;
import org.gradle.api.Task;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.ConfigurableFileTree;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileTree;
import org.gradle.api.file.FileVisitor;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.CompileClasspath;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;

@CacheableTask
public abstract class JavaSourceTransformer
extends DefaultExecute {
    public JavaSourceTransformer() {
        this.setDescription("Runs the access transformer on the decompiled sources.");
        this.getStubs().convention(this.getOutputDirectory().map(dir -> dir.file("stubs.jar")));
        this.getParchmentConflictPrefix().convention((Object)"p_");
        this.getExecutingClasspath().from(new Object[]{ToolUtilities.resolveTool(this.getProject(), (String)((Subsystems)this.getProject().getExtensions().getByType(Subsystems.class)).getTools().getJST().get())});
        this.getTransformed().convention(this.getOutputDirectory().map(output -> output.dir("transformed")));
        this.getRuntimeProgramArguments().convention(this.getInputFile().map(inputFile -> {
            ArrayList args = Lists.newArrayList();
            File outputFile = ((Directory)this.getTransformed().get()).getAsFile();
            if (outputFile.isFile()) {
                outputFile.delete();
            }
            if (!outputFile.exists()) {
                outputFile.mkdirs();
            }
            if (!this.getTransformers().isEmpty()) {
                args.add("--enable-accesstransformers");
                this.getTransformers().forEach(f -> {
                    args.add("--access-transformer");
                    args.add(f.getAbsolutePath());
                });
            }
            if (!this.getInterfaceInjections().isEmpty()) {
                File stubsFile = this.ensureFileWorkspaceReady(this.getStubs());
                args.add("--enable-interface-injection");
                this.getInterfaceInjections().forEach(f -> {
                    args.add("--interface-injection-data");
                    args.add(f.getAbsolutePath());
                });
                args.add("--interface-injection-stubs");
                args.add(stubsFile.getAbsolutePath());
            }
            if (!this.getParchmentMappings().isEmpty()) {
                File parchment = this.getParchmentMappings().getSingleFile();
                String conflictPrefix = (String)this.getParchmentConflictPrefix().getOrElse((Object)"p_");
                args.add("--enable-parchment");
                args.add("--parchment-mappings");
                args.add(parchment.getAbsolutePath());
                args.add("--parchment-conflict-prefix=%s".formatted(conflictPrefix));
            }
            args.add("--libraries-list=" + ((RegularFile)this.getLibraries().get()).getAsFile().getAbsolutePath());
            StringBuilder builder = new StringBuilder();
            this.getClasspath().forEach(f -> {
                if (!builder.isEmpty()) {
                    builder.append(File.pathSeparator);
                }
                builder.append(f.getAbsolutePath());
            });
            args.add("--classpath=" + String.valueOf(builder));
            args.add("--in-format=archive");
            args.add("--out-format=folder");
            args.add(inputFile.getAsFile().getAbsolutePath());
            args.add(outputFile.getAbsolutePath());
            return args;
        }));
        this.getTransformers().finalizeValueOnRead();
    }

    @Override
    public void execute() throws Throwable {
        ((CachedExecutionService)this.getCacheService().get()).cached((Task)this, ICacheableJob.Default.of(this::doExecute, ICacheableJob.OutputEntry.directory(((Directory)this.getTransformed().get()).getAsFile()), ICacheableJob.OutputEntry.file(((RegularFile)this.getStubs().get()).getAsFile()))).withStage(ICacheableJob.Staged.file("pack", this::pack, this.getOutput())).execute();
    }

    @Override
    protected List<RegularFileProperty> getCacheableOutputs() {
        List<RegularFileProperty> superCaches = super.getCacheableOutputs();
        superCaches.add(this.getStubs());
        return superCaches;
    }

    public void doExecute() throws Exception {
        if (this.getTransformers().isEmpty() && this.getInterfaceInjections().isEmpty() && this.getParchmentMappings().isEmpty()) {
            CopyingFileTreeVisitor visitor = new CopyingFileTreeVisitor(((Directory)this.getTransformed().get()).getAsFile().toPath());
            this.getArchiveOperations().zipTree((Object)this.getInputFile()).visit((FileVisitor)visitor);
            this.validateStubs();
            return;
        }
        super.doExecute();
        this.validateStubs();
    }

    private void validateStubs() throws IOException {
        File stubs = (File)this.getStubs().getAsFile().get();
        if (!stubs.exists()) {
            try (FileOutputStream stubsOutputStream = new FileOutputStream(stubs);){
                ZipOutputStream ignored = new ZipOutputStream(stubsOutputStream);
                ignored.close();
            }
        }
    }

    private void pack() throws IOException {
        ConfigurableFileTree outputTree = this.getObjectFactory().fileTree().from(this.getTransformed().get());
        try (FileOutputStream fos = new FileOutputStream(this.ensureFileWorkspaceReady(this.getOutput()));
             ZipOutputStream zos = new ZipOutputStream(fos);){
            ZipBuildingFileTreeVisitor visitor = new ZipBuildingFileTreeVisitor(zos);
            outputTree.visit((FileVisitor)visitor);
        }
    }

    @InputFile
    @PathSensitive(value=PathSensitivity.NONE)
    public abstract RegularFileProperty getInputFile();

    @InputFile
    @PathSensitive(value=PathSensitivity.NONE)
    public abstract RegularFileProperty getLibraries();

    @InputFiles
    @Optional
    @CompileClasspath
    public abstract ConfigurableFileCollection getClasspath();

    @InputFiles
    @Optional
    @PathSensitive(value=PathSensitivity.NONE)
    public abstract ConfigurableFileCollection getTransformers();

    @InputFiles
    @Optional
    @PathSensitive(value=PathSensitivity.NONE)
    public abstract ConfigurableFileCollection getInterfaceInjections();

    @InputFiles
    @Optional
    @PathSensitive(value=PathSensitivity.NONE)
    public abstract ConfigurableFileCollection getParchmentMappings();

    @Optional
    @Input
    public abstract Property<String> getParchmentConflictPrefix();

    @OutputFile
    public abstract RegularFileProperty getStubs();

    @OutputDirectory
    public abstract DirectoryProperty getTransformed();

    public Provider<FileTree> getOutputAsTree() {
        ObjectFactory factory = this.getObjectFactory();
        return this.getTransformed().map(it -> factory.fileTree().from(it));
    }
}

