/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.gradle.common.util;

import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import org.jetbrains.annotations.Nullable;

public class ListUtils {
    public static <E> int removeIfAndReturnIndex(List<E> collection, Predicate<E> filter) {
        Objects.requireNonNull(filter);
        Objects.requireNonNull(collection);
        int index = -1;
        for (int i = 0; i < collection.size(); ++i) {
            if (!filter.test(collection.get(i))) continue;
            index = i;
            break;
        }
        if (index != -1) {
            collection.remove(index);
        }
        return index;
    }

    @Nullable
    public static <E> E find(List<E> collection, Predicate<E> filter) {
        for (E e : collection) {
            if (!filter.test(e)) continue;
            return e;
        }
        return null;
    }
}

