/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.gradle.common.util;

import java.io.File;
import java.util.Locale;
import net.neoforged.gradle.common.tasks.ExtractBundledServerTask;
import net.neoforged.gradle.common.tasks.MinecraftArtifactFileCacheProvider;
import net.neoforged.gradle.common.tasks.MinecraftLauncherFileCacheProvider;
import net.neoforged.gradle.common.tasks.MinecraftVersionManifestFileCacheProvider;
import net.neoforged.gradle.dsl.common.tasks.WithOutput;
import net.neoforged.gradle.dsl.common.tasks.specifications.OutputSpecification;
import net.neoforged.gradle.dsl.common.util.CacheFileSelector;
import net.neoforged.gradle.dsl.common.util.GameArtifact;
import net.neoforged.gradle.dsl.common.util.MinecraftVersionAndUrl;
import org.apache.commons.lang3.StringUtils;
import org.gradle.api.Project;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.tasks.TaskProvider;
import org.jetbrains.annotations.NotNull;

public final class FileCacheUtils {
    private FileCacheUtils() {
        throw new IllegalStateException("Can not instantiate an instance of: FileCacheUtils. This is a utility class");
    }

    @NotNull
    public static TaskProvider<MinecraftLauncherFileCacheProvider> createLauncherMetadataFileCacheProvidingTask(Project project) {
        if (project.getTasks().getNames().contains("cacheLauncherMetadata")) {
            return project.getTasks().named("cacheLauncherMetadata", MinecraftLauncherFileCacheProvider.class);
        }
        return project.getTasks().register("cacheLauncherMetadata", MinecraftLauncherFileCacheProvider.class, task -> {});
    }

    @NotNull
    public static TaskProvider<MinecraftVersionManifestFileCacheProvider> createVersionManifestFileCacheProvidingTask(Project project, MinecraftVersionAndUrl resolvedVersion) {
        if (project.getTasks().getNames().contains("cacheVersionManifest" + resolvedVersion.getVersion())) {
            return project.getTasks().named("cacheVersionManifest" + resolvedVersion.getVersion(), MinecraftVersionManifestFileCacheProvider.class);
        }
        return project.getTasks().register("cacheVersionManifest" + resolvedVersion.getVersion(), MinecraftVersionManifestFileCacheProvider.class, task -> {
            task.getMinecraftVersion().set((Object)resolvedVersion.getVersion());
            task.getDownloadUrl().set((Object)resolvedVersion.getUrl());
        });
    }

    @NotNull
    public static TaskProvider<MinecraftArtifactFileCacheProvider> createArtifactFileCacheProvidingTask(Project project, String minecraftVersion, GameArtifact gameArtifact, TaskProvider<MinecraftVersionManifestFileCacheProvider> versionManifestProvider) {
        String taskName = "cacheVersion" + StringUtils.capitalize((String)gameArtifact.getMinecraftArtifact().name().toLowerCase(Locale.ROOT)) + StringUtils.capitalize((String)gameArtifact.getDistribution().getName().toLowerCase(Locale.ROOT)) + minecraftVersion;
        if (project.getTasks().getNames().contains(taskName)) {
            return project.getTasks().named(taskName, MinecraftArtifactFileCacheProvider.class);
        }
        CacheFileSelector selector = gameArtifact.getCacheSelectorForVersion(minecraftVersion);
        return project.getTasks().register(taskName, MinecraftArtifactFileCacheProvider.class, task -> {
            task.getManifest().set(versionManifestProvider.flatMap(OutputSpecification::getOutput));
            task.getArtifactType().set((Object)gameArtifact);
            task.getSelector().set((Object)selector);
        });
    }

    @NotNull
    public static TaskProvider<ExtractBundledServerTask> createExtractedServerFileCacheProvidingTask(Project project, String minecraftVersion, GameArtifact gameArtifact, TaskProvider<? extends WithOutput> bundledServerProvider) {
        String taskName = "cacheVersion" + StringUtils.capitalize((String)gameArtifact.getMinecraftArtifact().name().toLowerCase(Locale.ROOT)) + StringUtils.capitalize((String)gameArtifact.getDistribution().getName().toLowerCase(Locale.ROOT)) + minecraftVersion;
        if (project.getTasks().getNames().contains(taskName)) {
            return project.getTasks().named(taskName, ExtractBundledServerTask.class);
        }
        CacheFileSelector selector = gameArtifact.getCacheSelectorForVersion(minecraftVersion);
        return project.getTasks().register(taskName, ExtractBundledServerTask.class, task -> {
            task.getSelector().set((Object)selector);
            task.getMinecraftVersion().set((Object)minecraftVersion);
            task.getInput().set(bundledServerProvider.flatMap(OutputSpecification::getOutput));
        });
    }

    @NotNull
    public static DirectoryProperty getAssetsCacheDirectory(Project project) {
        return project.getObjects().directoryProperty().fileValue(new File(project.getGradle().getGradleUserHomeDir(), "caches/minecraft/assets"));
    }

    @NotNull
    public static DirectoryProperty getLibrariesCacheDirectory(Project project) {
        return project.getObjects().directoryProperty().fileValue(new File(project.getGradle().getGradleUserHomeDir(), "caches/minecraft/libraries"));
    }
}

