/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.gradle.common.accesstransformers;

import java.io.File;
import java.util.Comparator;
import java.util.List;
import net.neoforged.gradle.common.util.ProjectUtils;
import net.neoforged.gradle.dsl.common.extensions.AccessTransformers;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.attributes.Category;
import org.gradle.api.component.AdhocComponentWithVariants;

public class AccessTransformerPublishing {
    public static final String ACCESS_TRANSFORMER_ELEMENTS_CONFIGURATION = "accessTransformerElements";
    public static final String ACCESS_TRANSFORMER_API_CONFIGURATION = "accessTransformerApi";
    public static final String ACCESS_TRANSFORMER_CONFIGURATION = "accessTransformer";
    public static final String ACCESS_TRANSFORMER_CATEGORY = "accesstransformer";

    public static void setup(Project project) {
        AccessTransformers extension = (AccessTransformers)project.getExtensions().getByType(AccessTransformers.class);
        Configuration elementsConfig = (Configuration)project.getConfigurations().maybeCreate(ACCESS_TRANSFORMER_ELEMENTS_CONFIGURATION);
        Configuration apiConfig = (Configuration)project.getConfigurations().maybeCreate(ACCESS_TRANSFORMER_API_CONFIGURATION);
        Configuration implConfig = (Configuration)project.getConfigurations().maybeCreate(ACCESS_TRANSFORMER_CONFIGURATION);
        apiConfig.setCanBeConsumed(false);
        apiConfig.setCanBeResolved(false);
        implConfig.setCanBeConsumed(false);
        implConfig.setCanBeResolved(true);
        elementsConfig.setCanBeConsumed(true);
        elementsConfig.setCanBeResolved(false);
        elementsConfig.setCanBeDeclared(false);
        Action action = attributes -> attributes.attribute(Category.CATEGORY_ATTRIBUTE, (Object)((Category)project.getObjects().named(Category.class, ACCESS_TRANSFORMER_CATEGORY)));
        elementsConfig.attributes(action);
        implConfig.attributes(action);
        implConfig.extendsFrom(new Configuration[]{apiConfig});
        elementsConfig.extendsFrom(new Configuration[]{apiConfig});
        AdhocComponentWithVariants java = (AdhocComponentWithVariants)project.getComponents().getByName("java");
        Runnable enable = () -> java.addVariantsFromConfiguration(elementsConfig, variant -> {});
        elementsConfig.getAllDependencies().configureEach(dep -> enable.run());
        elementsConfig.getArtifacts().configureEach(artifact -> enable.run());
        extension.getFiles().from(new Object[]{implConfig});
        ProjectUtils.afterEvaluate(project, () -> {
            apiConfig.fromDependencyCollector(extension.getConsumeApi());
            implConfig.fromDependencyCollector(extension.getConsume());
            List<File> files = extension.getFiles().getFiles().stream().sorted(Comparator.comparing(File::getName)).toList();
            for (int i = 0; i < files.size(); ++i) {
                File file = files.get(i);
                if (files.size() == 1) {
                    extension.expose((Object)file, artifact -> artifact.setClassifier("access-transformer"));
                    continue;
                }
                int index = i;
                extension.expose((Object)file, artifact -> artifact.setClassifier("access-transformer-%d".formatted(index)));
            }
        });
    }
}

