/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.gradle.common.tasks;

import net.neoforged.gradle.common.services.caching.CachedExecutionService;
import net.neoforged.gradle.common.services.caching.jobs.ICacheableJob;
import net.neoforged.gradle.common.tasks.FileCacheProviding;
import net.neoforged.gradle.dsl.common.util.GameArtifact;
import org.gradle.api.Task;
import org.gradle.api.file.FileTree;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.services.ServiceReference;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;

@CacheableTask
public abstract class MinecraftArtifactFileCacheProvider
extends FileCacheProviding {
    @TaskAction
    public void doRun() throws Throwable {
        GameArtifact artifact = (GameArtifact)this.getArtifactType().get();
        ((CachedExecutionService)this.getCentralCacheService().get()).cached((Task)this, ICacheableJob.Default.file(() -> this.doDownloadVersionDownloadToCache(artifact.getMinecraftArtifact().createIdentifier(artifact.getDistribution()), String.format("Failed to download game artifact %s for %s", this.getArtifactType().get(), artifact.getDistribution()), ((RegularFile)this.getManifest().get()).getAsFile()), this.getOutput())).execute();
    }

    @ServiceReference(value="CachedExecutionService")
    public abstract Property<CachedExecutionService> getCentralCacheService();

    @Input
    public abstract Property<GameArtifact> getArtifactType();

    @InputFile
    @PathSensitive(value=PathSensitivity.NONE)
    public abstract RegularFileProperty getManifest();

    public Provider<FileTree> getOutputAsTree() {
        return this.getOutput().map(it -> this.getArchiveOperations().zipTree(it));
    }
}

