/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.gradle.common.extensions.repository;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.xml.stream.XMLStreamException;
import net.neoforged.gdi.ConfigurableDSLElement;
import net.neoforged.gradle.common.extensions.repository.IvyEntry;
import net.neoforged.gradle.common.extensions.repository.IvyMetadata;
import net.neoforged.gradle.common.extensions.repository.IvyModuleWriter;
import net.neoforged.gradle.common.util.ConfigurationPhaseFileUtils;
import net.neoforged.gradle.dsl.common.extensions.repository.Entry;
import net.neoforged.gradle.dsl.common.extensions.repository.EntryDefinition;
import net.neoforged.gradle.dsl.common.extensions.repository.Repository;
import net.neoforged.gradle.util.FileUtils;
import net.neoforged.gradle.util.ModuleDependencyUtils;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.ModuleDependency;
import org.gradle.api.artifacts.repositories.ArtifactRepository;
import org.gradle.api.artifacts.repositories.IvyArtifactRepository;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.Provider;
import org.jetbrains.annotations.NotNull;

public abstract class IvyRepository
implements ConfigurableDSLElement<Repository>,
Repository {
    public static final String GAV_PREFIX_DIRECTORY = "ng_dummy_ng";
    public static final String GAV_PREFIX = "ng_dummy_ng.";
    public static int METADATA_VERSION = 2;
    public static final String IVY_METADATA_PATTERN = "[organisation]/[module]/[revision]/ivy-[revision]-ng" + METADATA_VERSION + ".xml";
    private final Set<Entry> entries = Collections.synchronizedSet(new LinkedHashSet());
    private final Project project;
    private ArtifactRepository gradleRepository;

    @Inject
    public IvyRepository(Project project) {
        this.project = project;
        this.getRepositoryDirectory().convention(project.getLayout().getProjectDirectory().dir(".gradle/repositories"));
        this.enable();
    }

    public Project getProject() {
        return this.project;
    }

    private ArtifactRepository createRepositories() {
        IvyArtifactRepository repository = this.project.getRepositories().ivy(this.repositoryConfiguration("NeoGradle Artifacts", (Provider<Directory>)this.getRepositoryDirectory()));
        this.project.getRepositories().remove((Object)repository);
        this.project.getRepositories().addFirst((ArtifactRepository)repository);
        return repository;
    }

    @NotNull
    public abstract DirectoryProperty getRepositoryDirectory();

    public void enable() {
        if (this.gradleRepository != null) {
            throw new IllegalStateException("Repository already enabled");
        }
        this.gradleRepository = this.createRepositories();
    }

    private Action<IvyArtifactRepository> repositoryConfiguration(String name, Provider<Directory> root) {
        return ivy -> {
            File rootDir = ((Directory)root.get()).getAsFile();
            if (!ConfigurationPhaseFileUtils.exists(rootDir) && !ConfigurationPhaseFileUtils.mkdirs(rootDir)) {
                throw new IllegalStateException("Failed to create repository directory");
            }
            for (File file : Objects.requireNonNull(ConfigurationPhaseFileUtils.listFiles(rootDir, pathname -> pathname.isDirectory() && !pathname.getName().equals(GAV_PREFIX_DIRECTORY)))) {
                try {
                    FileUtils.delete((Path)file.toPath());
                }
                catch (IOException e) {
                    throw new RuntimeException("Failed to delete old repository directory", e);
                }
            }
            ivy.setName(name);
            ivy.setUrl(((Directory)root.get()).getAsFile().toURI());
            ivy.patternLayout(layout -> {
                layout.artifact("[organisation]/[module]/[revision]/[artifact]-[revision](-[classifier])(.[ext])");
                layout.ivy(IVY_METADATA_PATTERN);
                layout.setM2compatible(true);
            });
            ivy.setMetadataSupplier(IvyMetadata.class, params -> params.params(new Object[]{this.project.provider(() -> this.entries.stream().map(IvyMetadata.MetadataEntry::from).collect(Collectors.toSet()))}));
            ivy.setAllowInsecureProtocol(true);
            ivy.getResolve().setDynamicMode(false);
            ivy.metadataSources(IvyArtifactRepository.MetadataSources::ivyDescriptor);
        };
    }

    public Entry withEntry(EntryDefinition entryDefinition) {
        Entry.Builder builder = (Entry.Builder)this.project.getObjects().newInstance(IvyEntry.Builder.class, new Object[]{this.project});
        Entry entry = entryDefinition.createFrom(builder);
        this.create(entry);
        return entry;
    }

    public RegularFileProperty createOutputFor(Entry entry, Repository.Variant variant) {
        Path target = this.buildArtifactPath(entry.getDependency(), variant.adaptClassifier(ModuleDependencyUtils.getClassifierOrEmpty((Dependency)entry.getDependency())));
        return this.project.getObjects().fileProperty().fileValue(target.toFile());
    }

    public RegularFileProperty createOutputFor(Dependency dependency, Repository.Variant variant) {
        Path target = this.buildArtifactPath(dependency, variant.adaptClassifier(ModuleDependencyUtils.getClassifierOrEmpty((Dependency)dependency)));
        return this.project.getObjects().fileProperty().fileValue(target.toFile());
    }

    public boolean isDynamicDependency(ModuleDependency dependency) {
        return this.entries.stream().anyMatch(entry -> entry.getDependency().equals(dependency));
    }

    public Set<Entry> getEntries() {
        return Collections.unmodifiableSet(this.entries);
    }

    private void create(Entry entry) {
        if (!this.entries.add(entry)) {
            return;
        }
        this.write(entry);
    }

    private void write(Entry entry) {
        Dependency dependency = entry.getDependency();
        Configuration dependencies = entry.getDependencies();
        boolean hasSources = entry.hasSources();
        try {
            this.writeDummyDataIfNeeded(dependency, dependencies, hasSources);
        }
        catch (IOException | XMLStreamException e) {
            throw new RuntimeException("Failed to write dummy data", e);
        }
    }

    private void writeDummyDataIfNeeded(Dependency entry, Configuration dependencies, boolean hasSource) throws IOException, XMLStreamException {
        Path sourcesFile;
        Path jarFile = this.buildArtifactPath(entry);
        Path baseDir = jarFile.getParent();
        Path metaFile = baseDir.resolve(String.format("ivy-%s-ng%d.xml", entry.getVersion(), METADATA_VERSION));
        IvyRepository.writeIvyMetadataFile(entry, dependencies, baseDir, metaFile);
        if (!ConfigurationPhaseFileUtils.isRegularFile(jarFile, new LinkOption[0])) {
            FileUtils.delete((Path)jarFile);
            ConfigurationPhaseFileUtils.createEmptyZipFile(jarFile);
        }
        if (hasSource && !ConfigurationPhaseFileUtils.isRegularFile(sourcesFile = this.buildArtifactPath(entry, "sources"), new LinkOption[0])) {
            FileUtils.delete((Path)sourcesFile);
            ConfigurationPhaseFileUtils.createEmptyZipFile(sourcesFile);
        }
    }

    private static void writeIvyMetadataFile(Dependency entry, Configuration dependencies, Path baseDir, Path metaFile) throws IOException, XMLStreamException {
        Files.createDirectories(baseDir, new FileAttribute[0]);
        Path metaFileTmp = FileUtils.temporaryPath((Path)metaFile.getParent(), (String)"metadata");
        try (IvyModuleWriter writer = new IvyModuleWriter(metaFileTmp);){
            writer.write(entry, dependencies);
        }
        FileUtils.atomicMove((Path)metaFileTmp, (Path)metaFile);
    }

    public Path buildArtifactPath(Dependency dependency) {
        return ((Directory)this.getRepositoryDirectory().get()).getAsFile().toPath().resolve(this.buildArtifactInnerPath(dependency));
    }

    public String buildArtifactInnerPath(Dependency dependency) {
        String group = dependency.getGroup() == null ? "" : dependency.getGroup().replace('.', '/');
        String name = dependency.getName();
        String version = dependency.getVersion();
        String classifier = ModuleDependencyUtils.getClassifierOrEmpty((Dependency)dependency);
        String extension = ModuleDependencyUtils.getExtensionOrJar((Dependency)dependency);
        if (!classifier.isEmpty()) {
            return String.format("%s/%s/%s/%s-%s-%s.%s", group, name, version, name, version, classifier, extension);
        }
        return String.format("%s/%s/%s/%s-%s.%s", group, name, version, name, version, extension);
    }

    public Path buildArtifactPath(Dependency dependency, String classifier) {
        return ((Directory)this.getRepositoryDirectory().get()).getAsFile().toPath().resolve(this.buildArtifactInnerPath(dependency, classifier));
    }

    public String buildArtifactInnerPath(Dependency dependency, String classifier) {
        String group = dependency.getGroup() == null ? "" : dependency.getGroup().replace('.', '/');
        String name = dependency.getName();
        String version = dependency.getVersion();
        String extension = ModuleDependencyUtils.getExtensionOrJar((Dependency)dependency);
        if (!classifier.isEmpty()) {
            return String.format("%s/%s/%s/%s-%s-%s.%s", group, name, version, name, version, classifier, extension);
        }
        return String.format("%s/%s/%s/%s-%s.%s", group, name, version, name, version, extension);
    }
}

