/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.gradle.common.util;

import java.io.File;
import java.util.function.Function;
import java.util.function.Supplier;
import net.neoforged.gradle.common.util.ConfigurationUtils;
import net.neoforged.gradle.common.util.DependencyCollectorInjector;
import net.neoforged.gradle.dsl.common.extensions.subsystems.Subsystems;
import net.neoforged.gradle.dsl.common.extensions.subsystems.Tools;
import net.neoforged.gradle.util.ModuleDependencyUtils;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.ResolvedArtifact;
import org.gradle.api.artifacts.dsl.DependencyCollector;
import org.gradle.api.artifacts.dsl.DependencyHandler;
import org.gradle.api.artifacts.result.ResolvedArtifactResult;
import org.gradle.api.provider.Provider;

public class ToolUtilities {
    private ToolUtilities() {
        throw new IllegalStateException("Tried to create utility class!");
    }

    public static Provider<File> resolveTool(Project project, Function<Tools, Provider<String>> tool) {
        return ToolUtilities.resolveTool(project, tool.apply(((Subsystems)project.getExtensions().getByType(Subsystems.class)).getTools()));
    }

    public static Provider<File> resolveTool(Project project, Provider<String> tool) {
        DependencyCollectorInjector inject = (DependencyCollectorInjector)project.getObjects().newInstance(DependencyCollectorInjector.class, new Object[0]);
        DependencyCollector collector = inject.getDependencyCollector();
        collector.add(tool.map(arg_0 -> ((DependencyHandler)project.getDependencies()).create(arg_0)));
        Configuration config = ConfigurationUtils.temporaryUnhandledConfiguration(project.getConfigurations(), "Tool", new Dependency[0]);
        config.fromDependencyCollector(collector);
        return config.getIncoming().getArtifacts().getResolvedArtifacts().map(a -> (ResolvedArtifactResult)a.iterator().next()).map(ResolvedArtifactResult::getFile);
    }

    public static File resolveTool(Project project, String tool) {
        return ToolUtilities.resolveTool(() -> (File)ConfigurationUtils.temporaryUnhandledConfiguration(project.getConfigurations(), "ToolLookupFor" + ModuleDependencyUtils.toConfigurationName((String)tool), project.getDependencies().create((Object)tool)).getFiles().iterator().next());
    }

    public static ResolvedArtifact resolveToolArtifact(Project project, String tool) {
        return ToolUtilities.resolveTool(() -> (ResolvedArtifact)ConfigurationUtils.temporaryUnhandledConfiguration(project.getConfigurations(), "ToolLookupFor" + ModuleDependencyUtils.toConfigurationName((String)tool), project.getDependencies().create((Object)tool)).getResolvedConfiguration().getResolvedArtifacts().iterator().next());
    }

    public static ResolvedArtifact resolveToolArtifact(Project project, Dependency tool) {
        return ToolUtilities.resolveTool(() -> (ResolvedArtifact)ConfigurationUtils.temporaryUnhandledConfiguration(project.getConfigurations(), "ToolLookupFor" + ModuleDependencyUtils.toConfigurationName((Dependency)tool), tool).getResolvedConfiguration().getResolvedArtifacts().iterator().next());
    }

    public static Configuration resolveConfigurationFor(Project project, String tool) {
        return ConfigurationUtils.temporaryUnhandledConfiguration(project.getConfigurations(), "ToolLookupFor" + ModuleDependencyUtils.toConfigurationName((String)tool), project.getDependencies().create((Object)tool));
    }

    private static <T> T resolveTool(Supplier<T> searcher) {
        return searcher.get();
    }
}

