/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.gradle.common.dependency;

import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.inject.Inject;
import net.neoforged.gradle.common.extensions.problems.IProblemReporter;
import net.neoforged.gradle.common.extensions.problems.NeoGradleProblemSpec;
import net.neoforged.gradle.common.runtime.tasks.GenerateExtraJar;
import net.neoforged.gradle.common.util.ConfigurationUtils;
import net.neoforged.gradle.dsl.common.extensions.MinecraftArtifactCache;
import net.neoforged.gradle.dsl.common.extensions.dependency.replacement.DependencyReplacement;
import net.neoforged.gradle.dsl.common.extensions.dependency.replacement.ReplacementResult;
import net.neoforged.gradle.dsl.common.tasks.specifications.OutputSpecification;
import net.neoforged.gradle.dsl.common.util.DistributionType;
import net.neoforged.gradle.dsl.common.util.GameArtifact;
import org.apache.commons.lang3.StringUtils;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.DependencyArtifact;
import org.gradle.api.artifacts.ExternalModuleDependency;
import org.gradle.api.tasks.TaskProvider;

public abstract class ExtraJarDependencyManager {
    private final Map<String, ReplacementResult> replacements = Maps.newHashMap();

    public static String generateClientCoordinateFor(String version) {
        return "net.minecraft:client:" + version + ":client-extra";
    }

    public static String generateServerCoordinateFor(String version) {
        return "net.minecraft:client:" + version + ":client-extra";
    }

    public static String generateCoordinateFor(DistributionType type, String version) {
        return String.format("net.minecraft:%s:%s:%s-extra", type.getName().toLowerCase(Locale.ROOT), version, type.getName().toLowerCase(Locale.ROOT));
    }

    @Inject
    public ExtraJarDependencyManager(Project project) {
        DependencyReplacement dependencyReplacementsExtension = (DependencyReplacement)project.getExtensions().getByType(DependencyReplacement.class);
        dependencyReplacementsExtension.getReplacementHandlers().register("extraJar", dependencyReplacementHandler -> dependencyReplacementHandler.getReplacer().set(context -> {
            if (this.isNotAMatchingDependency((Dependency)context.getDependency())) {
                return Optional.empty();
            }
            return Optional.of(this.generateReplacement(project, (Dependency)context.getDependency()));
        }));
    }

    private boolean isNotAMatchingDependency(Dependency dependencyToCheck) {
        if (dependencyToCheck instanceof ExternalModuleDependency) {
            ExternalModuleDependency externalModuleDependency = (ExternalModuleDependency)dependencyToCheck;
            return externalModuleDependency.getGroup() == null || !externalModuleDependency.getGroup().equals("net.minecraft") || !this.isSupportedSide(dependencyToCheck) || !this.hasMatchingArtifact(externalModuleDependency);
        }
        return true;
    }

    private boolean isSupportedSide(Dependency dependency) {
        return dependency.getName().equals("client") || dependency.getName().equals("server");
    }

    private boolean hasMatchingArtifact(ExternalModuleDependency externalModuleDependency) {
        if (externalModuleDependency.getVersion() == null) {
            return false;
        }
        if (externalModuleDependency.getArtifacts().size() != 1) {
            return false;
        }
        DependencyArtifact artifact = (DependencyArtifact)externalModuleDependency.getArtifacts().iterator().next();
        return Objects.equals(artifact.getClassifier(), "client-extra") || Objects.equals(artifact.getClassifier(), "server-extra");
    }

    private ReplacementResult generateReplacement(Project project, Dependency dependency) {
        String minecraftVersion = dependency.getVersion();
        if (minecraftVersion == null) {
            IProblemReporter problemReporter = (IProblemReporter)project.getExtensions().getByType(IProblemReporter.class);
            throw problemReporter.throwing((Action<NeoGradleProblemSpec>)((Action)spec -> spec.id("dependencies.extra-jar", "missingVersion").contextualLabel("Client-Extra Jar: Missing Version").details("The dependency %s does not have a version specified".formatted(dependency)).solution("Specify a version for the dependency").section("common-dep-management-extra-jar")));
        }
        return this.replacements.computeIfAbsent(minecraftVersion, v -> {
            MinecraftArtifactCache minecraftArtifactCacheExtension = (MinecraftArtifactCache)project.getExtensions().getByType(MinecraftArtifactCache.class);
            Map tasks = minecraftArtifactCacheExtension.cacheGameVersionTasks(project, minecraftVersion, DistributionType.JOINED);
            TaskProvider extraJarTaskProvider = project.getTasks().register("create" + minecraftVersion + StringUtils.capitalize((String)dependency.getName()) + "ExtraJar", GenerateExtraJar.class, task -> {
                task.getOriginalJar().set(((TaskProvider)tasks.get(GameArtifact.CLIENT_JAR)).flatMap(OutputSpecification::getOutput));
                task.getServerJar().set(((TaskProvider)tasks.get(GameArtifact.EXTRACTED_SERVER_JAR)).flatMap(OutputSpecification::getOutput));
                task.getMappings().set(((TaskProvider)tasks.get(GameArtifact.CLIENT_MAPPINGS)).flatMap(OutputSpecification::getOutput));
                task.getOutput().set(project.getLayout().getBuildDirectory().dir("jars/extra/" + dependency.getName()).map(cacheDir -> cacheDir.dir(Objects.requireNonNull(minecraftVersion)).file(dependency.getName() + "-extra.jar")));
            });
            return new ReplacementResult(project, extraJarTaskProvider, project.getConfigurations().detachedConfiguration(new Dependency[0]), ConfigurationUtils.temporaryUnhandledConfiguration(project.getConfigurations(), "EmptyExtraJarConfigurationFor" + minecraftVersion.replace(".", "_"), new Dependency[0]), Collections.emptySet());
        });
    }
}

