/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.gradle.common.services.caching.cache;

import java.io.File;
import java.io.IOException;
import java.util.List;
import net.neoforged.gradle.common.services.caching.cache.ICache;
import net.neoforged.gradle.common.services.caching.jobs.ICacheableJob;
import net.neoforged.gradle.common.services.caching.locking.FileBasedLock;
import net.neoforged.gradle.common.services.caching.locking.LockManager;
import net.neoforged.gradle.common.services.caching.logging.CacheLogger;
import net.neoforged.gradle.common.util.hash.Hashing;
import org.apache.commons.io.FileUtils;
import org.gradle.api.GradleException;

public class DirectoryCache
implements ICache {
    private final File cacheDir;
    private final boolean merge;

    public DirectoryCache(File cacheDir, boolean merge) {
        this.cacheDir = cacheDir;
        this.merge = merge;
    }

    @Override
    public void loadFrom(List<ICacheableJob.OutputEntry> file) throws IOException {
        for (ICacheableJob.OutputEntry file1 : file) {
            this.loadFrom(file1);
        }
    }

    public void loadFrom(ICacheableJob.OutputEntry file) throws IOException {
        if (file.output().exists()) {
            File output = new File(this.cacheDir, file.output().getName());
            if (!output.exists()) {
                output.mkdirs();
            }
            FileUtils.cleanDirectory((File)output);
            FileUtils.copyDirectory((File)file.output(), (File)output);
        }
    }

    @Override
    public boolean restoreTo(List<ICacheableJob.OutputEntry> file) throws IOException {
        boolean restored = true;
        for (ICacheableJob.OutputEntry file1 : file) {
            if (this.restoreTo(file1)) continue;
            restored = false;
        }
        return restored;
    }

    public boolean restoreTo(ICacheableJob.OutputEntry file) throws IOException {
        File output = new File(this.cacheDir, file.output().getName());
        if (file.output().exists()) {
            if (file.isDirectory() && output.exists() && Hashing.hashDirectory(file.output()).equals(Hashing.hashDirectory(output))) {
                return false;
            }
            if (file.isDirectory() && !this.merge) {
                FileUtils.cleanDirectory((File)file.output());
            }
            if (file.output().isFile() || !this.merge) {
                file.output().delete();
            }
        }
        file.output().mkdirs();
        if (output.exists()) {
            try {
                FileUtils.copyDirectory((File)output, (File)file.output());
            }
            catch (IOException e) {
                throw new GradleException("Failed to restore cache.", (Throwable)e);
            }
        }
        return true;
    }

    @Override
    public FileBasedLock createLock(CacheLogger logger) {
        return LockManager.createLock(this.cacheDir, logger);
    }

    @Override
    public boolean canRestore(List<ICacheableJob.OutputEntry> output) {
        boolean restoreable = true;
        for (ICacheableJob.OutputEntry file : output) {
            if (this.canRestore(file)) continue;
            restoreable = false;
        }
        return restoreable;
    }

    public boolean canRestore(ICacheableJob.OutputEntry file) {
        File output = new File(this.cacheDir, file.output().getName());
        return output.exists() && output.isDirectory();
    }
}

