/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.gradle.common.runtime.tasks;

import com.google.common.collect.Lists;
import java.io.File;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.ArrayList;
import net.neoforged.gradle.common.runtime.tasks.DefaultExecute;
import net.neoforged.gradle.common.util.ToolUtilities;
import net.neoforged.gradle.dsl.common.extensions.subsystems.Tools;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;

@CacheableTask
public abstract class BinaryAccessTransformer
extends DefaultExecute {
    public BinaryAccessTransformer() {
        this.setDescription("Runs the access transformer on the decompiled sources.");
        this.getExecutingJar().fileProvider(ToolUtilities.resolveTool(this.getProject(), Tools::getAccessTransformer));
        this.getRuntimeProgramArguments().convention(this.getInputFile().map(inputFile -> {
            ArrayList args = Lists.newArrayList();
            File outputFile = this.ensureFileWorkspaceReady(this.getOutput());
            args.add("--inJar");
            args.add(inputFile.getAsFile().getAbsolutePath());
            args.add("--outJar");
            args.add(outputFile.getAbsolutePath());
            this.getTransformers().forEach(f -> {
                args.add("--atFile");
                args.add(f.getAbsolutePath());
            });
            return args;
        }));
        this.getTransformers().finalizeValueOnRead();
    }

    @InputFile
    @PathSensitive(value=PathSensitivity.NONE)
    public abstract RegularFileProperty getInputFile();

    @InputFiles
    @PathSensitive(value=PathSensitivity.NONE)
    public abstract ConfigurableFileCollection getTransformers();

    public void doExecute() throws Exception {
        if (this.getTransformers().isEmpty()) {
            Files.copy(((RegularFile)this.getInputFile().get()).getAsFile().toPath(), ((RegularFile)this.getOutput().get()).getAsFile().toPath(), new CopyOption[0]);
            return;
        }
        super.doExecute();
    }
}

