/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.gradle.common.services.caching.cache;

import java.io.File;
import java.io.IOException;
import java.util.List;
import net.neoforged.gradle.common.services.caching.cache.ICache;
import net.neoforged.gradle.common.services.caching.jobs.ICacheableJob;
import net.neoforged.gradle.common.services.caching.locking.FileBasedLock;
import net.neoforged.gradle.common.services.caching.locking.LockManager;
import net.neoforged.gradle.common.services.caching.logging.CacheLogger;
import net.neoforged.gradle.common.util.hash.Hashing;
import org.apache.commons.io.FileUtils;
import org.gradle.api.GradleException;

public class FileCache
implements ICache {
    private final File cacheDir;

    public FileCache(File cacheDir) {
        this.cacheDir = cacheDir;
    }

    @Override
    public void loadFrom(List<ICacheableJob.OutputEntry> file) throws IOException {
        for (ICacheableJob.OutputEntry file1 : file) {
            this.loadFrom(file1);
        }
    }

    public void loadFrom(ICacheableJob.OutputEntry file) throws IOException {
        File cacheFile = new File(this.cacheDir, file.output().getName());
        if (cacheFile.exists()) {
            cacheFile.delete();
        }
        if (!file.output().exists()) {
            return;
        }
        FileUtils.copyFile((File)file.output(), (File)cacheFile);
    }

    @Override
    public boolean restoreTo(List<ICacheableJob.OutputEntry> file) throws IOException {
        boolean restored = false;
        for (ICacheableJob.OutputEntry file1 : file) {
            restored = this.restoreTo(file1);
        }
        return restored;
    }

    public boolean restoreTo(ICacheableJob.OutputEntry file) throws IOException {
        File cacheFile = new File(this.cacheDir, file.output().getName());
        if (file.output().exists()) {
            if (file.output().isFile() && cacheFile.exists() && Hashing.hashFile(file.output()).equals(Hashing.hashFile(cacheFile))) {
                return false;
            }
            if (file.isDirectory()) {
                FileUtils.cleanDirectory((File)file.output());
            }
            file.output().delete();
        }
        if (cacheFile.exists()) {
            try {
                FileUtils.copyFile((File)cacheFile, (File)file.output());
            }
            catch (IOException e) {
                throw new GradleException("Failed to restore cache. Copying of the cache file failed.", (Throwable)e);
            }
        }
        return true;
    }

    @Override
    public FileBasedLock createLock(CacheLogger logger) {
        return LockManager.createLock(this.cacheDir, logger);
    }

    @Override
    public boolean canRestore(List<ICacheableJob.OutputEntry> output) {
        boolean restoreable = true;
        for (ICacheableJob.OutputEntry file : output) {
            if (this.canRestore(file)) continue;
            restoreable = false;
        }
        return restoreable;
    }

    public boolean canRestore(ICacheableJob.OutputEntry file) {
        File cacheFile = new File(this.cacheDir, file.output().getName());
        return cacheFile.exists() && cacheFile.isFile();
    }
}

