/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.gradle.common.runtime.tasks;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Stream;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticListener;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.StandardLocation;
import javax.tools.ToolProvider;
import net.neoforged.gradle.common.runtime.tasks.DefaultRuntime;
import net.neoforged.gradle.common.services.caching.CachedExecutionService;
import net.neoforged.gradle.common.services.caching.jobs.ICacheableJob;
import net.neoforged.gradle.util.CopyingFileTreeVisitor;
import org.gradle.api.GradleException;
import org.gradle.api.Task;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileVisitor;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.services.ServiceReference;
import org.gradle.api.tasks.CompileClasspath;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;
import org.gradle.jvm.toolchain.JavaLanguageVersion;

public abstract class InProcessSourceJarRecompiler
extends DefaultRuntime {
    @InputFile
    public abstract RegularFileProperty getSourceToCompile();

    @InputFiles
    @Optional
    @CompileClasspath
    public abstract ConfigurableFileCollection getAdditionalSources();

    @InputFiles
    @Optional
    @CompileClasspath
    public abstract ConfigurableFileCollection getClasspath();

    @Override
    @Nested
    @Optional
    public abstract Property<JavaLanguageVersion> getJavaVersion();

    @InputFiles
    @PathSensitive(value=PathSensitivity.NONE)
    @Optional
    public abstract ConfigurableFileCollection getResources();

    @ServiceReference(value="CachedExecutionService")
    public abstract Property<CachedExecutionService> getCacheService();

    @TaskAction
    public void compile() {
        try {
            ((CachedExecutionService)this.getCacheService().get()).cached((Task)this, ICacheableJob.Default.file(this::doCompile, this.getOutput())).execute();
        }
        catch (IOException e) {
            throw new GradleException("Failed to recompile!", (Throwable)e);
        }
    }

    private void doCompile() throws Exception {
        Path sources = ((RegularFile)this.getSourceToCompile().get()).getAsFile().toPath();
        List<Path> additionalSources = this.getAdditionalSources().getFiles().stream().map(File::toPath).toList();
        List<Path> compileClasspath = this.getClasspath().getFiles().stream().map(File::toPath).toList();
        URI uri = URI.create("jar:" + String.valueOf(sources.toUri()));
        try (FileSystem sourceFs = FileSystems.newFileSystem(uri, Map.of());){
            JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
            long start = System.currentTimeMillis();
            Path sourceRoot = sourceFs.getRootDirectories().iterator().next();
            ArrayList sourcePaths = new ArrayList();
            ArrayList nonSourcePaths = new ArrayList();
            try (Stream<Path> stream = Files.walk(sourceRoot, new FileVisitOption[0]).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0]));){
                stream.forEach(path -> {
                    String filename = path.getFileName().toString();
                    if (filename.endsWith(".java")) {
                        sourcePaths.add(path);
                    } else {
                        nonSourcePaths.add(path);
                    }
                });
            }
            this.getLogger().error(" Compiling {} source files", (Object)sourcePaths.size());
            DiagnosticListener<JavaFileObject> diagnostics = new DiagnosticListener<JavaFileObject>(){

                @Override
                public void report(Diagnostic<? extends JavaFileObject> d) {
                    if (d.getKind() != Diagnostic.Kind.ERROR) {
                        return;
                    }
                    String location = d.getSource() != null ? d.getSource().getName() : "<unknown>";
                    InProcessSourceJarRecompiler.this.getLogger().error(" {} Line: {}, {} in {}", new Object[]{d.getKind(), d.getLineNumber(), d.getMessage(null), location});
                }
            };
            long prepare = System.currentTimeMillis();
            this.getLogger().error("Complete compile prepare in: {}ms.", (Object)(prepare - start));
            Path outputPath = ((RegularFile)this.getOutput().get()).getAsFile().toPath();
            try (FileSystem outputFs = FileSystems.newFileSystem(URI.create("jar:" + String.valueOf(outputPath.toUri())), Map.of("create", true));){
                Path outputRoot = outputFs.getRootDirectories().iterator().next();
                try (StandardJavaFileManager fileManager = compiler.getStandardFileManager((DiagnosticListener<? super JavaFileObject>)diagnostics, Locale.ROOT, StandardCharsets.UTF_8);){
                    fileManager.setLocationFromPaths(StandardLocation.CLASS_OUTPUT, Collections.singleton(outputRoot));
                    fileManager.setLocationFromPaths(StandardLocation.CLASS_PATH, compileClasspath);
                    fileManager.setLocationFromPaths(StandardLocation.SOURCE_PATH, additionalSources);
                    Iterable<? extends JavaFileObject> sourceJavaFiles = fileManager.getJavaFileObjectsFromPaths(sourcePaths);
                    JavaCompiler.CompilationTask task = compiler.getTask(null, fileManager, (DiagnosticListener<? super JavaFileObject>)diagnostics, this.getCompilerOptions(), null, sourceJavaFiles);
                    if (!task.call().booleanValue()) {
                        throw new IOException("Compilation failed");
                    }
                }
                long compiled = System.currentTimeMillis();
                this.getLogger().error("Completed compile in: {}ms.", (Object)(compiled - prepare));
                for (Path nonSourcePath : nonSourcePaths) {
                    String relativeDestinationPath = sourceRoot.relativize(nonSourcePath).toString().replace('\\', '/');
                    Path destination = outputRoot.resolve(relativeDestinationPath);
                    Files.createDirectories(destination.getParent(), new FileAttribute[0]);
                    Files.copy(nonSourcePath, destination, new CopyOption[0]);
                }
                this.getLogger().error("Copied {} none source files", (Object)nonSourcePaths.size());
                long noneSourceFiles = System.currentTimeMillis();
                this.getLogger().error("Completed none source processing: {}ms.", (Object)(noneSourceFiles - compiled));
                CopyingFileTreeVisitor visitor = new CopyingFileTreeVisitor(outputRoot, true, false);
                this.getResources().getAsFileTree().visit((FileVisitor)visitor);
                this.getLogger().error("Copied {} resource files", (Object)this.getResources().getFiles().size());
                this.getLogger().error("Complete compile: {}ms.", (Object)(System.currentTimeMillis() - start));
            }
        }
    }

    private List<String> getCompilerOptions() {
        return List.of("--release", ((JavaLanguageVersion)this.getJavaVersion().get()).toString(), "-proc:none", "-nowarn", "-g", "-XDuseUnsharedTable=true", "-implicit:none");
    }
}

