/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.gradle.common.rules;

import net.neoforged.gradle.dsl.common.extensions.subsystems.Conventions;
import net.neoforged.gradle.dsl.common.extensions.subsystems.Subsystems;
import net.neoforged.gradle.dsl.common.runs.run.Run;
import net.neoforged.gradle.dsl.common.runs.run.RunManager;
import org.gradle.api.Project;
import org.gradle.api.Rule;

public class LaterAddedReplacedDependencyRule
implements Rule {
    private final Project project;
    private final RunManager runs;

    public LaterAddedReplacedDependencyRule(Project project) {
        this.runs = (RunManager)project.getExtensions().getByType(RunManager.class);
        this.project = project;
    }

    public String getDescription() {
        return "Pattern run<RunName>: Runs the specified run.";
    }

    public void apply(String domainObjectName) {
        String decapitalizedRunName;
        String runName;
        Run run;
        if (!domainObjectName.startsWith("run")) {
            return;
        }
        if (domainObjectName.length() < 4 || !Character.isUpperCase(domainObjectName.charAt(3))) {
            return;
        }
        Conventions conventions = ((Subsystems)this.project.getExtensions().getByType(Subsystems.class)).getConventions();
        if (((Boolean)conventions.getIsEnabled().get()).booleanValue() && ((Boolean)conventions.getRuns().getIsEnabled().get()).booleanValue() && ((Boolean)conventions.getRuns().getShouldDefaultRunsBeCreated().get()).booleanValue() && (run = (Run)this.runs.findByName(runName = domainObjectName.substring(3))) == null && (run = (Run)this.runs.findByName(decapitalizedRunName = runName.substring(0, 1).toLowerCase() + runName.substring(1))) == null) {
            this.runs.create(decapitalizedRunName);
        }
    }
}

