/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.gradle.common.extensions;

import groovy.lang.MissingMethodException;
import javax.inject.Inject;
import net.neoforged.gdi.ConfigurableDSLElement;
import net.neoforged.gradle.dsl.common.extensions.Mappings;
import net.neoforged.gradle.dsl.common.extensions.Minecraft;
import org.gradle.api.Project;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class MappingsExtension
implements ConfigurableDSLElement<Mappings>,
Mappings {
    private static final Logger LOGGER = LoggerFactory.getLogger(MappingsExtension.class);
    private final Project project;
    private final Minecraft minecraftExtension;

    @Inject
    public MappingsExtension(Project project) {
        this.project = project;
        this.minecraftExtension = (Minecraft)project.getExtensions().getByType(Minecraft.class);
    }

    public Project getProject() {
        return this.project;
    }

    public Minecraft getMinecraft() {
        return this.minecraftExtension;
    }

    public void version(String version) {
        this.getVersion().put((Object)"version", (Object)version);
    }

    public Object methodMissing(String name, Object args) {
        if (this.getMinecraft().getNamingChannels().findByName(name) != null) {
            LOGGER.info("Getting mappings from channel provider {}", (Object)name);
            return this.getMinecraft().getNamingChannels().named(name);
        }
        throw new MissingMethodException(name, this.getClass(), new Object[]{args});
    }
}

