/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.gradle.common.extensions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import javax.inject.Inject;
import net.neoforged.gradle.common.tasks.JarJar;
import net.neoforged.gradle.dsl.common.extensions.JarJarFeature;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.PublishArtifact;
import org.gradle.api.attributes.Bundling;
import org.gradle.api.attributes.Category;
import org.gradle.api.attributes.LibraryElements;
import org.gradle.api.attributes.Usage;
import org.gradle.api.attributes.java.TargetJvmVersion;
import org.gradle.api.plugins.JavaPluginExtension;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.api.tasks.bundling.Jar;
import org.gradle.jvm.toolchain.JavaLanguageVersion;

public class DefaultJarJarFeature
implements JarJarFeature {
    public static final String JAR_JAR_TASK_NAME = "jarJar";
    public static final String JAR_JAR_GROUP = "jarjar";
    public static final String JAR_JAR_DEFAULT_CONFIGURATION_NAME = "jarJar";
    protected final Project project;
    protected final String prefix;
    private boolean disabled;
    private boolean enabled;
    private boolean disableDefaultSources;
    private PublishArtifact addedToPublication;
    private final List<PublishArtifact> removedFromPublication = new ArrayList<PublishArtifact>();

    @Inject
    public DefaultJarJarFeature(Project project, String prefix) {
        this.project = project;
        this.prefix = prefix;
    }

    public void enable() {
        if (!this.disabled) {
            this.enable(true);
        }
    }

    private void enable(boolean enabled) {
        if (this.enabled == enabled) {
            return;
        }
        this.enabled = enabled;
        JarJar task = (JarJar)this.project.getTasks().findByPath(this.withPrefix("jarJar"));
        Configuration runtimeElements = (Configuration)this.project.getConfigurations().findByName(this.withPrefix("runtimeElements"));
        if (task != null) {
            if (runtimeElements != null) {
                if (enabled) {
                    this.removedFromPublication.clear();
                    this.removedFromPublication.addAll((Collection<PublishArtifact>)runtimeElements.getArtifacts());
                    runtimeElements.getArtifacts().clear();
                    this.project.artifacts(handler -> {
                        this.addedToPublication = handler.add(this.withPrefix("runtimeElements"), (Object)task, artifact -> artifact.builtBy(new Object[]{task}));
                    });
                } else {
                    runtimeElements.getArtifacts().remove((Object)this.addedToPublication);
                    runtimeElements.getArtifacts().addAll(this.removedFromPublication);
                }
            }
            if (!task.getEnabled() == enabled) {
                task.setEnabled(enabled);
            }
        }
    }

    public void disable() {
        this.disable(true);
    }

    public void disable(boolean disable) {
        this.disabled = disable;
        if (disable) {
            this.enable(false);
        }
    }

    public boolean getDefaultSourcesDisabled() {
        return this.disableDefaultSources;
    }

    public void disableDefaultSources() {
        this.disableDefaultSources(true);
    }

    public void disableDefaultSources(boolean value) {
        this.disableDefaultSources = value;
    }

    protected String withPrefix(String name) {
        if (this.prefix.isEmpty()) {
            return name;
        }
        return this.prefix + name.substring(0, 1).toUpperCase(Locale.ROOT) + name.substring(1);
    }

    public void createTaskAndConfiguration() {
        Configuration configuration = (Configuration)this.project.getConfigurations().create(this.withPrefix("jarJar"));
        configuration.setTransitive(false);
        configuration.getAllDependencies().configureEach(dep -> this.enable());
        configuration.setCanBeResolved(true);
        configuration.setCanBeConsumed(false);
        JavaPluginExtension javaPlugin = (JavaPluginExtension)this.project.getExtensions().getByType(JavaPluginExtension.class);
        configuration.attributes(attributes -> {
            attributes.attributeProvider(TargetJvmVersion.TARGET_JVM_VERSION_ATTRIBUTE, javaPlugin.getToolchain().getLanguageVersion().map(JavaLanguageVersion::asInt));
            attributes.attribute(Usage.USAGE_ATTRIBUTE, (Object)((Usage)this.project.getObjects().named(Usage.class, "java-runtime")));
            attributes.attribute(LibraryElements.LIBRARY_ELEMENTS_ATTRIBUTE, (Object)((LibraryElements)this.project.getObjects().named(LibraryElements.class, "jar")));
            attributes.attribute(Category.CATEGORY_ATTRIBUTE, (Object)((Category)this.project.getObjects().named(Category.class, "library")));
            attributes.attribute(Bundling.BUNDLING_ATTRIBUTE, (Object)((Bundling)this.project.getObjects().named(Bundling.class, "external")));
        });
        TaskProvider jarJarTask = this.project.getTasks().register(this.withPrefix("jarJar"), JarJar.class, jarJar -> {
            jarJar.setGroup(JAR_JAR_GROUP);
            jarJar.setDescription("Create a combined JAR of project and selected dependencies");
            jarJar.getArchiveClassifier().convention(this.prefix.isEmpty() ? "all" : this.prefix + "-all");
            if (!this.getDefaultSourcesDisabled()) {
                Jar jarTask = (Jar)this.project.getTasks().getByName(this.withPrefix("jar"));
                jarJar.dependsOn(new Object[]{jarTask});
                jarJar.getManifest().inheritFrom(jarTask.getManifest());
                jarJar.from(new Object[]{this.project.zipTree((Object)jarTask.getArchiveFile()).matching(patternFilterable -> patternFilterable.exclude(new String[]{"META-INF/MANIFEST.MF"}))});
            }
            jarJar.configuration(configuration);
            jarJar.setEnabled(false);
        });
        this.project.getTasks().named("assemble", t -> t.dependsOn(new Object[]{jarJarTask}));
    }
}

