/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.gradle.common.util;

import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class StreamUtils {
    private static <T> Spliterator<T> takeWhile(final Spliterator<T> splitr, final Predicate<? super T> predicate) {
        return new Spliterators.AbstractSpliterator<T>(splitr.estimateSize(), 0){
            boolean stillGoing;
            {
                super(arg0, arg1);
                this.stillGoing = true;
            }

            @Override
            public boolean tryAdvance(Consumer<? super T> consumer) {
                if (this.stillGoing) {
                    boolean hadNext = splitr.tryAdvance(elem -> {
                        if (predicate.test(elem)) {
                            consumer.accept(elem);
                        } else {
                            this.stillGoing = false;
                        }
                    });
                    return hadNext && this.stillGoing;
                }
                return false;
            }
        };
    }

    public static <T> Stream<T> takeWhile(Stream<T> stream, Predicate<? super T> predicate) {
        return StreamSupport.stream(StreamUtils.takeWhile(stream.spliterator(), predicate), false);
    }
}

