/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.gradle.common.runtime.tasks;

import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.inject.Inject;
import net.neoforged.gradle.dsl.common.runtime.tasks.NamedDirectory;
import net.neoforged.gradle.dsl.common.runtime.tasks.NamedDirectoryFile;
import net.neoforged.gradle.dsl.common.runtime.tasks.NamedFile;
import net.neoforged.gradle.dsl.common.runtime.tasks.NamedFileRef;
import net.neoforged.gradle.dsl.common.runtime.tasks.NamedRegularFile;
import net.neoforged.gradle.dsl.common.runtime.tasks.RuntimeArguments;
import org.gradle.api.file.Directory;
import org.gradle.api.file.RegularFile;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderFactory;

public abstract class RuntimeArgumentsImpl
implements RuntimeArguments {
    private final ProviderFactory providerFactory;

    @Inject
    public RuntimeArgumentsImpl(ProviderFactory providerFactory) {
        this.providerFactory = providerFactory;
    }

    public Provider<String> get(String key) {
        return this.getSimple().zip((Provider)this.getFiles(), (simple, files) -> {
            Optional<NamedFileRef> namedFile = files.stream().filter(f -> f.getName().equals(key)).findFirst();
            if (simple.containsKey(key) && namedFile.isPresent()) {
                throw new IllegalArgumentException("Cannot have both a simple and file argument for key: " + key);
            }
            if (simple.containsKey(key)) {
                return (String)simple.get(key);
            }
            return namedFile.map(file -> file.getFile().getAbsolutePath()).orElse(null);
        });
    }

    public Provider<String> getOrDefault(String key, Provider<String> defaultProvider) {
        return this.get(key).orElse(defaultProvider);
    }

    public Provider<Map<String, Provider<String>>> asMap() {
        Provider simpleProvider = this.getSimple().map(Map::keySet).map(keySet -> keySet.stream().collect(Collectors.toMap(key -> key, key -> this.getSimple().getting(key))));
        Provider filesProvider = this.getFiles().map(files -> files.stream().collect(Collectors.toMap(NamedFileRef::getName, namedFiles -> this.providerFactory.provider(() -> namedFiles.getFile().getAbsolutePath()), (a, b) -> b, HashMap::new)));
        return simpleProvider.zip(filesProvider, (simple, files) -> ImmutableMap.builder().putAll(simple).putAll(files).build());
    }

    public void putFile(String input, Provider<File> fileProvider) {
        this.getFiles().add(fileProvider.map(file -> new NamedFile(input, file)));
    }

    public void putRegularFile(String input, Provider<RegularFile> fileProvider) {
        this.getFiles().add((Object)new NamedRegularFile(input, fileProvider));
    }

    public void putDirectoryFile(String input, Provider<File> fileProvider) {
        this.getFiles().add(fileProvider.map(file -> new NamedDirectoryFile(input, file)));
    }

    public void putDirectory(String input, Provider<Directory> fileProvider) {
        this.getFiles().add((Object)new NamedDirectory(input, fileProvider));
    }

    public void put(String input, Provider<String> stringProvider) {
        this.getSimple().put((Object)input, stringProvider);
    }
}

